/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.fourstate.AbstractFourStateBean;
import org.krysalis.barcode4j.impl.fourstate.FourStateLogicHandler;
import org.krysalis.barcode4j.impl.fourstate.RoyalMailCBCLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class RoyalMailCBCBean
extends AbstractFourStateBean {
    protected static final double DEFAULT_MODULE_WIDTH = 0.53;

    public RoyalMailCBCBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
        this.setModuleWidth(0.53);
        this.setTrackHeight(1.25);
        this.setAscenderHeight(1.8f);
        this.setQuietZone(2.0);
        this.setIntercharGapWidth(this.getModuleWidth());
        this.updateHeight();
    }

    @Override
    public void setMsgPosition(HumanReadablePlacement placement) {
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        FourStateLogicHandler handler = new FourStateLogicHandler(this, new Canvas(canvas));
        RoyalMailCBCLogicImpl impl = new RoyalMailCBCLogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        String modMsg = RoyalMailCBCLogicImpl.removeStartStop(msg);
        int additional = this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO ? 1 : 0;
        int len = modMsg.length() + additional;
        double width = (double)(len * 4 + 2) * this.moduleWidth + (double)(len * 4 + 1) * this.getIntercharGapWidth();
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, this.getBarHeight(), width + 2.0 * qzh, this.getBarHeight() + 2.0 * qzv, qzh, qzv);
    }
}

