/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.utils;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Supplier;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.io.TimeSpan;
import org.pragmatica.lang.utils.SharedScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Retry {
    public <T> Promise<T> execute(Supplier<Promise<T>> var1);

    public static RetryStageMaxAttempts create() {
        return maxAttempts -> backoffStrategy -> {
            record Retry(int maxAttempts, BackoffStrategy backoffStrategy) implements org.pragmatica.lang.utils.Retry
            {
                private static final Logger log = LoggerFactory.getLogger(org.pragmatica.lang.utils.Retry.class);

                @Override
                public <T> Promise<T> execute(Supplier<Promise<T>> operation) {
                    return this.executeWithLoop(operation, 1, Promise.promise());
                }

                private <T> Promise<T> executeWithLoop(Supplier<Promise<T>> operation, int attempt, Promise<T> output) {
                    operation.get().fold(result -> this.handle(operation, attempt, output, (Result)result));
                    return output;
                }

                private <T> Promise<T> handle(Supplier<Promise<T>> operation, int attempt, Promise<T> output, Result<T> result) {
                    Promise<T> promise;
                    Result<T> result2 = result;
                    Objects.requireNonNull(result2);
                    Result<T> result3 = result2;
                    int n = 0;
                    block5: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Success.class, Result.Failure.class, Result.Failure.class}, result3, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Result.Success success = (Result.Success)result3;
                                promise = output.succeed(success.value());
                                break block5;
                            }
                            case 1: {
                                Result.Failure failure = (Result.Failure)result3;
                                if (attempt < this.maxAttempts) {
                                    n = 2;
                                    continue block5;
                                }
                                promise = output.fail(failure.cause());
                                break block5;
                            }
                            case 2: {
                                Result.Failure failure = (Result.Failure)result3;
                                TimeSpan delay = this.backoffStrategy.nextTimeout(attempt);
                                log.warn("Operation failed (attempt {}/{}), retrying after {}: {}", new Object[]{attempt, this.maxAttempts, delay, failure.cause().message()});
                                SharedScheduler.schedule(() -> this.executeWithLoop(operation, attempt + 1, output), delay);
                                promise = output;
                                break block5;
                            }
                        }
                        break;
                    }
                    return promise;
                }
            }
            return new Retry(maxAttempts, backoffStrategy);
        };
    }

    public static interface RetryStageMaxAttempts {
        public RetryStageBackoffStrategy attempts(int var1);
    }

    public static interface RetryStageBackoffStrategy {
        public Retry strategy(BackoffStrategy var1);
    }

    public static interface BackoffStrategy {
        public TimeSpan nextTimeout(int var1);

        public static FixedStage fixed() {
            return x$0 -> {
                record FixedBackoffStrategy(TimeSpan interval) implements BackoffStrategy
                {
                    @Override
                    public TimeSpan nextTimeout(int attempt) {
                        return this.interval;
                    }
                }
                return new FixedBackoffStrategy(x$0);
            };
        }

        public static ExponentialStageInitialDelay exponential() {
            return initialDelay -> maxDelay -> factor -> withJitter -> {
                record ExponentialBackoffStrategy(TimeSpan initialDelay, TimeSpan maxDelay, double factor, boolean withJitter) implements BackoffStrategy
                {
                    @Override
                    public TimeSpan nextTimeout(int attempt) {
                        double multiplier = Math.pow(this.factor, attempt - 1);
                        if (this.withJitter) {
                            multiplier *= 0.9 + Math.random() * 0.2;
                        }
                        long delay = (long)((double)this.initialDelay.nanos() * multiplier);
                        return TimeSpan.timeSpan(Math.min(delay, this.maxDelay.nanos())).nanos();
                    }
                }
                return new ExponentialBackoffStrategy(initialDelay, maxDelay, factor, withJitter);
            };
        }

        public static LinearStageInitialDelay linear() {
            return initialDelay -> increment -> maxDelay -> {
                record LinearBackoffStrategy(TimeSpan initialDelay, TimeSpan increment, TimeSpan maxDelay) implements BackoffStrategy
                {
                    @Override
                    public TimeSpan nextTimeout(int attempt) {
                        long delay = this.initialDelay.nanos() + this.increment.nanos() * (long)(attempt - 1);
                        return TimeSpan.timeSpan(Math.min(delay, this.maxDelay.nanos())).nanos();
                    }
                }
                return new LinearBackoffStrategy(initialDelay, increment, maxDelay);
            };
        }

        public static interface FixedStage {
            public BackoffStrategy interval(TimeSpan var1);
        }

        public static interface ExponentialStageInitialDelay {
            public ExponentialStageMaxDelay initialDelay(TimeSpan var1);
        }

        public static interface LinearStageInitialDelay {
            public LinearStageIncrement initialDelay(TimeSpan var1);
        }

        public static interface LinearStageIncrement {
            public LinearStageMaxDelay increment(TimeSpan var1);
        }

        public static interface LinearStageMaxDelay {
            public BackoffStrategy maxDelay(TimeSpan var1);
        }

        public static interface ExponentialStageMaxDelay {
            public ExponentialStageFactor maxDelay(TimeSpan var1);
        }

        public static interface ExponentialStageFactor {
            public ExponentialStageWithJitter factor(double var1);
        }

        public static interface ExponentialStageWithJitter {
            public BackoffStrategy jitter(boolean var1);

            default public BackoffStrategy withJitter() {
                return this.jitter(true);
            }

            default public BackoffStrategy withoutJitter() {
                return this.jitter(false);
            }
        }
    }
}

