/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.utils;

import java.util.function.Consumer;
import java.util.function.Predicate;

public interface FluentPredicate<T>
extends Predicate<T> {
    default public FluentPredicate<T> ifTrue(T value, Consumer<T> consumer) {
        if (this.test(value)) {
            consumer.accept(value);
        }
        return this;
    }

    default public FluentPredicate<T> ifTrue(T value, Runnable runnable) {
        return this.ifTrue(value, (T object) -> runnable.run());
    }

    default public FluentPredicate<T> ifFalse(T value, Consumer<T> consumer) {
        if (!this.test(value)) {
            consumer.accept(value);
        }
        return this;
    }

    default public FluentPredicate<T> ifFalse(T value, Runnable runnable) {
        return this.ifFalse(value, (T object) -> runnable.run());
    }

    public static <T> FluentPredicate<T> from(Predicate<T> predicate) {
        return predicate::test;
    }
}

