/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.parse;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.pragmatica.lang.Result;

public sealed interface Number {
    public static Result<Byte> parseByte(String s) {
        return Result.lift1(Byte::parseByte, s);
    }

    public static Result<Byte> parseByte(String s, int radix) {
        return Result.lift2(Byte::parseByte, s, radix);
    }

    public static Result<Short> parseShort(String s) {
        return Result.lift1(Short::parseShort, s);
    }

    public static Result<Short> parseShort(String s, int radix) {
        return Result.lift2(Short::parseShort, s, radix);
    }

    public static Result<Integer> parseInt(String s) {
        return Result.lift1(Integer::parseInt, s);
    }

    public static Result<Integer> parseInt(String s, int radix) {
        return Result.lift2(Integer::parseInt, s, radix);
    }

    public static Result<Long> parseLong(String s) {
        return Result.lift1(Long::parseLong, s);
    }

    public static Result<Long> parseLong(String s, int radix) {
        return Result.lift2(Long::parseLong, s, radix);
    }

    public static Result<Float> parseFloat(String s) {
        return Result.lift1(Float::parseFloat, s);
    }

    public static Result<Double> parseDouble(String s) {
        return Result.lift1(Double::parseDouble, s);
    }

    public static Result<BigInteger> parseBigInteger(String s) {
        return Result.lift1(BigInteger::new, s);
    }

    public static Result<BigInteger> parseBigInteger(String s, int radix) {
        return Result.lift2(BigInteger::new, s, radix);
    }

    public static Result<BigDecimal> parseBigDecimal(String s) {
        return Result.lift1(BigDecimal::new, s);
    }

    public record unused() implements Number
    {
    }
}

