/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.parse;

import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Currency;
import java.util.Locale;
import org.pragmatica.lang.Result;

public sealed interface I18n {
    public static Result<Currency> parseCurrency(String currencyCode) {
        return Result.lift1(Currency::getInstance, currencyCode);
    }

    public static Result<Locale> parseLocale(String languageTag) {
        return Result.lift1(Locale::forLanguageTag, languageTag);
    }

    public static Result<Charset> parseCharset(String charsetName) {
        return Result.lift1(Charset::forName, charsetName);
    }

    public static Result<ZoneId> parseZoneId(String zoneId) {
        return Result.lift1(ZoneId::of, zoneId);
    }

    public static Result<ZoneOffset> parseZoneOffset(String offsetId) {
        return Result.lift1(ZoneOffset::of, offsetId);
    }

    public record unused() implements I18n
    {
    }
}

