/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.parse;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.pragmatica.lang.Result;

public sealed interface DateTime {
    public static Result<LocalDate> parseLocalDate(String text) {
        return Result.lift1(LocalDate::parse, text);
    }

    public static Result<LocalDate> parseLocalDate(String text, DateTimeFormatter formatter) {
        return Result.lift2(LocalDate::parse, text, formatter);
    }

    public static Result<LocalTime> parseLocalTime(String text) {
        return Result.lift1(LocalTime::parse, text);
    }

    public static Result<LocalTime> parseLocalTime(String text, DateTimeFormatter formatter) {
        return Result.lift2(LocalTime::parse, text, formatter);
    }

    public static Result<LocalDateTime> parseLocalDateTime(String text) {
        return Result.lift1(LocalDateTime::parse, text);
    }

    public static Result<LocalDateTime> parseLocalDateTime(String text, DateTimeFormatter formatter) {
        return Result.lift2(LocalDateTime::parse, text, formatter);
    }

    public static Result<ZonedDateTime> parseZonedDateTime(String text) {
        return Result.lift1(ZonedDateTime::parse, text);
    }

    public static Result<ZonedDateTime> parseZonedDateTime(String text, DateTimeFormatter formatter) {
        return Result.lift2(ZonedDateTime::parse, text, formatter);
    }

    public static Result<OffsetDateTime> parseOffsetDateTime(String text) {
        return Result.lift1(OffsetDateTime::parse, text);
    }

    public static Result<OffsetDateTime> parseOffsetDateTime(String text, DateTimeFormatter formatter) {
        return Result.lift2(OffsetDateTime::parse, text, formatter);
    }

    public static Result<OffsetTime> parseOffsetTime(String text) {
        return Result.lift1(OffsetTime::parse, text);
    }

    public static Result<OffsetTime> parseOffsetTime(String text, DateTimeFormatter formatter) {
        return Result.lift2(OffsetTime::parse, text, formatter);
    }

    public static Result<Instant> parseInstant(String text) {
        return Result.lift1(Instant::parse, text);
    }

    public static Result<Duration> parseDuration(String text) {
        return Result.lift1(Duration::parse, text);
    }

    public static Result<Period> parsePeriod(String text) {
        return Result.lift1(Period::parse, text);
    }

    public record unused() implements DateTime
    {
    }
}

