/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.ExpectationMismatchError;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.Option;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Tuple;
import org.pragmatica.lang.Unit;
import org.pragmatica.lang.utils.Causes;

public sealed interface Result<T> {
    public static final Result<Unit> UNIT_RESULT = Result.success(Unit.unit());

    default public <U> Result<U> map(Functions.Fn1<U, ? super T> mapper) {
        return this.fold(cause -> this, r -> Result.success(mapper.apply((Object)r)));
    }

    default public <U> Result<U> map(Supplier<U> supplier) {
        return this.map((? super T object) -> supplier.get());
    }

    default public <U> Result<U> flatMap(Functions.Fn1<Result<U>, ? super T> mapper) {
        return this.fold(cause -> this, mapper);
    }

    default public <U, I> Result<U> flatMap2(Functions.Fn2<Result<U>, ? super T, ? super I> mapper, I parameter2) {
        return this.flatMap((? super T value) -> (Result)mapper.apply((Object)value, (Object)parameter2));
    }

    default public <U> Result<U> flatMap(Supplier<Result<U>> mapper) {
        return this.fold(cause -> this, object -> (Result)mapper.get());
    }

    default public Result<Unit> mapToUnit() {
        return this.map(Unit::toUnit);
    }

    default public Result<T> mapError(Functions.Fn1<Cause, ? super Cause> mapper) {
        return this.fold(cause -> ((Cause)mapper.apply((Cause)cause)).result(), object -> this);
    }

    public Result<T> trace();

    default public Result<T> recover(Functions.Fn1<T, ? super Cause> mapper) {
        return this.fold(cause -> Result.success(mapper.apply((Cause)cause)), object -> this);
    }

    default public Result<T> apply(Consumer<? super Cause> failureConsumer, Consumer<? super T> successConsumer) {
        return this.fold(t -> {
            failureConsumer.accept((Cause)t);
            return this;
        }, t -> {
            successConsumer.accept(t);
            return this;
        });
    }

    default public Result<T> onSuccess(Consumer<T> consumer) {
        this.fold(Functions::toNull, v -> {
            consumer.accept(v);
            return null;
        });
        return this;
    }

    default public Result<T> onSuccessRun(Runnable action) {
        this.fold(Functions::toNull, object -> {
            action.run();
            return null;
        });
        return this;
    }

    default public Result<T> onFailure(Consumer<? super Cause> consumer) {
        this.fold(v -> {
            consumer.accept((Cause)v);
            return null;
        }, Functions::toNull);
        return this;
    }

    default public Result<T> onFailureRun(Runnable action) {
        this.fold(cause -> {
            action.run();
            return null;
        }, Functions::toNull);
        return this;
    }

    default public Result<T> filter(Cause cause2, Predicate<T> predicate) {
        return this.fold(cause -> this, v -> predicate.test(v) ? this : Result.failure(cause2));
    }

    default public Result<T> filter(Functions.Fn1<Cause, T> causeMapper, Predicate<T> predicate) {
        return this.fold(cause -> this, v -> predicate.test(v) ? this : Result.failure((Cause)causeMapper.apply(v)));
    }

    default public T or(T replacement) {
        return (T)this.fold(cause -> replacement, Functions::id);
    }

    default public T or(Supplier<T> supplier) {
        return (T)this.fold(cause -> supplier.get(), Functions::id);
    }

    default public Result<T> orElse(Result<T> replacement) {
        return this.fold(cause -> replacement, object -> this);
    }

    default public Result<T> orElse(Supplier<Result<T>> supplier) {
        return this.fold(cause -> (Result)supplier.get(), object -> this);
    }

    default public Option<T> option() {
        return this.fold(cause -> Option.empty(), Option::option);
    }

    default public Stream<T> stream() {
        return this.fold(cause -> Stream.empty(), Stream::of);
    }

    default public Promise<T> async() {
        return Promise.resolved(this);
    }

    default public boolean isSuccess() {
        return this.fold(Functions::toFalse, Functions::toTrue);
    }

    default public boolean isFailure() {
        return this.fold(Functions::toTrue, Functions::toFalse);
    }

    default public Result<T> onResult(Consumer<Result<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    default public Result<T> onResultRun(Runnable runnable) {
        return this.onResult(result -> runnable.run());
    }

    @Deprecated
    default public T unwrap() {
        return (T)this.fold(v -> {
            throw new IllegalStateException("Unwrap error: " + v.message());
        }, Functions::id);
    }

    default public T expect(String message) {
        return (T)this.fold(cause -> {
            throw new ExpectationMismatchError("Unexpected failure Result (" + cause.message() + "): " + message);
        }, Functions::id);
    }

    public <U> U fold(Functions.Fn1<? extends U, ? super Cause> var1, Functions.Fn1<? extends U, ? super T> var2);

    public static Result<Unit> unitResult() {
        return UNIT_RESULT;
    }

    public static <U> Result<U> success(U value) {
        return new Success<U>(value);
    }

    public static <U> Result<U> ok(U value) {
        return Result.success(value);
    }

    public static <U> Result<U> failure(Cause value) {
        return new Failure(value);
    }

    public static <U> Result<U> err(Cause value) {
        return new Failure(value);
    }

    public static <U> Result<U> lift(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn0<U> supplier) {
        try {
            return Result.success(supplier.apply());
        }
        catch (Throwable e) {
            return Result.failure(exceptionMapper.apply(e));
        }
    }

    public static <U, T1> Result<U> lift1(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn1<U, T1> function, T1 value1) {
        return Result.lift(exceptionMapper, () -> function.apply(value1));
    }

    public static <R, T> Result<R> lift1(Functions.ThrowingFn1<R, T> function, T inputValue) {
        return Result.lift1(Causes::fromThrowable, function, inputValue);
    }

    public static <U, T1, T2> Result<U> lift2(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn2<U, T1, T2> function, T1 value1, T2 value2) {
        return Result.lift(exceptionMapper, () -> function.apply(value1, value2));
    }

    public static <R, T1, T2> Result<R> lift2(Functions.ThrowingFn2<R, T1, T2> function, T1 inputValue1, T2 inputValue2) {
        return Result.lift2(Causes::fromThrowable, function, inputValue1, inputValue2);
    }

    public static <U, T1, T2, T3> Result<U> lift3(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn3<U, T1, T2, T3> function, T1 value1, T2 value2, T3 value3) {
        return Result.lift(exceptionMapper, () -> function.apply(value1, value2, value3));
    }

    public static <R, T1, T2, T3> Result<R> lift3(Functions.ThrowingFn3<R, T1, T2, T3> function, T1 inputValue1, T2 inputValue2, T3 inputValue3) {
        return Result.lift3(Causes::fromThrowable, function, inputValue1, inputValue2, inputValue3);
    }

    public static Result<Unit> lift(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingRunnable runnable) {
        try {
            runnable.run();
            return Result.unitResult();
        }
        catch (Throwable e) {
            return Result.failure(exceptionMapper.apply(e));
        }
    }

    public static <U> Result<U> lift(Cause cause, Functions.ThrowingFn0<U> supplier) {
        return Result.lift((? super Throwable throwable) -> cause, supplier);
    }

    public static <U> Result<U> lift(Functions.ThrowingFn0<U> supplier) {
        return Result.lift(Causes::fromThrowable, supplier);
    }

    public static Result<Unit> lift(Cause cause, Functions.ThrowingRunnable runnable) {
        return Result.lift((? super Throwable throwable) -> cause, runnable);
    }

    public static Result<Unit> lift(Functions.ThrowingRunnable runnable) {
        return Result.lift(Causes::fromThrowable, runnable);
    }

    public static <R, T1> Functions.Fn1<Result<R>, T1> liftFn1(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn1<R, T1> function) {
        return input -> Result.lift(exceptionMapper, () -> function.apply(input));
    }

    public static <R, T1, T2> Functions.Fn2<Result<R>, T1, T2> liftFn2(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn2<R, T1, T2> function) {
        return (inputValue1, inputValue2) -> Result.lift(exceptionMapper, () -> function.apply(inputValue1, inputValue2));
    }

    public static <R, T1, T2, T3> Functions.Fn3<Result<R>, T1, T2, T3> liftFn3(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn3<R, T1, T2, T3> function) {
        return (inputValue1, inputValue2, inputValue3) -> Result.lift(exceptionMapper, () -> function.apply(inputValue1, inputValue2, inputValue3));
    }

    public static <R, T1, T2> Functions.Fn2<Result<R>, T1, T2> liftFn2(Functions.ThrowingFn2<R, T1, T2> function) {
        return Result.liftFn2(Causes::fromThrowable, function);
    }

    public static <R, T1, T2, T3> Functions.Fn3<Result<R>, T1, T2, T3> liftFn3(Functions.ThrowingFn3<R, T1, T2, T3> function) {
        return Result.liftFn3(Causes::fromThrowable, function);
    }

    @SafeVarargs
    public static <T> Result<T> any(Result<T> first, Result<T> ... results) {
        if (first.isSuccess()) {
            return first;
        }
        for (Result<T> result : results) {
            if (!result.isSuccess()) continue;
            return result;
        }
        return first;
    }

    @SafeVarargs
    public static <T> Result<T> any(Result<T> first, Supplier<Result<T>> ... suppliers) {
        if (first.isSuccess()) {
            return first;
        }
        for (Supplier<Result<Result<T>>> supplier : suppliers) {
            Result<T> result = supplier.get();
            if (!result.isSuccess()) continue;
            return result;
        }
        return first;
    }

    public static <T> Result<List<T>> allOf(Stream<Result<T>> results) {
        Causes.CompositeCause causes = Causes.composite(new Result[0]);
        ArrayList values = new ArrayList();
        results.forEach(val -> val.fold(causes::append, values::add));
        return causes.isEmpty() ? Result.success(values) : Result.failure(causes);
    }

    @SafeVarargs
    public static <T> Result<List<T>> allOf(Result<T> ... results) {
        return Result.allOf(List.of(results));
    }

    public static <T> Result<List<T>> allOf(List<Result<T>> results) {
        Causes.CompositeCause causes = Causes.composite(new Result[0]);
        ArrayList values = new ArrayList();
        for (Result<T> value : results) {
            value.onFailure(causes::append).onSuccess(values::add);
        }
        return causes.isEmpty() ? Result.success(values) : Result.failure(causes);
    }

    public static <T1> Mapper1<T1> all(Result<T1> value) {
        Causes.CompositeCause causes = Causes.composite(value);
        return () -> value.flatMap((? super T vv1) -> Result.success(Tuple.tuple(vv1))).mapError(causes::replace);
    }

    public static <T1, T2> Mapper2<T1, T2> all(Result<T1> value1, Result<T2> value2) {
        Causes.CompositeCause causes = Causes.composite(value1, value2);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> Result.success(Tuple.tuple(vv1, vv2)))).mapError(causes::replace);
    }

    public static <T1, T2, T3> Mapper3<T1, T2, T3> all(Result<T1> value1, Result<T2> value2, Result<T3> value3) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> Result.success(Tuple.tuple(vv1, vv2, vv3))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4> Mapper4<T1, T2, T3, T4> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4)))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4, T5> Mapper5<T1, T2, T3, T4, T5> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4, Result<T5> value5) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4, value5);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> value5.flatMap((? super T vv5) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4, vv5))))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4, T5, T6> Mapper6<T1, T2, T3, T4, T5, T6> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4, Result<T5> value5, Result<T6> value6) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4, value5, value6);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> value5.flatMap((? super T vv5) -> value6.flatMap((? super T vv6) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4, vv5, vv6)))))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Mapper7<T1, T2, T3, T4, T5, T6, T7> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4, Result<T5> value5, Result<T6> value6, Result<T7> value7) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4, value5, value6, value7);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> value5.flatMap((? super T vv5) -> value6.flatMap((? super T vv6) -> value7.flatMap((? super T vv7) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4, vv5, vv6, vv7))))))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4, Result<T5> value5, Result<T6> value6, Result<T7> value7, Result<T8> value8) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4, value5, value6, value7, value8);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> value5.flatMap((? super T vv5) -> value6.flatMap((? super T vv6) -> value7.flatMap((? super T vv7) -> value8.flatMap((? super T vv8) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4, vv5, vv6, vv7, vv8)))))))))).mapError(causes::replace);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> all(Result<T1> value1, Result<T2> value2, Result<T3> value3, Result<T4> value4, Result<T5> value5, Result<T6> value6, Result<T7> value7, Result<T8> value8, Result<T9> value9) {
        Causes.CompositeCause causes = Causes.composite(value1, value2, value3, value4, value5, value6, value7, value8, value9);
        return () -> value1.flatMap((? super T vv1) -> value2.flatMap((? super T vv2) -> value3.flatMap((? super T vv3) -> value4.flatMap((? super T vv4) -> value5.flatMap((? super T vv5) -> value6.flatMap((? super T vv6) -> value7.flatMap((? super T vv7) -> value8.flatMap((? super T vv8) -> value9.flatMap((? super T vv9) -> Result.success(Tuple.tuple(vv1, vv2, vv3, vv4, vv5, vv6, vv7, vv8, vv9))))))))))).mapError(causes::replace);
    }

    public record Success<T>(T value) implements Result<T>
    {
        @Override
        public <U> U fold(Functions.Fn1<? extends U, ? super Cause> failureMapper, Functions.Fn1<? extends U, ? super T> successMapper) {
            return successMapper.apply(this.value);
        }

        @Override
        public String toString() {
            return "Success(" + this.value.toString() + ")";
        }

        @Override
        public Result<T> trace() {
            return this;
        }
    }

    public record Failure<T>(Cause cause) implements Result<T>
    {
        private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

        @Override
        public <U> U fold(Functions.Fn1<? extends U, ? super Cause> failureMapper, Functions.Fn1<? extends U, ? super T> successMapper) {
            return failureMapper.apply(this.cause);
        }

        @Override
        public String toString() {
            return "Failure(" + this.cause.toString() + ")";
        }

        @Override
        public Result<T> trace() {
            String text = WALKER.walk(frames -> frames.skip(1L).findFirst().map((Function<StackWalker.StackFrame, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/lang/StackWalker$StackFrame;)Ljava/lang/String;)()).orElse("<unknown>"));
            return this.mapError(cause -> Causes.CompositeCause.toComposite(text, cause));
        }
    }

    public static interface Mapper1<T1> {
        public Result<Tuple.Tuple1<T1>> id();

        default public <R> Result<R> map(Functions.Fn1<R, T1> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn1<Result<R>, T1> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper1<T1> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper2<T1, T2> {
        public Result<Tuple.Tuple2<T1, T2>> id();

        default public <R> Result<R> map(Functions.Fn2<R, T1, T2> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn2<Result<R>, T1, T2> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper2<T1, T2> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper3<T1, T2, T3> {
        public Result<Tuple.Tuple3<T1, T2, T3>> id();

        default public <R> Result<R> map(Functions.Fn3<R, T1, T2, T3> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn3<Result<R>, T1, T2, T3> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper3<T1, T2, T3> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper4<T1, T2, T3, T4> {
        public Result<Tuple.Tuple4<T1, T2, T3, T4>> id();

        default public <R> Result<R> map(Functions.Fn4<R, T1, T2, T3, T4> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn4<Result<R>, T1, T2, T3, T4> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper4<T1, T2, T3, T4> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper5<T1, T2, T3, T4, T5> {
        public Result<Tuple.Tuple5<T1, T2, T3, T4, T5>> id();

        default public <R> Result<R> map(Functions.Fn5<R, T1, T2, T3, T4, T5> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn5<Result<R>, T1, T2, T3, T4, T5> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper5<T1, T2, T3, T4, T5> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper6<T1, T2, T3, T4, T5, T6> {
        public Result<Tuple.Tuple6<T1, T2, T3, T4, T5, T6>> id();

        default public <R> Result<R> map(Functions.Fn6<R, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn6<Result<R>, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper6<T1, T2, T3, T4, T5, T6> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper7<T1, T2, T3, T4, T5, T6, T7> {
        public Result<Tuple.Tuple7<T1, T2, T3, T4, T5, T6, T7>> id();

        default public <R> Result<R> map(Functions.Fn7<R, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn7<Result<R>, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper7<T1, T2, T3, T4, T5, T6, T7> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> {
        public Result<Tuple.Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> id();

        default public <R> Result<R> map(Functions.Fn8<R, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn8<Result<R>, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> async() {
            return () -> Promise.resolved(this.id());
        }
    }

    public static interface Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        public Result<Tuple.Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> id();

        default public <R> Result<R> map(Functions.Fn9<R, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Result<R> flatMap(Functions.Fn9<Result<R>, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().flatMap((? super T tuple) -> (Result)tuple.map(mapper));
        }

        default public Promise.Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> async() {
            return () -> Promise.resolved(this.id());
        }
    }
}

