/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.pragmatica.lang.AsyncExecutor;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.io.CoreError;
import org.pragmatica.lang.io.TimeSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PromiseImpl<T>
implements Promise<T> {
    private static final Logger log = LoggerFactory.getLogger(Promise.class);
    volatile Result<T> result;
    volatile Completion<T> stack;
    private static final VarHandle RESULT;
    private static final VarHandle STACK;

    PromiseImpl(Result<T> result) {
        this.result = result;
    }

    public String toString() {
        return this.result == null ? "Promise<>" : "Promise<" + String.valueOf(this.result) + ">";
    }

    @Override
    public boolean isResolved() {
        return this.result != null;
    }

    @Override
    public Promise<T> onResult(Consumer<Result<T>> action) {
        if (this.result != null) {
            action.accept(this.result);
            return this;
        }
        this.push(new CompletionOnResult<T>(action));
        return this;
    }

    @Override
    public <U> Promise<U> fold(Functions.Fn1<Promise<U>, Result<T>> action) {
        if (this.result != null) {
            return action.apply(this.result);
        }
        return this.chain(action);
    }

    @Override
    public Result<T> await() {
        if (this.result != null) {
            return this.result;
        }
        Thread thread = Thread.currentThread();
        if (log.isTraceEnabled()) {
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            log.trace("Thread {} ({}) is waiting for resolution of Promise {} at {}:{}", new Object[]{thread.threadId(), thread.getName(), this, stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
        }
        this.push(new CompletionJoin(thread));
        while (this.result == null) {
            LockSupport.park();
        }
        return this.result;
    }

    @Override
    public Result<T> await(TimeSpan timeout) {
        if (this.result != null) {
            return this.result;
        }
        Thread thread = Thread.currentThread();
        if (log.isTraceEnabled()) {
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            log.trace("Thread {} ({}) is waiting for resolution of Promise {} at {}:{} for {}ns", new Object[]{thread.threadId(), thread.getName(), this, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), timeout.nanos()});
        }
        this.push(new CompletionJoin(thread));
        long deadline = System.nanoTime() + timeout.nanos();
        while (this.result == null && System.nanoTime() < deadline) {
            LockSupport.parkNanos(deadline - System.nanoTime());
        }
        if (this.result == null) {
            return new CoreError.Timeout("Promise is not resolved within specified timeout").result();
        }
        return this.result;
    }

    @Override
    public Promise<T> resolve(Result<T> value) {
        if (RESULT.compareAndSet(this, null, value)) {
            do {
                this.processActions();
            } while (this.stack != null);
        }
        return this;
    }

    private void processActions() {
        Completion<T> head;
        while (!STACK.compareAndSet(this, head = this.stack, null)) {
        }
        CompletionJoin joins = null;
        CompletionOnResult events = null;
        CompletionFold actions = null;
        Completion<T> current = head;
        while (current != null) {
            CompletionMarker completionMarker;
            Completion tmp = current.next;
            Objects.requireNonNull((CompletionMarker)((Object)current));
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompletionJoin.class, CompletionOnResult.class, CompletionFold.class}, (CompletionMarker)completionMarker, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    CompletionJoin join = (CompletionJoin)completionMarker;
                    join.next = joins;
                    joins = join;
                    break;
                }
                case 1: {
                    CompletionOnResult event = (CompletionOnResult)completionMarker;
                    event.next = events;
                    events = event;
                    break;
                }
                case 2: {
                    CompletionFold action = (CompletionFold)completionMarker;
                    action.next = actions;
                    actions = action;
                }
            }
            current = tmp;
        }
        this.runEventHandlers(events);
        this.runSequentialActions(actions);
        this.runJoins(joins);
    }

    private void runJoins(Completion current) {
        while (current != null) {
            current.complete(this.result);
            current = current.next;
        }
    }

    private void runSequentialActions(Completion current) {
        while (current != null) {
            current.complete(this.result);
            current = current.next;
        }
    }

    private void runEventHandlers(Completion asyncEvents) {
        AsyncExecutor.INSTANCE.runAsync(() -> {
            Completion<T> current = asyncEvents;
            while (current != null) {
                current.complete(this.result);
                current = current.next;
            }
        });
    }

    private <U> Promise<U> chain(Functions.Fn1<Promise<U>, Result<T>> transformer) {
        PromiseImpl<T> dependency = new PromiseImpl<T>(null);
        this.push(new CompletionFold<T, T>(dependency, transformer));
        return dependency;
    }

    private void push(Completion<T> completion) {
        Completion<T> prevStack;
        do {
            if (this.result != null) {
                completion.complete(this.result);
                return;
            }
            prevStack = this.stack;
            completion.next = prevStack;
        } while (!STACK.compareAndSet(this, prevStack, completion));
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            RESULT = lookup.findVarHandle(PromiseImpl.class, "result", Result.class);
            STACK = lookup.findVarHandle(PromiseImpl.class, "stack", Completion.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class CompletionOnResult<T>
    extends Completion<T>
    implements CompletionMarker {
        private final Consumer<Result<T>> consumer;

        CompletionOnResult(Consumer<Result<T>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void complete(Result<T> value) {
            this.consumer.accept(value);
        }
    }

    static abstract class Completion<T> {
        volatile Completion<T> next;

        Completion() {
        }

        public abstract void complete(Result<T> var1);
    }

    static final class CompletionJoin<T>
    extends Completion<T>
    implements CompletionMarker {
        private final Thread thread;

        CompletionJoin(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void complete(Result<T> value) {
            if (log.isTraceEnabled()) {
                StackTraceElement stackTraceElement = this.thread.getStackTrace()[2];
                log.trace("Unblocking thread {} ({}) after resolution of Promise with {} at {}:{}", new Object[]{this.thread.threadId(), this.thread.getName(), value, stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
            }
            LockSupport.unpark(this.thread);
        }
    }

    static sealed interface CompletionMarker
    permits CompletionOnResult, CompletionFold, CompletionJoin {
    }

    static final class CompletionFold<U, T>
    extends Completion<T>
    implements CompletionMarker {
        private final Promise<U> dependency;
        private final Functions.Fn1<Promise<U>, Result<T>> transformer;

        CompletionFold(Promise<U> dependency, Functions.Fn1<Promise<U>, Result<T>> transformer) {
            this.dependency = dependency;
            this.transformer = transformer;
        }

        @Override
        public void complete(Result<T> value) {
            this.transformer.apply(value).onResult(this.dependency::resolve);
        }
    }
}

