/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.pragmatica.lang.AsyncExecutor;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.PromiseImpl;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.Tuple;
import org.pragmatica.lang.Unit;
import org.pragmatica.lang.io.CoreError;
import org.pragmatica.lang.io.TimeSpan;
import org.pragmatica.lang.utils.ActionableThreshold;
import org.pragmatica.lang.utils.Causes;
import org.pragmatica.lang.utils.ResultCollector;

public interface Promise<T> {
    public static final Promise<Unit> UNIT = Promise.resolved(Result.unitResult());
    public static final Result<?> OTHER_SUCCEEDED = new CoreError.Cancelled("Cancelled because other Promise instance succeeded").result();
    public static final CoreError.Cancelled PROMISE_CANCELLED = new CoreError.Cancelled("Promise cancelled");

    public <U> Promise<U> fold(Functions.Fn1<Promise<U>, Result<T>> var1);

    public Promise<T> onResult(Consumer<Result<T>> var1);

    default public <U> Promise<U> map(Functions.Fn1<U, ? super T> transformation) {
        return this.replaceResult(result -> result.map(transformation));
    }

    default public <U> Promise<U> map(Supplier<U> supplier) {
        return this.map((? super T object) -> supplier.get());
    }

    default public <U> Promise<U> flatMap(Functions.Fn1<Promise<U>, ? super T> transformation) {
        return this.fold(result -> result.fold(Promise::failure, transformation));
    }

    default public <U, I> Promise<U> flatMap2(Functions.Fn2<Promise<U>, ? super T, ? super I> mapper, I parameter2) {
        return this.flatMap((? super T value) -> (Promise)mapper.apply((Object)value, (Object)parameter2));
    }

    default public <U> Promise<U> flatMap(Supplier<Promise<U>> supplier) {
        return this.flatMap((? super T object) -> (Promise)supplier.get());
    }

    default public Promise<T> mapError(Functions.Fn1<Cause, ? super Cause> transformation) {
        return this.replaceResult(result -> result.mapError(transformation));
    }

    default public Promise<T> trace() {
        String text = Thread.currentThread().getStackTrace()[2].toString();
        return this.mapError(cause -> Causes.CompositeCause.toComposite(text, cause));
    }

    default public Promise<T> recover(Functions.Fn1<T, ? super Cause> mapper) {
        return this.replaceResult(result -> result.recover(mapper));
    }

    default public <U> Promise<U> mapResult(Functions.Fn1<Result<U>, ? super T> transformation) {
        return this.replaceResult(result -> result.flatMap(transformation));
    }

    default public <U> Promise<U> replaceResult(Functions.Fn1<Result<U>, Result<T>> transformation) {
        return this.fold(result -> Promise.resolved((Result)transformation.apply((Result)result)));
    }

    default public Promise<T> onResultAsync(Consumer<Result<T>> action) {
        return this.onResult(action);
    }

    default public Promise<T> onResultRun(Runnable action) {
        return this.onResult(result -> action.run());
    }

    default public Promise<T> onResultRunAsync(Runnable action) {
        return this.onResult(result -> action.run());
    }

    default public Promise<T> withResult(Consumer<Result<T>> consumer) {
        return this.fold(result -> {
            result.onResult(consumer);
            return this;
        });
    }

    default public Promise<T> onSuccess(Consumer<T> action) {
        return this.onResult(result -> result.onSuccess(action));
    }

    default public Promise<T> onSuccessAsync(Consumer<T> action) {
        return this.onSuccess(action);
    }

    default public Promise<T> onSuccessRun(Runnable action) {
        return this.onResult(result -> result.onSuccessRun(action));
    }

    default public Promise<T> onSuccessRunAsync(Runnable action) {
        return this.onSuccessRun(action);
    }

    default public Promise<T> withSuccess(Consumer<T> consumer) {
        return this.fold(result -> Promise.resolved(result.onSuccess(consumer)));
    }

    default public Promise<T> onFailure(Consumer<Cause> action) {
        return this.onResult(result -> result.onFailure(action));
    }

    default public Promise<T> onFailureAsync(Consumer<Cause> action) {
        return this.onFailure(action);
    }

    default public Promise<T> onFailureRun(Runnable action) {
        return this.onResult(result -> result.onFailureRun(action));
    }

    default public Promise<T> onFailureRunAsync(Runnable action) {
        return this.onFailureRun(action);
    }

    default public Promise<T> filter(Cause cause, Predicate<T> predicate) {
        return this.fold(result -> result.filter(cause, predicate).async());
    }

    default public Promise<T> filter(Cause cause, Promise<Boolean> predicate) {
        return this.filter((T object) -> cause, predicate);
    }

    default public Promise<T> filter(Functions.Fn1<Cause, T> causeMapper, Predicate<T> predicate) {
        return this.fold(result -> result.filter(causeMapper, predicate).async());
    }

    default public Promise<T> filter(Functions.Fn1<Cause, T> causeMapper, Promise<Boolean> predicate) {
        return this.fold(result -> result.fold(Promise::failure, value -> predicate.flatMap((? super T decision) -> decision != false ? this : ((Cause)causeMapper.apply(value)).promise())));
    }

    default public Promise<T> withFailure(Consumer<Cause> consumer) {
        return this.fold(result -> Promise.resolved(result.onFailure(consumer)));
    }

    default public Promise<T> orElse(Promise<T> promise) {
        return this.fold(result -> result.fold(cause -> promise, object -> this));
    }

    default public Promise<T> orElse(Supplier<Promise<T>> supplier) {
        return this.fold(result -> result.fold(arg_0 -> Promise.lambda$orElse$4((Supplier)supplier, arg_0), object -> this));
    }

    public boolean isResolved();

    public Promise<T> resolve(Result<T> var1);

    default public Promise<T> succeed(T value) {
        return this.resolve(Result.success(value));
    }

    default public Promise<T> fail(Cause cause) {
        return this.resolve(Result.failure(cause));
    }

    default public Promise<T> succeedAsync(Supplier<? extends T> supplier) {
        return this.async((Promise<T> promise) -> promise.succeed(supplier.get()));
    }

    default public Promise<T> failAsync(Supplier<Cause> supplier) {
        return this.async((Promise<T> promise) -> promise.fail((Cause)supplier.get()));
    }

    default public Promise<T> timeout(TimeSpan timeout) {
        return this.async(timeout, promise -> promise.fail(new CoreError.Timeout("Promise timed out after " + timeout.millis() + "ms")));
    }

    default public Promise<T> cancel() {
        return this.fail(PROMISE_CANCELLED);
    }

    public Result<T> await();

    public Result<T> await(TimeSpan var1);

    default public Promise<T> async() {
        return this;
    }

    default public Promise<T> async(Consumer<Promise<T>> consumer) {
        AsyncExecutor.INSTANCE.runAsync(() -> consumer.accept(this));
        return this;
    }

    default public Promise<T> async(Supplier<Result<T>> supplier) {
        return this.async((Promise<T> promise) -> promise.resolve((Result)supplier.get()));
    }

    default public Promise<T> async(TimeSpan delay, Consumer<Promise<T>> action) {
        AsyncExecutor.INSTANCE.runAsync(delay, () -> action.accept(this));
        return this;
    }

    default public Promise<Unit> mapToUnit() {
        return this.map(Unit::toUnit);
    }

    public static <T> Promise<T> promise() {
        return new PromiseImpl(null);
    }

    public static <T> Promise<T> resolved(Result<T> value) {
        return new PromiseImpl<T>(value);
    }

    public static <T> Promise<T> success(T value) {
        return new PromiseImpl<T>(Result.success(value));
    }

    public static <T> Promise<T> ok(T value) {
        return Promise.success(value);
    }

    public static <T> Promise<T> failure(Cause cause) {
        return new PromiseImpl(Result.failure(cause));
    }

    public static <T> Promise<T> err(Cause cause) {
        return Promise.failure(cause);
    }

    public static <T> Promise<T> promise(Consumer<Promise<T>> consumer) {
        return Promise.promise().async(consumer);
    }

    public static <T> Promise<T> promise(Supplier<Result<T>> supplier) {
        return Promise.promise((Promise<T> promise) -> promise.resolve((Result)supplier.get()));
    }

    public static <T> Promise<T> promise(TimeSpan delay, Consumer<Promise<T>> consumer) {
        return Promise.promise().async(delay, consumer);
    }

    public static <T> Promise<T> promise(TimeSpan delay, Supplier<Result<T>> supplier) {
        return Promise.promise(delay, (Promise<T> promise) -> promise.resolve((Result)supplier.get()));
    }

    public static <U> Promise<U> lift(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn0<U> supplier) {
        return Promise.promise(() -> Result.lift(exceptionMapper, supplier));
    }

    public static <U, T1> Functions.Fn1<Promise<U>, T1> liftFn1(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn1<U, T1> function) {
        return value -> Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value)));
    }

    public static <U, T1, T2> Functions.Fn2<Promise<U>, T1, T2> liftFn2(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn2<U, T1, T2> function) {
        return (value1, value2) -> Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value1, value2)));
    }

    public static <U, T1, T2, T3> Functions.Fn3<Promise<U>, T1, T2, T3> liftFn3(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn3<U, T1, T2, T3> function) {
        return (value1, value2, value3) -> Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value1, value2, value3)));
    }

    public static <U, T1> Functions.Fn1<Promise<U>, T1> liftFn1(Functions.ThrowingFn1<U, T1> function) {
        return Promise.liftFn1(Causes::fromThrowable, function);
    }

    public static <U, T1, T2> Functions.Fn2<Promise<U>, T1, T2> liftFn2(Functions.ThrowingFn2<U, T1, T2> function) {
        return Promise.liftFn2(Causes::fromThrowable, function);
    }

    public static <U, T1, T2, T3> Functions.Fn3<Promise<U>, T1, T2, T3> liftFn3(Functions.ThrowingFn3<U, T1, T2, T3> function) {
        return Promise.liftFn3(Causes::fromThrowable, function);
    }

    public static <U, T1> Promise<U> lift1(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn1<U, T1> function, T1 value1) {
        return Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value1)));
    }

    public static <U, T1> Promise<U> lift1(Functions.ThrowingFn1<U, T1> function, T1 value1) {
        return Promise.lift1(Causes::fromThrowable, function, value1);
    }

    public static <U, T1, T2> Promise<U> lift2(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn2<U, T1, T2> function, T1 value1, T2 value2) {
        return Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value1, value2)));
    }

    public static <U, T1, T2> Promise<U> lift2(Functions.ThrowingFn2<U, T1, T2> function, T1 value1, T2 value2) {
        return Promise.lift2(Causes::fromThrowable, function, value1, value2);
    }

    public static <U, T1, T2, T3> Promise<U> lift3(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingFn3<U, T1, T2, T3> function, T1 value1, T2 value2, T3 value3) {
        return Promise.promise(() -> Result.lift(exceptionMapper, () -> function.apply(value1, value2, value3)));
    }

    public static <U, T1, T2, T3> Promise<U> lift3(Functions.ThrowingFn3<U, T1, T2, T3> function, T1 value1, T2 value2, T3 value3) {
        return Promise.lift3(Causes::fromThrowable, function, value1, value2, value3);
    }

    public static Promise<Unit> lift(Functions.Fn1<? extends Cause, ? super Throwable> exceptionMapper, Functions.ThrowingRunnable runnable) {
        return Promise.promise(() -> Result.lift(exceptionMapper, runnable));
    }

    public static <U> Promise<U> lift(Cause cause, Functions.ThrowingFn0<U> supplier) {
        return Promise.promise(() -> Result.lift(cause, supplier));
    }

    public static <U> Promise<U> lift(Functions.ThrowingFn0<U> supplier) {
        return Promise.promise(() -> Result.lift(supplier));
    }

    public static Promise<Unit> lift(Cause cause, Functions.ThrowingRunnable runnable) {
        return Promise.promise(() -> Result.lift(cause, runnable));
    }

    public static Promise<Unit> lift(Functions.ThrowingRunnable runnable) {
        return Promise.promise(() -> Result.lift(runnable));
    }

    public static Promise<Unit> async(Runnable action) {
        return Promise.lift(CoreError::exception, action::run);
    }

    @SafeVarargs
    public static <T> void failAll(Cause cause, Promise<T> ... promises) {
        Promise.failAll(cause, List.of(promises));
    }

    public static <T> void failAll(Cause cause, List<Promise<T>> promises) {
        promises.forEach(promise -> promise.fail(cause));
    }

    public static Promise<Unit> unitPromise() {
        return UNIT;
    }

    @SafeVarargs
    public static <T> Promise<T> any(Result<T> failureResult, Promise<T> ... promises) {
        return Promise.promise((Promise<T> anySuccess) -> ActionableThreshold.threshold(promises.length, () -> anySuccess.resolve(failureResult)).apply(at -> List.of(promises).forEach(promise -> promise.withResult(result -> result.onSuccess(anySuccess::succeed).onSuccessRun(() -> Promise.cancelAll(promises)).onResultRun(at::registerEvent)))));
    }

    public static <T> Promise<T> any(Result<T> failureResult, List<Promise<T>> promises) {
        return Promise.promise((Promise<T> anySuccess) -> ActionableThreshold.threshold(promises.size(), () -> anySuccess.resolve(failureResult)).apply(at -> promises.forEach(promise -> promise.withResult(result -> result.onSuccess(anySuccess::succeed).onSuccessRun(() -> Promise.cancelAll(promises)).onResultRun(at::registerEvent)))));
    }

    @SafeVarargs
    public static <T> Promise<T> any(Promise<T> ... promises) {
        return Promise.any(OTHER_SUCCEEDED, promises);
    }

    public static <T> Promise<T> any(List<Promise<T>> promises) {
        return Promise.any(OTHER_SUCCEEDED, promises);
    }

    @SafeVarargs
    public static <T> void cancelAll(Promise<T> ... promises) {
        Promise.cancelAll(List.of(promises));
    }

    public static <T> void cancelAll(List<Promise<T>> promises) {
        Promise.failAll((Cause)PROMISE_CANCELLED, promises);
    }

    public static <T> Promise<List<Result<T>>> allOf(Collection<Promise<T>> promises) {
        if (promises.isEmpty()) {
            return Promise.success(List.of());
        }
        Promise[] array = promises.toArray(new Promise[0]);
        Promise<Object> promise = Promise.promise();
        ResultCollector collector = ResultCollector.resultCollector(promises.size(), values -> promise.succeed(List.of(values)));
        IntStream.range(0, promises.size()).forEach(index -> array[index].withResult(result -> collector.registerEvent(index, result)));
        return promise.map((? super T list) -> (List)list);
    }

    public static <T1> Mapper1<T1> all(Promise<T1> promise1) {
        Causes.CompositeCause causes = Causes.composite(new Result[0]);
        return () -> promise1.map(Tuple::tuple).mapError(causes::append);
    }

    public static <T1, T2> Mapper2<T1, T2> all(Promise<T1> promise1, Promise<T2> promise2) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1]).id(), promise1, promise2);
    }

    public static <T1, T2, T3> Mapper3<T1, T2, T3> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2]).id(), promise1, promise2, promise3);
    }

    public static <T1, T2, T3, T4> Mapper4<T1, T2, T3, T4> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3]).id(), promise1, promise2, promise3, promise4);
    }

    public static <T1, T2, T3, T4, T5> Mapper5<T1, T2, T3, T4, T5> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4, Promise<T5> promise5) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3], (Result)values[4]).id(), promise1, promise2, promise3, promise4, promise5);
    }

    public static <T1, T2, T3, T4, T5, T6> Mapper6<T1, T2, T3, T4, T5, T6> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4, Promise<T5> promise5, Promise<T6> promise6) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3], (Result)values[4], (Result)values[5]).id(), promise1, promise2, promise3, promise4, promise5, promise6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Mapper7<T1, T2, T3, T4, T5, T6, T7> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4, Promise<T5> promise5, Promise<T6> promise6, Promise<T7> promise7) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3], (Result)values[4], (Result)values[5], (Result)values[6]).id(), promise1, promise2, promise3, promise4, promise5, promise6, promise7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4, Promise<T5> promise5, Promise<T6> promise6, Promise<T7> promise7, Promise<T8> promise8) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3], (Result)values[4], (Result)values[5], (Result)values[6], (Result)values[7]).id(), promise1, promise2, promise3, promise4, promise5, promise6, promise7, promise8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> all(Promise<T1> promise1, Promise<T2> promise2, Promise<T3> promise3, Promise<T4> promise4, Promise<T5> promise5, Promise<T6> promise6, Promise<T7> promise7, Promise<T8> promise8, Promise<T9> promise9) {
        return () -> Promise.setupResult(values -> Result.all((Result)values[0], (Result)values[1], (Result)values[2], (Result)values[3], (Result)values[4], (Result)values[5], (Result)values[6], (Result)values[7], (Result)values[8]).id(), promise1, promise2, promise3, promise4, promise5, promise6, promise7, promise8, promise9);
    }

    private static <R> Promise<R> setupResult(Functions.FnX<Result<R>> transformer, Promise<?> ... promises) {
        Promise promise = Promise.promise();
        ResultCollector collector = ResultCollector.resultCollector(promises.length, values -> promise.resolve((Result)transformer.apply(values)));
        int count = 0;
        for (Promise<?> p : promises) {
            int index = count++;
            p.withResult(result -> collector.registerEvent(index, result));
        }
        return promise;
    }

    private static /* synthetic */ Promise lambda$orElse$4(Supplier supplier, Cause cause) {
        return (Promise)supplier.get();
    }

    public static interface Mapper1<T1> {
        public Promise<Tuple.Tuple1<T1>> id();

        default public <R> Promise<R> map(Functions.Fn1<R, T1> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn1<Promise<R>, T1> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper2<T1, T2> {
        public Promise<Tuple.Tuple2<T1, T2>> id();

        default public <R> Promise<R> map(Functions.Fn2<R, T1, T2> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn2<Promise<R>, T1, T2> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper3<T1, T2, T3> {
        public Promise<Tuple.Tuple3<T1, T2, T3>> id();

        default public <R> Promise<R> map(Functions.Fn3<R, T1, T2, T3> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn3<Promise<R>, T1, T2, T3> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper4<T1, T2, T3, T4> {
        public Promise<Tuple.Tuple4<T1, T2, T3, T4>> id();

        default public <R> Promise<R> map(Functions.Fn4<R, T1, T2, T3, T4> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn4<Promise<R>, T1, T2, T3, T4> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper5<T1, T2, T3, T4, T5> {
        public Promise<Tuple.Tuple5<T1, T2, T3, T4, T5>> id();

        default public <R> Promise<R> map(Functions.Fn5<R, T1, T2, T3, T4, T5> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn5<Promise<R>, T1, T2, T3, T4, T5> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper6<T1, T2, T3, T4, T5, T6> {
        public Promise<Tuple.Tuple6<T1, T2, T3, T4, T5, T6>> id();

        default public <R> Promise<R> map(Functions.Fn6<R, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn6<Promise<R>, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper7<T1, T2, T3, T4, T5, T6, T7> {
        public Promise<Tuple.Tuple7<T1, T2, T3, T4, T5, T6, T7>> id();

        default public <R> Promise<R> map(Functions.Fn7<R, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn7<Promise<R>, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> {
        public Promise<Tuple.Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> id();

        default public <R> Promise<R> map(Functions.Fn8<R, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn8<Promise<R>, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }

    public static interface Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        public Promise<Tuple.Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> id();

        default public <R> Promise<R> map(Functions.Fn9<R, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Promise<R> flatMap(Functions.Fn9<Promise<R>, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().flatMap((? super T tuple) -> (Promise)tuple.map(mapper));
        }
    }
}

