/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockTestNGMethodHandler
implements MethodHandler {
    private Object annotationEnabler;

    public PowerMockTestNGMethodHandler(Class<?> testClass) {
        try {
            Class<?> annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler");
            this.annotationEnabler = Whitebox.newInstance(annotationEnablerClass);
        }
        catch (ClassNotFoundException e) {
            this.annotationEnabler = null;
        }
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        System.err.println("METHOD = " + thisMethod);
        this.injectMocksUsingAnnotationEnabler(self);
        try {
            Object result = proceed.invoke(self, args);
            if (thisMethod.isAnnotationPresent(Test.class)) {
                this.clearMockFields();
                MockRepository.clear();
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void clearMockFields() throws Exception, IllegalAccessException {
        if (this.annotationEnabler != null) {
            Set mockFields = Whitebox.getFieldsAnnotatedWith((Object)this, (Class[])((Class[])Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"getMockAnnotations", (Object[])new Object[0])));
            for (Field field : mockFields) {
                field.set(this, null);
            }
        }
    }

    private void injectMocksUsingAnnotationEnabler(Object self) throws Exception {
        if (this.annotationEnabler != null) {
            Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"beforeTestMethod", (Class[])new Class[]{Object.class, Method.class, Object[].class}, (Object[])new Object[]{self, null, null});
        }
    }
}

