/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.lang.reflect.Modifier;
import org.powermock.objectweb.asm.ClassAdapter;
import org.powermock.objectweb.asm.ClassVisitor;
import org.powermock.objectweb.asm.MethodVisitor;

class PowerMockClassVisitor
extends ClassAdapter {
    public PowerMockClassVisitor(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int accessModifiersWithFinalRemoved = this.removeFinal(access);
        super.visit(version, accessModifiersWithFinalRemoved, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(this.removeFinal(access), name, desc, signature, exceptions);
    }

    private int setConstructorToPublic(int access) {
        return Modifier.isPublic(access) ? access : access & 1;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, this.removeFinal(access));
    }

    private int removeFinal(int access) {
        return access & 0xFFFFFFEF;
    }

    private boolean isConstructor(String name) {
        return name.equals("<init>");
    }
}

