/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.classloading.ClassloaderExecutor;
import org.powermock.classloading.spi.DeepClonerSPI;
import org.powermock.reflect.Whitebox;

public abstract class AbstractClassloaderExecutor
implements ClassloaderExecutor {
    @Override
    public <T> T execute(Callable<T> callable) {
        this.assertArgumentNotNull(callable, "callable");
        return (T)this.execute(callable, Whitebox.getMethod(callable.getClass(), (String)"call", (Class[])new Class[0]), new Object[0]);
    }

    @Override
    public void execute(Runnable runnable) {
        this.assertArgumentNotNull(runnable, "runnable");
        this.execute(runnable, Whitebox.getMethod(runnable.getClass(), (String)"run", (Class[])new Class[0]), new Object[0]);
    }

    private void assertArgumentNotNull(Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException(argumentName + " cannot be null.");
        }
    }

    protected abstract Object execute(Object var1, Method var2, Object ... var3);

    Object executeWithClassLoader(Object instance, Method method, ClassLoader classloader, Object[] arguments) {
        DeepClonerSPI deepCloner = this.createDeepCloner(classloader);
        Object objectLoadedWithClassloader = deepCloner.clone(instance);
        Object[] argumentsLoadedByClassLoader = this.cloneArguments(arguments, deepCloner);
        Object result = this.getResult(method, objectLoadedWithClassloader, argumentsLoadedByClassLoader);
        return this.cloneResult(result);
    }

    private Object cloneResult(Object result) {
        return result == null ? null : this.createDeepCloner(this.getClass().getClassLoader()).clone(result);
    }

    private Object getResult(Method method, Object objectLoadedWithClassloader, Object[] argumentsLoadedByClassLoader) {
        Object result = null;
        try {
            result = Whitebox.invokeMethod((Object)objectLoadedWithClassloader, (String)method.getName(), (Object[])argumentsLoadedByClassLoader);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return result;
    }

    private Object[] cloneArguments(Object[] arguments, DeepClonerSPI deepCloner) {
        Object[] argumentsLoadedByClassLoader = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            argumentsLoadedByClassLoader[i] = deepCloner.clone(argument);
        }
        return argumentsLoadedByClassLoader;
    }

    private DeepClonerSPI createDeepCloner(ClassLoader classLoader) {
        Class deepClonerClass = ClassLoaderUtil.loadClass((String)"org.powermock.classloading.DeepCloner");
        Constructor constructor = Whitebox.getConstructor((Class)deepClonerClass, (Class[])new Class[]{ClassLoader.class});
        try {
            return (DeepClonerSPI)constructor.newInstance(classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate DeepCloner. The DeepCloner implementation must have a one-arg constructor taking a Classloader as parameter.", e);
        }
    }
}

