/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support.membermodification.strategy.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.powermock.api.support.MethodProxy;
import org.powermock.api.support.membermodification.strategy.MethodReplaceStrategy;

public class MethodReplaceStrategyImpl
implements MethodReplaceStrategy {
    private final Method method;

    public MethodReplaceStrategyImpl(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Cannot replace a null method.");
        }
        this.method = method;
    }

    public void with(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("A metod cannot be replaced with null.");
        }
        if (!Modifier.isStatic(this.method.getModifiers())) {
            throw new IllegalArgumentException(String.format("Replace requires static methods, '%s' is not static", this.method));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("Replace requires static methods, '%s' is not static", method));
        }
        MethodProxy.proxy(this.method, new MethodInvocationHandler(method));
    }

    public void with(InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            throw new IllegalArgumentException("Invocation handler cannot be null");
        }
        MethodProxy.proxy(this.method, invocationHandler);
    }

    private final class MethodInvocationHandler
    implements InvocationHandler {
        private final Method methodDelegator;

        public MethodInvocationHandler(Method methodDelegator) {
            this.methodDelegator = methodDelegator;
        }

        public Object invoke(Object object, Method invokingMethod, Object[] arguments) throws Throwable {
            return this.methodDelegator.invoke(object, arguments);
        }
    }
}

