/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.easymock.mockpolicies;

import java.lang.reflect.Method;
import org.easymock.classextension.EasyMock;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.mockpolicies.MockPolicyClassLoadingSettings;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;
import org.powermock.mockpolicies.support.LogPolicySupport;

abstract class AbstractEasyMockLogPolicyBase
implements PowerMockPolicy {
    AbstractEasyMockLogPolicyBase() {
    }

    public void applyClassLoadingPolicy(MockPolicyClassLoadingSettings settings) {
        settings.addFullyQualifiedNamesOfClassesToLoadByMockClassloader(this.getFullyQualifiedNamesOfClassesToLoadByMockClassloader());
    }

    public void applyInterceptionPolicy(MockPolicyInterceptionSettings settings) {
        LogPolicySupport support = new LogPolicySupport();
        Method[] loggerFactoryMethods = support.getLoggerMethods(this.getLoggerFactoryClassName(), this.getLoggerMethodName(), this.getLogFrameworkName());
        Class loggerType = null;
        try {
            loggerType = support.getType(this.getLoggerClassToMock(), this.getLogFrameworkName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Object loggerMock = PowerMock.createNiceMock(loggerType);
        EasyMock.makeThreadSafe(loggerMock, (boolean)true);
        for (Method method : loggerFactoryMethods) {
            settings.stubMethod(method, loggerMock);
        }
    }

    protected abstract String getLoggerMethodName();

    protected abstract String getLoggerFactoryClassName();

    protected abstract String getLoggerClassToMock();

    protected abstract String getLogFrameworkName();

    protected abstract String[] getFullyQualifiedNamesOfClassesToLoadByMockClassloader();
}

