/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class FunctionCallResponse
implements BackendMessage {
    private static final int NULL = -1;
    private final ByteBuffer value;

    public FunctionCallResponse(@Nullable ByteBuf value) {
        this.value = value == null ? null : ByteBufferUtils.toByteBuffer(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCallResponse that = (FunctionCallResponse)o;
        return Objects.equals(this.value, that.value);
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "FunctionCallResponse{value=" + this.value + '}';
    }

    static FunctionCallResponse decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int length = in.readInt();
        ByteBuf value = -1 == length ? null : in.readSlice(length);
        return new FunctionCallResponse(value);
    }
}

