/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jspecify.annotations.Nullable;

final class NumericDecodeUtils {
    private NumericDecodeUtils() {
    }

    public static Number decodeNumber(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        switch (dataType) {
            case NUMERIC: 
            case NUMERIC_ARRAY: {
                if (format == Format.FORMAT_BINARY) {
                    return NumericDecodeUtils.decodeBinary(buffer);
                }
                return new BigDecimal(ByteBufUtils.decode(buffer));
            }
            case INT2: 
            case INT2_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readShort();
                }
                return Short.parseShort(ByteBufUtils.decode(buffer));
            }
            case INT4: 
            case INT4_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readInt();
                }
                return Integer.parseInt(ByteBufUtils.decode(buffer));
            }
            case OID: 
            case OID_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readUnsignedInt();
                }
                return Long.parseLong(ByteBufUtils.decode(buffer));
            }
            case INT8: 
            case INT8_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readLong();
                }
                return Long.parseLong(ByteBufUtils.decode(buffer));
            }
            case FLOAT4: 
            case FLOAT4_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return Float.valueOf(buffer.readFloat());
                }
                return Float.valueOf(Float.parseFloat(ByteBufUtils.decode(buffer)));
            }
            case FLOAT8: 
            case FLOAT8_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readDouble();
                }
                return Double.parseDouble(ByteBufUtils.decode(buffer));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot decode value for type %s, format %s", new Object[]{dataType, format}));
    }

    public static BigDecimal decodeBinary(ByteBuf byteBuf) {
        short numOfDigits = byteBuf.readShort();
        if (numOfDigits == 0) {
            return BigDecimal.ZERO;
        }
        short weight = byteBuf.readShort();
        short sign = byteBuf.readShort();
        short scale = byteBuf.readShort();
        short[] digits = new short[numOfDigits];
        for (short i = 0; i < numOfDigits; i = (short)(i + 1)) {
            digits[i] = byteBuf.readShort();
        }
        StringBuilder sb = new StringBuilder((sign != 0 ? 1 : 0) + 2 + digits.length * 4);
        if (sign != 0) {
            sb.append("-");
        }
        sb.append("0.");
        for (short digit : digits) {
            String rendered = "" + digit;
            for (int padded = rendered.length(); padded < 4; ++padded) {
                sb.append("0");
            }
            sb.append(rendered);
        }
        return new BigDecimal(sb.toString()).movePointRight((weight + 1) * 4).setScale((int)scale, RoundingMode.DOWN);
    }
}

