/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.BigDecimalCodec;
import io.r2dbc.postgresql.codec.BigIntegerCodec;
import io.r2dbc.postgresql.codec.BinaryByteArrayCodec;
import io.r2dbc.postgresql.codec.BinaryByteBufferCodec;
import io.r2dbc.postgresql.codec.BlobCodec;
import io.r2dbc.postgresql.codec.BooleanCodec;
import io.r2dbc.postgresql.codec.BoxCodec;
import io.r2dbc.postgresql.codec.ByteCodec;
import io.r2dbc.postgresql.codec.CachedCodecLookup;
import io.r2dbc.postgresql.codec.CharacterCodecProvider;
import io.r2dbc.postgresql.codec.CircleCodec;
import io.r2dbc.postgresql.codec.ClobCodec;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecConfiguration;
import io.r2dbc.postgresql.codec.CodecLookup;
import io.r2dbc.postgresql.codec.CodecMetadata;
import io.r2dbc.postgresql.codec.CodecRegistry;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.codec.ConvertingArrayCodec;
import io.r2dbc.postgresql.codec.DateCodec;
import io.r2dbc.postgresql.codec.DayOfWeekCodec;
import io.r2dbc.postgresql.codec.DoubleCodec;
import io.r2dbc.postgresql.codec.FloatCodec;
import io.r2dbc.postgresql.codec.InetAddressCodec;
import io.r2dbc.postgresql.codec.InstantCodec;
import io.r2dbc.postgresql.codec.IntegerCodec;
import io.r2dbc.postgresql.codec.IntervalCodec;
import io.r2dbc.postgresql.codec.JsonByteArrayCodec;
import io.r2dbc.postgresql.codec.JsonByteBufCodec;
import io.r2dbc.postgresql.codec.JsonByteBufferCodec;
import io.r2dbc.postgresql.codec.JsonCodec;
import io.r2dbc.postgresql.codec.JsonInputStreamCodec;
import io.r2dbc.postgresql.codec.JsonStringCodec;
import io.r2dbc.postgresql.codec.LineCodec;
import io.r2dbc.postgresql.codec.LocalDateCodec;
import io.r2dbc.postgresql.codec.LocalDateTimeCodec;
import io.r2dbc.postgresql.codec.LocalTimeCodec;
import io.r2dbc.postgresql.codec.LongCodec;
import io.r2dbc.postgresql.codec.LsegCodec;
import io.r2dbc.postgresql.codec.MonthCodec;
import io.r2dbc.postgresql.codec.MonthDayCodec;
import io.r2dbc.postgresql.codec.ObjectCodec;
import io.r2dbc.postgresql.codec.OffsetDateTimeCodec;
import io.r2dbc.postgresql.codec.OffsetTimeCodec;
import io.r2dbc.postgresql.codec.PathCodec;
import io.r2dbc.postgresql.codec.PeriodCodec;
import io.r2dbc.postgresql.codec.PointCodec;
import io.r2dbc.postgresql.codec.PolygonCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PrimitiveWrapperCodecProvider;
import io.r2dbc.postgresql.codec.RefCursorCodec;
import io.r2dbc.postgresql.codec.RefCursorNameCodec;
import io.r2dbc.postgresql.codec.ShortCodec;
import io.r2dbc.postgresql.codec.StringArrayCodec;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.codec.UriCodec;
import io.r2dbc.postgresql.codec.UrlCodec;
import io.r2dbc.postgresql.codec.UuidCodec;
import io.r2dbc.postgresql.codec.YearCodec;
import io.r2dbc.postgresql.codec.YearMonthCodec;
import io.r2dbc.postgresql.codec.ZoneIdCodec;
import io.r2dbc.postgresql.codec.ZonedDateTimeCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

public final class DefaultCodecs
implements Codecs,
CodecRegistry {
    private final List<Codec<?>> codecs;
    private final CodecLookup codecLookup;

    public DefaultCodecs(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, false);
    }

    public DefaultCodecs(ByteBufAllocator byteBufAllocator, boolean preferAttachedBuffers) {
        this(byteBufAllocator, preferAttachedBuffers, () -> TimeZone.getDefault().toZoneId());
    }

    public DefaultCodecs(ByteBufAllocator byteBufAllocator, boolean preferAttachedBuffers, CodecConfiguration configuration) {
        this(byteBufAllocator, preferAttachedBuffers, configuration, CachedCodecLookup::new);
    }

    DefaultCodecs(ByteBufAllocator byteBufAllocator, boolean preferAttachedBuffers, CodecConfiguration configuration, Function<CodecRegistry, CodecLookup> codecLookupFunction) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Assert.requireNonNull(configuration, "configuration must not be null");
        Assert.requireNonNull(codecLookupFunction, "codecLookupFunction must not be null");
        this.codecLookup = codecLookupFunction.apply(this);
        this.codecs = DefaultCodecs.getDefaultCodecs(byteBufAllocator, preferAttachedBuffers, configuration);
        this.codecLookup.afterCodecAdded();
    }

    private static List<Codec<?>> getDefaultCodecs(ByteBufAllocator byteBufAllocator, boolean preferAttachedBuffers, CodecConfiguration configuration) {
        AbstractCodec[] abstractCodecArray = new AbstractCodec[51];
        abstractCodecArray[0] = new StringCodec(byteBufAllocator);
        abstractCodecArray[1] = new InstantCodec(byteBufAllocator, configuration::getZoneId);
        abstractCodecArray[2] = new ZonedDateTimeCodec(byteBufAllocator);
        abstractCodecArray[3] = new BinaryByteBufferCodec(byteBufAllocator);
        abstractCodecArray[4] = new BinaryByteArrayCodec(byteBufAllocator);
        abstractCodecArray[5] = new BigDecimalCodec(byteBufAllocator);
        abstractCodecArray[6] = new BigIntegerCodec(byteBufAllocator);
        abstractCodecArray[7] = new BooleanCodec(byteBufAllocator);
        abstractCodecArray[8] = new CharacterCodecProvider(byteBufAllocator);
        abstractCodecArray[9] = new DoubleCodec(byteBufAllocator);
        abstractCodecArray[10] = new FloatCodec(byteBufAllocator);
        abstractCodecArray[11] = new InetAddressCodec(byteBufAllocator);
        abstractCodecArray[12] = new IntegerCodec(byteBufAllocator);
        abstractCodecArray[13] = new IntervalCodec(byteBufAllocator);
        abstractCodecArray[14] = new LocalDateCodec(byteBufAllocator);
        abstractCodecArray[15] = new LocalDateTimeCodec(byteBufAllocator, configuration::getZoneId);
        abstractCodecArray[16] = new LocalTimeCodec(byteBufAllocator);
        abstractCodecArray[17] = new LongCodec(byteBufAllocator);
        abstractCodecArray[18] = new OffsetDateTimeCodec(byteBufAllocator);
        abstractCodecArray[19] = new OffsetTimeCodec(byteBufAllocator);
        abstractCodecArray[20] = new ShortCodec(byteBufAllocator);
        abstractCodecArray[21] = new UriCodec(byteBufAllocator);
        abstractCodecArray[22] = new UrlCodec(byteBufAllocator);
        abstractCodecArray[23] = new UuidCodec(byteBufAllocator);
        abstractCodecArray[24] = new ZoneIdCodec(byteBufAllocator);
        abstractCodecArray[25] = new DayOfWeekCodec(byteBufAllocator);
        abstractCodecArray[26] = new MonthCodec(byteBufAllocator);
        abstractCodecArray[27] = new MonthDayCodec(byteBufAllocator);
        abstractCodecArray[28] = new PeriodCodec(byteBufAllocator);
        abstractCodecArray[29] = new YearCodec(byteBufAllocator);
        abstractCodecArray[30] = new YearMonthCodec(byteBufAllocator);
        abstractCodecArray[31] = new JsonCodec(byteBufAllocator, preferAttachedBuffers);
        abstractCodecArray[32] = new JsonByteArrayCodec(byteBufAllocator);
        abstractCodecArray[33] = new JsonByteBufCodec(byteBufAllocator);
        abstractCodecArray[34] = new JsonByteBufferCodec(byteBufAllocator);
        abstractCodecArray[35] = new JsonInputStreamCodec(byteBufAllocator);
        abstractCodecArray[36] = new JsonStringCodec(byteBufAllocator);
        abstractCodecArray[37] = new ByteCodec(byteBufAllocator);
        abstractCodecArray[38] = new DateCodec(byteBufAllocator, configuration::getZoneId);
        abstractCodecArray[39] = new BlobCodec(byteBufAllocator);
        abstractCodecArray[40] = new ClobCodec(byteBufAllocator);
        abstractCodecArray[41] = RefCursorCodec.INSTANCE;
        abstractCodecArray[42] = RefCursorNameCodec.INSTANCE;
        abstractCodecArray[43] = new StringArrayCodec(byteBufAllocator);
        abstractCodecArray[44] = new CircleCodec(byteBufAllocator);
        abstractCodecArray[45] = new PointCodec(byteBufAllocator);
        abstractCodecArray[46] = new BoxCodec(byteBufAllocator);
        abstractCodecArray[47] = new LineCodec(byteBufAllocator);
        abstractCodecArray[48] = new LsegCodec(byteBufAllocator);
        abstractCodecArray[49] = new PathCodec(byteBufAllocator);
        abstractCodecArray[50] = new PolygonCodec(byteBufAllocator);
        CopyOnWriteArrayList codecs = new CopyOnWriteArrayList(Arrays.asList(abstractCodecArray));
        ArrayList<Codec<Object[]>> additionalCodecs = new ArrayList<Codec<Object[]>>();
        for (Codec codec : codecs) {
            if (codec instanceof ArrayCodecDelegate) {
                Assert.requireType(codec, AbstractCodec.class, "Codec " + codec + " must be a subclass of AbstractCodec to be registered as generic array codec");
                ArrayCodecDelegate delegate = (ArrayCodecDelegate)((Object)codec);
                Class<?> componentType = delegate.type();
                if (codec instanceof BoxCodec) {
                    additionalCodecs.add(new ArrayCodec(byteBufAllocator, delegate.getArrayDataType(), delegate, componentType, 59));
                } else if (codec instanceof AbstractNumericCodec) {
                    additionalCodecs.add(new ConvertingArrayCodec(byteBufAllocator, delegate, componentType, ConvertingArrayCodec.NUMERIC_ARRAY_TYPES));
                } else if (codec instanceof AbstractTemporalCodec) {
                    additionalCodecs.add(new ConvertingArrayCodec(byteBufAllocator, delegate, componentType, ConvertingArrayCodec.DATE_ARRAY_TYPES));
                } else {
                    additionalCodecs.add(new ArrayCodec(byteBufAllocator, delegate, componentType));
                }
            }
            if (!(codec instanceof PrimitiveWrapperCodecProvider)) continue;
            additionalCodecs.add(((PrimitiveWrapperCodecProvider)((Object)codec)).getPrimitiveCodec());
        }
        codecs.addAll(additionalCodecs);
        return codecs;
    }

    @Override
    public void addFirst(Codec<?> codec) {
        Assert.requireNonNull(codec, "codec must not be null");
        this.codecs.add(0, codec);
        this.codecLookup.afterCodecAdded();
    }

    @Override
    public void addLast(Codec<?> codec) {
        Assert.requireNonNull(codec, "codec must not be null");
        this.codecs.add(codec);
        this.codecLookup.afterCodecAdded();
    }

    @Override
    public <T> @Nullable T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        int varcharType;
        Codec<? extends T> varcharFallback;
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (buffer == null) {
            return null;
        }
        Codec<? extends T> codec = this.codecLookup.findDecodeCodec(dataType, format, type);
        if (codec != null) {
            return codec.decode(buffer, dataType, format, type);
        }
        if (String.class == type && (varcharFallback = this.codecLookup.findDecodeCodec(varcharType = PostgresqlObjectId.VARCHAR.getObjectId(), format, type)) != null) {
            return varcharFallback.decode(buffer, varcharType, format, type);
        }
        if (StringCodec.STRING_DECODER.canDecode(dataType, format, type)) {
            return type.cast(StringCodec.STRING_DECODER.decode(buffer, dataType, format, type));
        }
        if (StringCodec.STRING_ARRAY_DECODER.canDecode(dataType, format, type)) {
            return type.cast(StringCodec.STRING_ARRAY_DECODER.decode(buffer, dataType, format, type));
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s with OID %d", type.getName(), dataType));
    }

    @Override
    public EncodedParameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        PostgresTypeIdentifier dataType = null;
        Object parameterValue = value;
        if (value instanceof Parameter) {
            Parameter parameter = (Parameter)value;
            parameterValue = parameter.getValue();
            if (parameter.getType() instanceof Type.InferredType && parameterValue == null) {
                return this.encodeNull(parameter.getType().getJavaType());
            }
            if (parameter.getType() instanceof R2dbcType) {
                dataType = PostgresqlObjectId.valueOf((R2dbcType)parameter.getType());
            }
            if (parameter.getType() instanceof PostgresTypeIdentifier) {
                dataType = (PostgresTypeIdentifier)parameter.getType();
            }
        }
        return this.encodeParameterValue(value, dataType, parameterValue);
    }

    EncodedParameter encodeParameterValue(Object value, @Nullable PostgresTypeIdentifier dataType, @Nullable Object parameterValue) {
        if (dataType == null) {
            if (parameterValue == null) {
                return ObjectCodec.INSTANCE.encodeNull();
            }
            Codec<Object> codec = this.codecLookup.findEncodeCodec(parameterValue);
            if (codec != null) {
                return codec.encode(parameterValue);
            }
        } else {
            if (parameterValue == null) {
                return new EncodedParameter(Format.FORMAT_BINARY, dataType.getObjectId(), (Publisher<? extends ByteBuf>)EncodedParameter.NULL_VALUE);
            }
            Codec<Object> codec = this.codecLookup.findEncodeCodec(parameterValue);
            if (codec != null) {
                return codec.encode(parameterValue, dataType.getObjectId());
            }
        }
        throw new IllegalArgumentException(String.format("Cannot encode parameter of type %s (%s)", value.getClass().getName(), parameterValue));
    }

    @Override
    public EncodedParameter encodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        if (type == Object.class) {
            return ObjectCodec.INSTANCE.encodeNull();
        }
        Codec<?> codec = this.codecLookup.findEncodeNullCodec(type);
        if (codec != null) {
            return codec.encodeNull();
        }
        throw new IllegalArgumentException(String.format("Cannot encode null parameter of type %s", type.getName()));
    }

    @Override
    public Class<?> preferredType(int dataType, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Codec<Object> codec = this.codecLookup.findDecodeCodec(dataType, format, Object.class);
        if (codec instanceof CodecMetadata) {
            return ((CodecMetadata)((Object)codec)).type();
        }
        return null;
    }

    @Override
    public Iterator<Codec<?>> iterator() {
        return Collections.unmodifiableList(new ArrayList(this.codecs)).iterator();
    }
}

