/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.LocalDateTimeCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class DateCodec
extends AbstractCodec<Date>
implements ArrayCodecDelegate<Date> {
    private final LocalDateTimeCodec delegate;
    private final Supplier<ZoneId> zoneIdSupplier;

    DateCodec(ByteBufAllocator byteBufAllocator, Supplier<ZoneId> zoneIdSupplier) {
        super(Date.class);
        this.delegate = new LocalDateTimeCodec(byteBufAllocator, zoneIdSupplier);
        this.zoneIdSupplier = Assert.requireNonNull(zoneIdSupplier, "zoneIdSupplier must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }

    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return this.delegate.getDataTypes();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    Date doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends Date> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Object intermediary = this.delegate.doDecode(buffer, dataType, format, LocalDateTime.class);
        return Date.from(((LocalDateTime)intermediary).atZone(this.zoneIdSupplier.get()).toInstant());
    }

    @Override
    EncodedParameter doEncode(Date value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(this.normalize(value));
    }

    @Override
    EncodedParameter doEncode(Date value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(this.normalize(value), dataType);
    }

    @Override
    public String encodeToText(Date value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.normalize(value).toString();
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return this.delegate.getArrayDataType();
    }

    private LocalDateTime normalize(Date value) {
        return value.toInstant().atZone(this.zoneIdSupplier.get()).toLocalDateTime();
    }
}

