/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.util.Assert;
import org.jspecify.annotations.Nullable;

public final class SingleHostConfiguration {
    private final @Nullable String host;
    private final int port;
    private final @Nullable String socket;

    private SingleHostConfiguration(@Nullable String host, int port, @Nullable String socket) {
        this.host = host;
        this.port = port;
        this.socket = socket;
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequiredHost() {
        String host = this.getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalStateException("Connection is configured for socket connections and not for host usage");
        }
        return host;
    }

    public String getRequiredSocket() {
        String socket = this.getSocket();
        if (socket == null || socket.isEmpty()) {
            throw new IllegalStateException("Connection is configured to use host and port connections and not for socket usage");
        }
        return socket;
    }

    public @Nullable String getSocket() {
        return this.socket;
    }

    public boolean isUseSocket() {
        return this.getSocket() != null;
    }

    public String toString() {
        return "SingleHostConfiguration{host='" + this.host + '\'' + ", port=" + this.port + ", socket='" + this.socket + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String host;
        private int port = 5432;
        private @Nullable String socket;

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder socket(String socket) {
            this.socket = Assert.requireNonNull(socket, "host must not be null");
            return this;
        }

        public SingleHostConfiguration build() {
            if (this.host == null && this.socket == null) {
                throw new IllegalArgumentException("host or socket must not be null");
            }
            if (this.host != null && this.socket != null) {
                throw new IllegalArgumentException("Connection must be configured for either host/port or socket usage but not both");
            }
            return new SingleHostConfiguration(this.host, this.port, this.socket);
        }

        public @Nullable String getSocket() {
            return this.socket;
        }

        public String toString() {
            return "Builder{host='" + this.host + '\'' + ", port=" + this.port + ", socket='" + this.socket + '\'' + '}';
        }
    }
}

