/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PreferredCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Set;

final class ConvertingArrayCodec<T>
extends ArrayCodec<T>
implements PreferredCodec {
    static final Set<PostgresqlObjectId> NUMERIC_ARRAY_TYPES = EnumSet.of(PostgresqlObjectId.INT2_ARRAY, new PostgresqlObjectId[]{PostgresqlObjectId.INT4_ARRAY, PostgresqlObjectId.INT8_ARRAY, PostgresqlObjectId.FLOAT4_ARRAY, PostgresqlObjectId.FLOAT8_ARRAY, PostgresqlObjectId.NUMERIC_ARRAY, PostgresqlObjectId.OID_ARRAY});
    static final Set<PostgresqlObjectId> DATE_ARRAY_TYPES = EnumSet.of(PostgresqlObjectId.DATE_ARRAY, PostgresqlObjectId.TIMESTAMP_ARRAY, PostgresqlObjectId.TIMESTAMPTZ_ARRAY, PostgresqlObjectId.TIME_ARRAY, PostgresqlObjectId.TIMETZ_ARRAY);
    private final ArrayCodecDelegate<T> delegate;
    private final Class<T> componentType;
    private final Class<?> arrayClass;
    private final Set<PostgresqlObjectId> supportedTypes;

    public ConvertingArrayCodec(ByteBufAllocator byteBufAllocator, ArrayCodecDelegate<T> delegate, Class<T> componentType, Set<PostgresqlObjectId> supportedTypes) {
        super(byteBufAllocator, delegate, componentType);
        this.delegate = delegate;
        this.componentType = componentType;
        this.arrayClass = Array.newInstance(this.componentType, 0).getClass();
        this.supportedTypes = supportedTypes;
    }

    @Override
    public boolean isPreferred(int dataType, Format format, Class<?> type) {
        return type == Object.class && dataType == this.getDelegate().getArrayDataType().getObjectId();
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        return PostgresqlObjectId.isValid(dataType) && this.supportedTypes.contains(PostgresqlObjectId.valueOf(dataType)) && (type.isAssignableFrom(this.arrayClass) || type.isArray() && this.getActualComponentType(type).isAssignableFrom(this.getComponentType()));
    }

    @Override
    Object[] doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends Object[]> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (Format.FORMAT_BINARY == format) {
            return ConvertingArrayCodec.decodeBinary(buffer, dataType, this.delegate, this.componentType, type);
        }
        return ConvertingArrayCodec.decodeText(buffer, dataType, (byte)44, this.delegate, this.componentType, type);
    }
}

