/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class LocalDateTimeCodec
extends AbstractTemporalCodec<LocalDateTime> {
    LocalDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(LocalDateTime.class, byteBufAllocator, PostgresqlObjectId.TIMESTAMP, PostgresqlObjectId.TIMESTAMP_ARRAY, LocalDateTime::toString);
    }

    @Override
    LocalDateTime doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends LocalDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalDateTime.class, temporal -> {
            if (temporal instanceof LocalDate) {
                return ((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toLocalDateTime();
            }
            return Instant.from(temporal).atOffset(ZoneOffset.UTC).toLocalDateTime();
        });
    }
}

