/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.r2dbc.postgresql.client.AbstractPostgresSSLHandlerAdapter;
import io.r2dbc.postgresql.client.BalancedResolverGroup;
import io.r2dbc.postgresql.client.CancelRequestMessageFlow;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ConnectionContext;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.client.SSLSessionHandlerAdapter;
import io.r2dbc.postgresql.client.SSLTunnelHandlerAdapter;
import io.r2dbc.postgresql.client.TransactionStatus;
import io.r2dbc.postgresql.client.Version;
import io.r2dbc.postgresql.message.backend.BackendKeyData;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageDecoder;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.backend.Field;
import io.r2dbc.postgresql.message.backend.NoticeResponse;
import io.r2dbc.postgresql.message.backend.NotificationResponse;
import io.r2dbc.postgresql.message.backend.ParameterStatus;
import io.r2dbc.postgresql.message.backend.ReadyForQuery;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.Terminate;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.TcpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class ReactorNettyClient
implements Client {
    private static final Logger logger = Loggers.getLogger(ReactorNettyClient.class);
    private static final boolean DEBUG_ENABLED = logger.isDebugEnabled();
    private static final Supplier<PostgresConnectionClosedException> UNEXPECTED = () -> new PostgresConnectionClosedException("Connection unexpectedly closed");
    private static final Supplier<PostgresConnectionClosedException> EXPECTED = () -> new PostgresConnectionClosedException("Connection closed");
    private final ByteBufAllocator byteBufAllocator;
    private final ConnectionSettings settings;
    private final Connection connection;
    private ConnectionContext context;
    private final Sinks.Many<Publisher<FrontendMessage>> requestSink = Sinks.many().unicast().onBackpressureBuffer();
    private final Sinks.Many<NotificationResponse> notificationProcessor = Sinks.many().multicast().directBestEffort();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final BackendMessageSubscriber messageSubscriber = new BackendMessageSubscriber();
    private volatile Integer processId;
    private volatile Integer secretKey;
    private volatile TransactionStatus transactionStatus = TransactionStatus.IDLE;
    private volatile Version version = new Version("", 0);

    private ReactorNettyClient(Connection connection, ConnectionSettings settings) {
        Assert.requireNonNull(connection, "Connection must not be null");
        this.settings = Assert.requireNonNull(settings, "ConnectionSettings must not be null");
        connection.addHandler((ChannelHandler)new LengthFieldBasedFrameDecoder(0x7FFFFFFA, 1, 4, -4, 0));
        connection.addHandler((ChannelHandler)new EnsureSubscribersCompleteChannelHandler(this.requestSink));
        this.connection = connection;
        this.byteBufAllocator = connection.outbound().alloc();
        this.context = new ConnectionContext().withChannelId(connection.channel().toString());
        AtomicReference receiveError = new AtomicReference();
        connection.inbound().receive().map(BackendMessageDecoder::decode).doOnError(receiveError::set).handle((backendMessage, sink) -> {
            if (this.consumeMessage((BackendMessage)backendMessage)) {
                return;
            }
            sink.next(backendMessage);
        }).subscribe((CoreSubscriber)this.messageSubscriber);
        Mono request = this.requestSink.asFlux().concatMap(Function.identity()).flatMap(message -> {
            if (DEBUG_ENABLED) {
                logger.debug(this.context.getMessage(String.format("Request:  %s", message)));
            }
            return connection.outbound().send(message.encode(this.byteBufAllocator));
        }, 1).then();
        request.onErrorResume(this::resumeError).doAfterTerminate(this::handleClose).subscribe();
    }

    @Override
    public Mono<Void> close() {
        return Mono.defer(() -> {
            this.notificationProcessor.tryEmitComplete();
            this.drainError(EXPECTED);
            boolean connected = this.isConnected();
            if (this.isClosed.compareAndSet(false, true)) {
                if (!connected || this.processId == null) {
                    return this.closeConnection();
                }
                return Flux.just((Object)Terminate.INSTANCE).doOnNext(message -> logger.debug(this.context.getMessage(String.format("Request:  %s", message)))).concatMap(message -> this.connection.outbound().send(message.encode(this.connection.outbound().alloc()))).then().doOnSuccess(v -> this.connection.dispose()).then(this.connection.onDispose());
            }
            return Mono.empty();
        });
    }

    private Mono<? extends Void> closeConnection() {
        this.connection.dispose();
        return this.connection.onDispose();
    }

    @Override
    public Flux<BackendMessage> exchange(Predicate<BackendMessage> takeUntil, Publisher<FrontendMessage> requests) {
        Assert.requireNonNull(takeUntil, "takeUntil must not be null");
        Assert.requireNonNull(requests, "requests must not be null");
        return this.messageSubscriber.addConversation(takeUntil, requests, it -> this.requestSink.emitNext(it, Sinks.EmitFailureHandler.FAIL_FAST), this::isConnected);
    }

    @Override
    public void send(FrontendMessage message) {
        Assert.requireNonNull(message, "requests must not be null");
        this.requestSink.emitNext((Object)Mono.just((Object)message), Sinks.EmitFailureHandler.FAIL_FAST);
    }

    private Mono<Void> resumeError(Throwable throwable) {
        this.handleConnectionError(throwable);
        this.requestSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
        if (ReactorNettyClient.isSslException(throwable)) {
            logger.debug(this.context.getMessage("Connection Error"), throwable);
        } else {
            logger.warn(this.context.getMessage("Connection Error"), throwable);
        }
        return this.close();
    }

    private static boolean isSslException(Throwable throwable) {
        return throwable instanceof SSLException || throwable.getCause() instanceof SSLException;
    }

    private boolean consumeMessage(BackendMessage message) {
        if (DEBUG_ENABLED) {
            logger.debug(this.context.getMessage(String.format("Response: %s", message)));
        }
        if (message.getClass() == NoticeResponse.class) {
            this.settings.getNoticeLogLevel().log(logger, () -> this.context.getMessage(String.format("Notice: %s", ReactorNettyClient.toString(((NoticeResponse)message).getFields()))));
            return true;
        }
        if (message.getClass() == BackendKeyData.class) {
            BackendKeyData backendKeyData = (BackendKeyData)message;
            this.processId = backendKeyData.getProcessId();
            this.context = this.context.withProcessId(this.processId);
            this.secretKey = backendKeyData.getSecretKey();
            return true;
        }
        if (message.getClass() == ErrorResponse.class) {
            this.settings.getErrorResponseLogLevel().log(logger, () -> String.format("Error: %s", ReactorNettyClient.toString(((ErrorResponse)message).getFields())));
        }
        if (message.getClass() == ParameterStatus.class) {
            this.handleParameterStatus((ParameterStatus)message);
        }
        if (message.getClass() == ReadyForQuery.class) {
            this.transactionStatus = TransactionStatus.valueOf(((ReadyForQuery)message).getTransactionStatus());
        }
        if (message.getClass() == NotificationResponse.class) {
            this.notificationProcessor.tryEmitNext((Object)((NotificationResponse)message));
            return true;
        }
        return false;
    }

    private void handleParameterStatus(ParameterStatus message) {
        Version existingVersion = this.version;
        String versionString = existingVersion.getVersion();
        int versionNum = existingVersion.getVersionNumber();
        if (message.getName().equals("server_version_num")) {
            versionNum = Integer.parseInt(message.getValue());
        }
        if (message.getName().equals("server_version")) {
            versionString = message.getValue();
            if (versionNum == 0) {
                versionNum = Version.parseServerVersionStr(versionString);
            }
        }
        this.version = new Version(versionString, versionNum);
    }

    public static Mono<ReactorNettyClient> connect(String host, int port) {
        Assert.requireNonNull(host, "host must not be null");
        return ReactorNettyClient.connect(host, port, null, new SSLConfig(SSLMode.DISABLE, null, null));
    }

    public static Mono<ReactorNettyClient> connect(String host, int port, @Nullable Duration connectTimeout, SSLConfig sslConfig) {
        Assert.requireNonNull(host, "host must not be null");
        Assert.requireNonNull(sslConfig, "sslConfig must not be null");
        ConnectionSettings.Builder builder = ConnectionSettings.builder().connectTimeout(connectTimeout).sslConfig(sslConfig);
        return ReactorNettyClient.connect(InetSocketAddress.createUnresolved(host, port), builder.build());
    }

    public static Mono<ReactorNettyClient> connect(SocketAddress socketAddress, ConnectionSettings settings) {
        Assert.requireNonNull(socketAddress, "socketAddress must not be null");
        Assert.requireNonNull(settings, "settings must not be null");
        TcpClient tcpClient = TcpClient.create((ConnectionProvider)settings.getConnectionProvider()).remoteAddress(() -> socketAddress);
        if (settings.hasLoopResources()) {
            tcpClient = tcpClient.runOn(settings.getRequiredLoopResources());
        }
        if (socketAddress instanceof InetSocketAddress) {
            tcpClient = tcpClient.resolver((AddressResolverGroup)BalancedResolverGroup.INSTANCE);
            tcpClient = tcpClient.option(ChannelOption.SO_KEEPALIVE, (Object)settings.isTcpKeepAlive());
            tcpClient = tcpClient.option(ChannelOption.TCP_NODELAY, (Object)settings.isTcpNoDelay());
        }
        if (settings.hasConnectionTimeout()) {
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)settings.getConnectTimeoutMs());
        }
        return tcpClient.connect().flatMap(it -> {
            ChannelPipeline pipeline = it.channel().pipeline();
            InternalLogger logger = InternalLoggerFactory.getInstance(ReactorNettyClient.class);
            if (logger.isTraceEnabled()) {
                pipeline.addFirst(LoggingHandler.class.getSimpleName(), (ChannelHandler)new LoggingHandler(ReactorNettyClient.class, LogLevel.TRACE));
            }
            return ReactorNettyClient.registerSslHandler(settings.getSslConfig(), it).thenReturn((Object)new ReactorNettyClient((Connection)it, settings));
        });
    }

    private static Mono<? extends Void> registerSslHandler(SSLConfig sslConfig, Connection it) {
        try {
            if (sslConfig.getSslMode().startSsl()) {
                return Mono.defer(() -> {
                    AbstractPostgresSSLHandlerAdapter sslAdapter = sslConfig.getSslMode() == SSLMode.TUNNEL ? new SSLTunnelHandlerAdapter(it.outbound().alloc(), sslConfig) : new SSLSessionHandlerAdapter(it.outbound().alloc(), sslConfig);
                    it.addHandlerFirst((ChannelHandler)sslAdapter);
                    return sslAdapter.getHandshake();
                }).subscribeOn(Schedulers.boundedElastic());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return Mono.empty();
    }

    @Override
    public Disposable addNotificationListener(Consumer<NotificationResponse> consumer) {
        return this.notificationProcessor.asFlux().subscribe(consumer);
    }

    @Override
    public Disposable addNotificationListener(Subscriber<NotificationResponse> consumer) {
        return this.notificationProcessor.asFlux().subscribe(arg_0 -> consumer.onNext(arg_0), arg_0 -> consumer.onError(arg_0), () -> consumer.onComplete(), arg_0 -> consumer.onSubscribe(arg_0));
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public ConnectionContext getContext() {
        return this.context;
    }

    @Override
    public Optional<Integer> getProcessId() {
        return Optional.ofNullable(this.processId);
    }

    @Override
    public Optional<Integer> getSecretKey() {
        return Optional.ofNullable(this.secretKey);
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isConnected() {
        if (this.isClosed.get()) {
            return false;
        }
        Channel channel = this.connection.channel();
        return channel.isOpen();
    }

    @Override
    public Mono<Void> cancelRequest() {
        return Mono.defer(() -> {
            int processId = this.getProcessId().orElseThrow(() -> new IllegalStateException("Connection does not yet have a processId"));
            int secretKey = this.getSecretKey().orElseThrow(() -> new IllegalStateException("Connection does not yet have a secretKey"));
            return ReactorNettyClient.connect(this.connection.channel().remoteAddress(), this.settings).flatMap(client -> CancelRequestMessageFlow.exchange(client, processId, secretKey).then(Mono.defer(client::closeConnection)).onErrorResume(PostgresConnectionClosedException.class::isInstance, e -> Mono.empty()));
        });
    }

    private static String toString(List<Field> fields) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Field field : fields) {
            joiner.add(field.getType().name() + "=" + field.getValue());
        }
        return joiner.toString();
    }

    private void handleClose() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.drainError(UNEXPECTED);
        } else {
            this.drainError(EXPECTED);
        }
    }

    private void handleConnectionError(Throwable error) {
        this.drainError(() -> new PostgresConnectionException(error));
    }

    private void drainError(Supplier<? extends Throwable> supplier) {
        this.messageSubscriber.close(supplier);
        this.notificationProcessor.tryEmitError(supplier.get());
    }

    static {
        Schedulers.boundedElastic();
    }

    private class BackendMessageSubscriber
    implements CoreSubscriber<BackendMessage> {
        private static final int DEMAND = 256;
        private final Queue<Conversation> conversations = (Queue)Queues.small().get();
        private final Queue<BackendMessage> buffer = (Queue)Queues.get((int)256).get();
        private final AtomicLong demand = new AtomicLong(0L);
        private final AtomicBoolean drain = new AtomicBoolean();
        private volatile boolean terminated;
        private Subscription upstream;

        private BackendMessageSubscriber() {
        }

        public Flux<BackendMessage> addConversation(Predicate<BackendMessage> takeUntil, Publisher<FrontendMessage> requests, Consumer<Flux<FrontendMessage>> sender, Supplier<Boolean> isConnected) {
            return Flux.create(sink -> {
                Conversation conversation = new Conversation(takeUntil, (FluxSink)sink);
                Queue<Conversation> queue = this.conversations;
                synchronized (queue) {
                    if (this.conversations.offer(conversation)) {
                        sink.onRequest(value -> this.onRequest(conversation, value));
                        if (!((Boolean)isConnected.get()).booleanValue()) {
                            sink.error((Throwable)((Object)new PostgresConnectionClosedException("Cannot exchange messages because the connection is closed")));
                            return;
                        }
                        Flux requestMessages = Flux.from((Publisher)requests).doOnNext(arg_0 -> BackendMessageSubscriber.lambda$null$1((Supplier)isConnected, sink, arg_0));
                        sender.accept(requestMessages);
                    } else {
                        sink.error((Throwable)((Object)new RequestQueueException("Cannot exchange messages because the request queue limit is exceeded")));
                    }
                }
            });
        }

        public void onRequest(Conversation conversation, long n) {
            conversation.incrementDemand(n);
            this.demandMore();
            this.tryDrainLoop();
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            this.demandMore();
        }

        public void onNext(BackendMessage message) {
            Conversation conversation;
            if (this.terminated) {
                ReferenceCountUtil.release((Object)message);
                Operators.onNextDropped((Object)message, (Context)this.currentContext());
                return;
            }
            this.demand.decrementAndGet();
            if (this.buffer.isEmpty() && (conversation = this.conversations.peek()) != null && conversation.hasDemand()) {
                this.emit(conversation, message);
                this.potentiallyDemandMore(conversation);
                return;
            }
            if (!this.buffer.offer(message)) {
                ReferenceCountUtil.release((Object)message);
                Operators.onNextDropped((Object)message, (Context)this.currentContext());
                this.onError((Throwable)((Object)new ResponseQueueException("Response queue is full")));
                return;
            }
            this.tryDrainLoop();
        }

        public void onError(Throwable throwable) {
            if (this.terminated) {
                Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
                return;
            }
            ReactorNettyClient.this.handleConnectionError(throwable);
            ReactorNettyClient.this.requestSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            this.terminated = true;
            if (ReactorNettyClient.isSslException(throwable)) {
                logger.debug(ReactorNettyClient.this.context.getMessage("Connection Error"), throwable);
            } else {
                logger.error(ReactorNettyClient.this.context.getMessage("Connection Error"), throwable);
            }
            ReactorNettyClient.this.close().subscribe();
        }

        public void onComplete() {
            this.terminated = true;
            ReactorNettyClient.this.handleClose();
        }

        public Context currentContext() {
            Conversation receiver = this.conversations.peek();
            return receiver != null ? receiver.sink.currentContext() : Context.empty();
        }

        private void tryDrainLoop() {
            while (this.hasBufferedItems() && this.hasDownstreamDemand()) {
                if (this.drainLoop()) continue;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drainLoop() {
            if (!this.drain.compareAndSet(false, true)) {
                return false;
            }
            Conversation lastConversation = null;
            try {
                while (this.hasBufferedItems()) {
                    Conversation conversation;
                    lastConversation = conversation = this.conversations.peek();
                    if (conversation == null) {
                        break;
                    }
                    if (!conversation.hasDemand()) break;
                    BackendMessage item = this.buffer.poll();
                    if (item == null) {
                        break;
                    }
                    this.emit(conversation, item);
                }
            }
            finally {
                this.drain.compareAndSet(true, false);
            }
            this.potentiallyDemandMore(lastConversation);
            return true;
        }

        private void potentiallyDemandMore(@Nullable Conversation lastConversation) {
            if (lastConversation == null || lastConversation.hasDemand() || lastConversation.isCancelled()) {
                this.demandMore();
            }
        }

        private void emit(Conversation conversation, BackendMessage item) {
            if (conversation.canComplete(item)) {
                this.conversations.poll();
                conversation.complete(item);
            } else {
                conversation.emit(item);
            }
        }

        private void demandMore() {
            if (!this.hasBufferedItems() && this.demand.compareAndSet(0L, 256L)) {
                this.upstream.request(256L);
            }
        }

        private boolean hasDownstreamDemand() {
            Conversation conversation = this.conversations.peek();
            return conversation != null && conversation.hasDemand();
        }

        private boolean hasBufferedItems() {
            return !this.buffer.isEmpty();
        }

        public void close(Supplier<? extends Throwable> supplier) {
            Conversation receiver;
            this.terminated = true;
            while ((receiver = this.conversations.poll()) != null) {
                receiver.onError(supplier.get());
            }
            while (!this.buffer.isEmpty()) {
                ReferenceCountUtil.release((Object)this.buffer.poll());
            }
        }

        private static /* synthetic */ void lambda$null$1(Supplier isConnected, FluxSink sink, FrontendMessage m) {
            if (!((Boolean)isConnected.get()).booleanValue()) {
                sink.error((Throwable)((Object)new PostgresConnectionClosedException("Cannot exchange messages because the connection is closed")));
            }
        }
    }

    private static class Conversation {
        private static final AtomicLongFieldUpdater<Conversation> DEMAND_UPDATER = AtomicLongFieldUpdater.newUpdater(Conversation.class, "demand");
        private final Predicate<BackendMessage> takeUntil;
        private final FluxSink<BackendMessage> sink;
        private volatile long demand;

        private Conversation(Predicate<BackendMessage> takeUntil, FluxSink<BackendMessage> sink) {
            this.sink = sink;
            this.takeUntil = takeUntil;
        }

        private void decrementDemand() {
            Operators.addCap(DEMAND_UPDATER, (Object)this, (long)-1L);
        }

        public boolean canComplete(BackendMessage item) {
            return this.takeUntil.test(item);
        }

        public void complete(BackendMessage item) {
            ReferenceCountUtil.release((Object)item);
            if (!this.sink.isCancelled()) {
                this.sink.complete();
            }
        }

        public void emit(BackendMessage item) {
            if (this.sink.isCancelled()) {
                ReferenceCountUtil.release((Object)item);
            }
            this.decrementDemand();
            this.sink.next((Object)item);
        }

        public void onError(Throwable throwable) {
            if (!this.sink.isCancelled()) {
                this.sink.error(throwable);
            }
        }

        public boolean hasDemand() {
            return DEMAND_UPDATER.get(this) > 0L;
        }

        public boolean isCancelled() {
            return this.sink.isCancelled();
        }

        public void incrementDemand(long n) {
            Operators.addCap(DEMAND_UPDATER, (Object)this, (long)n);
        }
    }

    static class ResponseQueueException
    extends R2dbcNonTransientResourceException {
        public ResponseQueueException(String message) {
            super(message);
        }
    }

    static class RequestQueueException
    extends R2dbcTransientResourceException {
        public RequestQueueException(String message) {
            super(message);
        }
    }

    static class PostgresConnectionException
    extends R2dbcNonTransientResourceException {
        public PostgresConnectionException(Throwable cause) {
            super(cause);
        }
    }

    static class PostgresConnectionClosedException
    extends R2dbcNonTransientResourceException {
        public PostgresConnectionClosedException(String reason) {
            super(reason);
        }
    }

    private final class EnsureSubscribersCompleteChannelHandler
    extends ChannelDuplexHandler {
        private final Sinks.Many<?> requestSink;

        private EnsureSubscribersCompleteChannelHandler(Sinks.Many<?> requestSink) {
            this.requestSink = requestSink;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            super.channelUnregistered(ctx);
            this.requestSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            ReactorNettyClient.this.handleClose();
        }
    }
}

