/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.TokenizedSql;
import java.util.ArrayList;
import java.util.Arrays;

class PostgresqlSqlLexer {
    private static final char[] SPECIAL_AND_OPERATOR_CHARS = new char[]{'+', '-', '*', '/', '<', '>', '=', '~', '!', '@', '#', '%', '^', '&', '|', '`', '?', '(', ')', '[', ']', ',', ';', ':', '*', '.', '\'', '\"'};

    PostgresqlSqlLexer() {
    }

    public static TokenizedSql tokenize(String sql) {
        ArrayList<TokenizedSql.Token> tokens = new ArrayList<TokenizedSql.Token>();
        ArrayList<TokenizedSql.TokenizedStatement> statements = new ArrayList<TokenizedSql.TokenizedStatement>();
        int statementStartIndex = 0;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            TokenizedSql.Token token = null;
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            switch (c) {
                case '\'': {
                    token = PostgresqlSqlLexer.getStandardQuoteToken(sql, i);
                    break;
                }
                case '\"': {
                    token = PostgresqlSqlLexer.getQuotedIdentifierToken(sql, i);
                    break;
                }
                case '-': {
                    if (i + 1 >= sql.length() || sql.charAt(i + 1) != '-') break;
                    token = PostgresqlSqlLexer.getCommentToLineEndToken(sql, i);
                    break;
                }
                case '/': {
                    if (i + 1 >= sql.length() || sql.charAt(i + 1) != '*') break;
                    token = PostgresqlSqlLexer.getBlockCommentToken(sql, i);
                    break;
                }
                case '$': {
                    token = PostgresqlSqlLexer.getParameterOrDollarQuoteToken(sql, i);
                    break;
                }
                case ';': {
                    token = new TokenizedSql.Token(TokenizedSql.TokenType.STATEMENT_END, ";");
                    break;
                }
            }
            if (token == null) {
                token = PostgresqlSqlLexer.isSpecialOrOperatorChar(c) ? new TokenizedSql.Token(TokenizedSql.TokenType.SPECIAL_OR_OPERATOR, Character.toString(c)) : PostgresqlSqlLexer.getDefaultToken(sql, i);
            }
            i += token.getValue().length();
            if (token.getType() == TokenizedSql.TokenType.STATEMENT_END) {
                tokens.add(token);
                statements.add(new TokenizedSql.TokenizedStatement(sql.substring(statementStartIndex, i), tokens));
                tokens = new ArrayList();
                statementStartIndex = i + 1;
                continue;
            }
            tokens.add(token);
        }
        if (!tokens.isEmpty()) {
            statements.add(new TokenizedSql.TokenizedStatement(sql.substring(statementStartIndex), tokens));
        }
        return new TokenizedSql(sql, statements);
    }

    private static TokenizedSql.Token getDefaultToken(String sql, int beginIndex) {
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (!Character.isWhitespace(c) && !PostgresqlSqlLexer.isSpecialOrOperatorChar(c)) continue;
            return new TokenizedSql.Token(TokenizedSql.TokenType.DEFAULT, sql.substring(beginIndex, i));
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.DEFAULT, sql.substring(beginIndex));
    }

    private static boolean isSpecialOrOperatorChar(char c) {
        return Arrays.binarySearch(SPECIAL_AND_OPERATOR_CHARS, c) >= 0;
    }

    private static TokenizedSql.Token getBlockCommentToken(String sql, int beginIndex) {
        int depth = 1;
        for (int i = beginIndex + 2; i < sql.length() - 1; ++i) {
            String biGraph = sql.substring(i, i + 2);
            if (biGraph.equals("/*")) {
                ++depth;
                ++i;
            } else if (biGraph.equals("*/")) {
                --depth;
                ++i;
            }
            if (depth != 0) continue;
            return new TokenizedSql.Token(TokenizedSql.TokenType.COMMENT, sql.substring(beginIndex, i + 1));
        }
        throw new IllegalArgumentException("Sql cannot be parsed: unclosed block comment (comment opened at index " + beginIndex + ") in statement: " + sql);
    }

    private static TokenizedSql.Token getCommentToLineEndToken(String sql, int beginIndex) {
        int lineEnding = sql.indexOf(10, beginIndex);
        if (lineEnding == -1) {
            return new TokenizedSql.Token(TokenizedSql.TokenType.COMMENT, sql.substring(beginIndex));
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.COMMENT, sql.substring(beginIndex, lineEnding));
    }

    private static TokenizedSql.Token getDollarQuoteToken(String sql, String tag, int beginIndex) {
        int nextQuote = sql.indexOf(tag, beginIndex + tag.length());
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quote (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.STRING_CONSTANT, sql.substring(beginIndex, nextQuote + tag.length()));
    }

    private static TokenizedSql.Token getParameterToken(String sql, int beginIndex) {
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (Character.isWhitespace(c) || PostgresqlSqlLexer.isSpecialOrOperatorChar(c)) {
                return new TokenizedSql.Token(TokenizedSql.TokenType.PARAMETER, sql.substring(beginIndex, i));
            }
            if (PostgresqlSqlLexer.isAsciiDigit(c)) continue;
            throw new IllegalArgumentException("Sql cannot be parsed: illegal character in parameter or dollar-quote tag: " + c);
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.PARAMETER, sql.substring(beginIndex));
    }

    private static TokenizedSql.Token getParameterOrDollarQuoteToken(String sql, int beginIndex) {
        char firstChar = sql.charAt(beginIndex + 1);
        if (firstChar == '$') {
            return PostgresqlSqlLexer.getDollarQuoteToken(sql, "$$", beginIndex);
        }
        if (PostgresqlSqlLexer.isAsciiDigit(firstChar)) {
            return PostgresqlSqlLexer.getParameterToken(sql, beginIndex);
        }
        for (int i = beginIndex + 1; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '$') {
                return PostgresqlSqlLexer.getDollarQuoteToken(sql, sql.substring(beginIndex, i + 1), beginIndex);
            }
            if (PostgresqlSqlLexer.isAsciiLetter(c) || c == '_' || PostgresqlSqlLexer.isAsciiDigit(c)) continue;
            throw new IllegalArgumentException("Sql cannot be parsed: illegal character in dollar-quote tag (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        throw new IllegalArgumentException("Sql cannot be parsed: unclosed dollar-quote tag(quote opened at index " + beginIndex + ") in statement: " + sql);
    }

    private static TokenizedSql.Token getStandardQuoteToken(String sql, int beginIndex) {
        int nextQuote = sql.indexOf(39, beginIndex + 1);
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quote (quote opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.STRING_CONSTANT, sql.substring(beginIndex, nextQuote + 1));
    }

    private static TokenizedSql.Token getQuotedIdentifierToken(String sql, int beginIndex) {
        int nextQuote = sql.indexOf(34, beginIndex + 1);
        if (nextQuote == -1) {
            throw new IllegalArgumentException("Sql cannot be parsed: unclosed quoted identifier (identifier opened at index " + beginIndex + ") in statement: " + sql);
        }
        return new TokenizedSql.Token(TokenizedSql.TokenType.QUOTED_IDENTIFIER, sql.substring(beginIndex, nextQuote + 1));
    }

    private static boolean isAsciiLetter(char c) {
        char lower = Character.toLowerCase(c);
        return lower >= 'a' && lower <= 'z';
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static {
        Arrays.sort(SPECIAL_AND_OPERATOR_CHARS);
    }
}

