/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.UUID;
import java.util.function.Supplier;

final class UuidArrayCodec
extends AbstractArrayCodec<UUID> {
    UuidArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, UUID.class, PostgresqlObjectId.UUID_ARRAY);
    }

    @Override
    UUID doDecodeBinary(ByteBuf byteBuffer) {
        return new UUID(byteBuffer.readLong(), byteBuffer.readLong());
    }

    @Override
    UUID doDecodeText(String text) {
        return UUID.fromString(text);
    }

    @Override
    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return UuidArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }

    @Override
    String doEncodeText(UUID value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

