/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.OffsetTime;

public class OffsetTimeCodec
extends AbstractTemporalCodec<OffsetTime> {
    private final ByteBufAllocator byteBufAllocator;

    OffsetTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(OffsetTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    OffsetTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends OffsetTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, OffsetTime.class, OffsetTime::from);
    }

    @Override
    EncodedParameter doEncode(OffsetTime value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return OffsetTimeCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.TIMETZ;
    }
}

