/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class LongArrayCodec
extends AbstractArrayCodec<Long> {
    LongArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Long.class, PostgresqlObjectId.INT8_ARRAY);
    }

    @Override
    Long doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readLong();
    }

    @Override
    Long doDecodeText(String text) {
        return Long.parseLong(text);
    }

    @Override
    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return LongArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }

    @Override
    String doEncodeText(Long value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

