/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Line;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;

final class LineCodec
extends AbstractGeometryCodec<Line> {
    LineCodec(ByteBufAllocator byteBufAllocator) {
        super(Line.class, PostgresqlObjectId.LINE, byteBufAllocator);
    }

    @Override
    Line doDecodeBinary(ByteBuf byteBuffer) {
        return Line.of(byteBuffer.readDouble(), byteBuffer.readDouble(), byteBuffer.readDouble());
    }

    @Override
    Line doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        return Line.of(stream.nextDouble(), stream.nextDouble(), stream.nextDouble());
    }

    @Override
    ByteBuf doEncodeBinary(Line value) {
        return this.byteBufAllocator.buffer(24).writeDouble(value.getA()).writeDouble(value.getB()).writeDouble(value.getC());
    }
}

