/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractJsonCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;

final class JsonByteBufCodec
extends AbstractJsonCodec<ByteBuf> {
    private final ByteBufAllocator byteBufAllocator;

    JsonByteBufCodec(ByteBufAllocator byteBufAllocator) {
        super(ByteBuf.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    ByteBuf doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends ByteBuf> type) {
        return buffer.readRetainedSlice(buffer.readableBytes()).touch((Object)"Decoded by JsonByteBufCodec");
    }

    @Override
    EncodedParameter doEncode(ByteBuf value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.JSONB);
    }

    @Override
    EncodedParameter doEncode(ByteBuf value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return JsonByteBufCodec.create(Format.FORMAT_BINARY, dataType, () -> {
            try {
                ByteBuf byteBuf = this.byteBufAllocator.buffer(value.readByte() + 1).writeByte(1).writeBytes(value);
                return byteBuf;
            }
            finally {
                ReferenceCountUtil.release((Object)value);
            }
        });
    }
}

