/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.Interval;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;

final class IntervalCodec
extends AbstractCodec<Interval> {
    private final ByteBufAllocator byteBufAllocator;

    IntervalCodec(ByteBufAllocator byteBufAllocator) {
        super(Interval.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return PostgresqlObjectId.INTERVAL == type && Format.FORMAT_TEXT == format;
    }

    @Override
    Interval doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends Interval> type) {
        return Interval.parse(ByteBufUtils.decode(buffer));
    }

    @Override
    EncodedParameter doEncode(Interval value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.INTERVAL);
    }

    @Override
    EncodedParameter doEncode(Interval value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return IntervalCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.getValue()));
    }

    @Override
    public EncodedParameter encodeNull() {
        return IntervalCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.INTERVAL);
    }
}

