/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class IntegerArrayCodec
extends AbstractArrayCodec<Integer> {
    IntegerArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Integer.class, PostgresqlObjectId.INT4_ARRAY);
    }

    @Override
    Integer doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readInt();
    }

    @Override
    Integer doDecodeText(String text) {
        return Integer.parseInt(text);
    }

    @Override
    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return IntegerArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }

    @Override
    String doEncodeText(Integer value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

