/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class CharacterCodec
extends AbstractCodec<Character> {
    private final StringCodec delegate;

    CharacterCodec(ByteBufAllocator byteBufAllocator) {
        super(Character.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new StringCodec(byteBufAllocator);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    Character doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Character> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return Character.valueOf(((String)this.delegate.doDecode(buffer, dataType, format, String.class)).charAt(0));
    }

    @Override
    EncodedParameter doEncode(Character value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.toString());
    }

    @Override
    EncodedParameter doEncode(Character value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.toString(), dataType);
    }
}

