/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class BooleanCodec
extends AbstractCodec<Boolean> {
    private final ByteBufAllocator byteBufAllocator;

    BooleanCodec(ByteBufAllocator byteBufAllocator) {
        super(Boolean.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return BooleanCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.BOOL);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BOOL == type;
    }

    @Override
    Boolean doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Boolean> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        if (format == Format.FORMAT_BINARY) {
            return buffer.readBoolean();
        }
        String decoded = ByteBufUtils.decode(buffer);
        return "1".equals(decoded) || "true".equalsIgnoreCase(decoded) || "t".equalsIgnoreCase(decoded) || "yes".equalsIgnoreCase(decoded) || "y".equalsIgnoreCase(decoded) || "on".equalsIgnoreCase(decoded);
    }

    @Override
    EncodedParameter doEncode(Boolean value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.BOOL);
    }

    @Override
    EncodedParameter doEncode(Boolean value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return BooleanCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value != false ? "TRUE" : "FALSE"));
    }
}

