/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class AbstractArrayCodec<T>
extends AbstractCodec<Object[]> {
    private static final byte[] CLOSE_CURLY = "}".getBytes();
    private static final byte[] COMMA = ",".getBytes();
    private static final String NULL = "NULL";
    private static final byte[] OPEN_CURLY = "{".getBytes();
    private final ByteBufAllocator byteBufAllocator;
    private final Class<T> componentType;
    private final PostgresqlObjectId oid;

    AbstractArrayCodec(ByteBufAllocator byteBufAllocator, Class<T> componentType, PostgresqlObjectId oid) {
        super(Object[].class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.componentType = Assert.requireNonNull(componentType, "componentType must not be null");
        this.oid = Assert.requireNonNull(oid, "oid must not be null");
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.isTypeAssignable(value.getClass());
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.isTypeAssignable(type);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.encodeNull(this.oid.getObjectId());
    }

    static String escapeArrayElement(String s) {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    @Override
    final Object[] doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends Object[]> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (Format.FORMAT_BINARY == format) {
            return this.decodeBinary(buffer, type);
        }
        return this.decodeText(buffer, type);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return this.oid == type;
    }

    abstract T doDecodeBinary(ByteBuf var1);

    abstract T doDecodeText(String var1);

    @Override
    final EncodedParameter doEncode(Object[] value) {
        return this.doEncode(value, (PostgresTypeIdentifier)this.oid);
    }

    @Override
    EncodedParameter doEncode(Object[] value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.encodeArray(() -> {
            ByteBuf byteBuf = this.byteBufAllocator.buffer();
            this.encodeAsText(byteBuf, value, this::doEncodeText);
            return byteBuf;
        }, dataType);
    }

    abstract EncodedParameter encodeArray(Supplier<ByteBuf> var1, PostgresTypeIdentifier var2);

    abstract String doEncodeText(T var1);

    @Override
    boolean isTypeAssignable(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.componentType.equals(AbstractArrayCodec.getBaseComponentType(type));
    }

    private static Class<?> getBaseComponentType(Class<?> type) {
        Class<?> t = type;
        while (t.getComponentType() != null) {
            t = t.getComponentType();
        }
        return t;
    }

    private static int getDimensions(List<?> list) {
        int dims = 1;
        Object inner = list.get(0);
        while (inner instanceof List) {
            inner = ((List)inner).get(0);
            ++dims;
        }
        return dims;
    }

    private static Object[] toArray(List<?> list, Class<?> returnType) {
        ArrayList result = new ArrayList(list.size());
        for (Object e : list) {
            Object o = e instanceof List ? AbstractArrayCodec.toArray((List)e, returnType.getComponentType()) : e;
            result.add(o);
        }
        return result.toArray((Object[])Array.newInstance(returnType, list.size()));
    }

    private List<Object> buildArrayList(ByteBuf buf) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        char delim = ',';
        StringBuilder buffer = null;
        boolean insideString = false;
        boolean wasInsideString = false;
        ArrayList dims = new ArrayList();
        List<Object> curArray = arrayList;
        CharSequence chars = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8);
        int startOffset = 0;
        if (chars.charAt(0) == '[') {
            while (chars.charAt(startOffset) != '=') {
                ++startOffset;
            }
            ++startOffset;
        }
        for (int i = startOffset; i < chars.length(); ++i) {
            char currentChar = chars.charAt(i);
            if (currentChar == '\\') {
                currentChar = chars.charAt(++i);
            } else {
                if (!insideString && currentChar == '{') {
                    if (dims.isEmpty()) {
                        dims.add(arrayList);
                    } else {
                        ArrayList a = new ArrayList();
                        List p = (List)dims.get(dims.size() - 1);
                        p.add(a);
                        dims.add(a);
                    }
                    curArray = (List)dims.get(dims.size() - 1);
                    for (int t = i + 1; t < chars.length() && (Character.isWhitespace(chars.charAt(t)) || chars.charAt(t) == '{'); ++t) {
                    }
                    buffer = new StringBuilder();
                    continue;
                }
                if (currentChar == '\"') {
                    insideString = !insideString;
                    wasInsideString = true;
                    continue;
                }
                if (!insideString && Character.isWhitespace(currentChar)) continue;
                if (!insideString && (currentChar == delim || currentChar == '}') || i == chars.length() - 1) {
                    String b;
                    if (currentChar != '\"' && currentChar != '}' && currentChar != delim && buffer != null) {
                        buffer.append(currentChar);
                    }
                    String string = b = buffer == null ? null : buffer.toString();
                    if (b != null && (!b.isEmpty() || wasInsideString)) {
                        curArray.add(!wasInsideString && b.equals(NULL) ? null : this.doDecodeText(b));
                    }
                    wasInsideString = false;
                    buffer = new StringBuilder();
                    if (currentChar != '}') continue;
                    dims.remove(dims.size() - 1);
                    if (!dims.isEmpty()) {
                        curArray = (List)dims.get(dims.size() - 1);
                    }
                    buffer = null;
                    continue;
                }
            }
            if (buffer == null) continue;
            buffer.append(currentChar);
        }
        return arrayList;
    }

    private Class<?> createArrayType(int dims) {
        int[] size = new int[dims];
        Arrays.fill(size, 1);
        return Array.newInstance(this.componentType, size).getClass();
    }

    private Object[] decodeBinary(ByteBuf buffer, Class<?> returnType) {
        if (!buffer.isReadable()) {
            return new Object[0];
        }
        int dimensions = buffer.readInt();
        if (dimensions == 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        buffer.skipBytes(4);
        buffer.skipBytes(4);
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = buffer.readInt();
            buffer.skipBytes(4);
        }
        Object[] array = (Object[])Array.newInstance(this.componentType, dims);
        this.readArrayAsBinary(buffer, array, dims, 0);
        return array;
    }

    private Object[] decodeText(ByteBuf buffer, Class<?> returnType) {
        List<Object> elements = this.buildArrayList(buffer);
        if (elements.isEmpty()) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int dimensions = AbstractArrayCodec.getDimensions(elements);
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        return AbstractArrayCodec.toArray(elements, this.createArrayType(dimensions).getComponentType());
    }

    private void encodeAsText(ByteBuf byteBuf, Object[] value, Function<T, String> encoder) {
        byteBuf.writeBytes(OPEN_CURLY);
        for (int i = 0; i < value.length; ++i) {
            Object item = value[i];
            if (item instanceof Object[]) {
                this.encodeAsText(byteBuf, (Object[])item, encoder);
            } else {
                byteBuf.writeCharSequence(item == null ? NULL : (CharSequence)encoder.apply(item), StandardCharsets.UTF_8);
            }
            if (i == value.length - 1) continue;
            byteBuf.writeBytes(COMMA);
        }
        byteBuf.writeBytes(CLOSE_CURLY);
    }

    private void readArrayAsBinary(ByteBuf buffer, Object[] array, int[] dims, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = buffer.readInt();
                if (len == -1) continue;
                array[i] = this.doDecodeBinary(buffer.readSlice(len));
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                this.readArrayAsBinary(buffer, (Object[])array[i], dims, thisDimension + 1);
            }
        }
    }
}

