/*
 * Decompiled with CFR 0.152.
 */
package org.pojomatic.test;

import org.pojomatic.NoPojomaticPropertiesException;
import org.pojomatic.Pojomatic;

public class AssertUtils {
    public static boolean equal(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (!AssertUtils.equal(expected, actual)) {
            if (expected == null) {
                throw new AssertionError(AssertUtils.makeBuilder(message).append("expected is null, but actual is ").append(actual));
            }
            if (actual == null) {
                throw new AssertionError(AssertUtils.makeBuilder(message).append("actual is null, but expected is ").append(expected));
            }
            try {
                if (Pojomatic.areCompatibleForEquals(expected.getClass(), actual.getClass())) {
                    throw new AssertionError((Object)AssertUtils.appendStandardEqualityMessage(AssertUtils.makeBuilder(message).append("differences between expected and actual:").append(Pojomatic.diff((Object)expected, (Object)actual)).append(" ("), expected, actual).append(")").toString());
                }
            }
            catch (NoPojomaticPropertiesException noPojomaticPropertiesException) {
                // empty catch block
            }
            throw new AssertionError((Object)AssertUtils.appendStandardEqualityMessage(AssertUtils.makeBuilder(message), expected, actual).toString());
        }
    }

    private static StringBuilder appendStandardEqualityMessage(StringBuilder builder, Object expected, Object actual) {
        return builder.append("expected:<").append(expected).append("> but was:<").append(actual).append(">");
    }

    private static StringBuilder makeBuilder(String message) {
        return message == null ? new StringBuilder() : new StringBuilder(message).append(" ");
    }

    private AssertUtils() {
    }
}

