/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import jakarta.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import play.inject.Injector;
import play.libs.typedmap.TypedKey;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import play.twirl.api.Content;
import views.html.defaultpages.unauthorized;

public class Security {
    public static final TypedKey<String> USERNAME = TypedKey.create("username");

    public static class Authenticator
    extends Results {
        public Optional<String> getUsername(Http.Request request) {
            return request.session().get("username");
        }

        public Result onUnauthorized(Http.Request request) {
            return Authenticator.unauthorized((Content)unauthorized.render(request.asScala()));
        }
    }

    public static class AuthenticatedAction
    extends Action<Authenticated> {
        private final Function<Authenticated, Authenticator> configurator;

        @Inject
        public AuthenticatedAction(Injector injector) {
            this((Authenticated authenticated) -> injector.instanceOf(authenticated.value()));
        }

        public AuthenticatedAction(Authenticator authenticator) {
            this((Authenticated authenticated) -> authenticator);
        }

        public AuthenticatedAction(Function<Authenticated, Authenticator> function) {
            this.configurator = function;
        }

        @Override
        public CompletionStage<Result> call(Http.Request request) {
            Authenticator authenticator = this.configurator.apply((Authenticated)this.configuration);
            return authenticator.getUsername(request).map(string -> this.delegate.call((Http.Request)request.addAttr((TypedKey)USERNAME, string))).orElseGet(() -> CompletableFuture.completedFuture(authenticator.onUnauthorized(request)));
        }
    }

    @With(value={AuthenticatedAction.class})
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Authenticated {
        public Class<? extends Authenticator> value() default Authenticator.class;
    }
}

