/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.Serializable;
import play.api.ApplicationLoader;
import play.api.OptionalDevContext;
import play.api.http.HttpConfiguration;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpFilters;
import play.api.http.HttpRequestHandler;
import play.api.http.HttpVerbs$;
import play.api.http.Status$;
import play.api.mvc.Action;
import play.api.mvc.ActionBuilder$;
import play.api.mvc.BodyParsers$utils$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialFilter;
import play.api.mvc.Handler;
import play.api.mvc.Handler$;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.WebSocket;
import play.api.routing.Router;
import play.core.WebCommands;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;

public class DefaultHttpRequestHandler
implements HttpRequestHandler {
    private final WebCommands webCommands;
    private final Option<ApplicationLoader.DevContext> optDevContext;
    private final Provider<Router> router;
    private final HttpErrorHandler errorHandler;
    private final Seq<EssentialFilter> filters;
    private final String context;

    public DefaultHttpRequestHandler(WebCommands webCommands, Option<ApplicationLoader.DevContext> optDevContext, Provider<Router> router, HttpErrorHandler errorHandler, HttpConfiguration configuration, Seq<EssentialFilter> filters) {
        this.webCommands = webCommands;
        this.optDevContext = optDevContext;
        this.router = router;
        this.errorHandler = errorHandler;
        this.filters = filters;
        this.context = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(configuration.context()), "/");
    }

    @Inject
    public DefaultHttpRequestHandler(WebCommands webCommands, OptionalDevContext optDevContext, Provider<Router> router, HttpErrorHandler errorHandler, HttpConfiguration configuration, HttpFilters filters) {
        this(webCommands, optDevContext.devContext(), router, errorHandler, configuration, filters.filters());
    }

    public DefaultHttpRequestHandler(WebCommands webCommands, Option<ApplicationLoader.DevContext> optDevContext, Router router, HttpErrorHandler errorHandler, HttpConfiguration configuration, Seq<EssentialFilter> filters) {
        this(webCommands, optDevContext, DefaultHttpRequestHandler.DefaultHttpRequestHandler$superArg$1(webCommands, optDevContext, router, errorHandler, configuration, filters), errorHandler, configuration, filters);
    }

    public DefaultHttpRequestHandler(WebCommands webCommands, OptionalDevContext optDevContext, Router router, HttpErrorHandler errorHandler, HttpConfiguration configuration, HttpFilters filters) {
        this(webCommands, optDevContext.devContext(), DefaultHttpRequestHandler.DefaultHttpRequestHandler$superArg$2(webCommands, optDevContext, router, errorHandler, configuration, filters), errorHandler, configuration, filters.filters());
    }

    private boolean inContext(String path) {
        return this.context.isEmpty() || path.startsWith(this.context) && (path.length() == this.context.length() || path.charAt(this.context.length()) == '/');
    }

    @Override
    public Tuple2<RequestHeader, Handler> handlerForRequest(RequestHeader request) {
        Option webCommandResult = this.optDevContext.flatMap((Function1 & Serializable)devContext -> this.webCommands.handleWebCommand(request, devContext.buildLink(), devContext.buildLink().projectPath()));
        Option option = webCommandResult;
        if (option instanceof Some) {
            Result r = (Result)((Some)option).value();
            return Tuple2$.MODULE$.apply((Object)request, ActionBuilder$.MODULE$.ignoringBody().apply((Function0<Result>)((Function0 & Serializable)() -> DefaultHttpRequestHandler.handlerForRequest$$anonfun$2(r))));
        }
        if (None$.MODULE$.equals(option)) {
            Handler routedHandler = this.routeWithFallback$1(request);
            Tuple2<RequestHeader, Handler> tuple2 = Handler$.MODULE$.applyStages(request, routedHandler);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RequestHeader preprocessedRequest = (RequestHeader)tuple2._1();
            Handler preprocessedHandler = (Handler)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)preprocessedRequest, (Object)preprocessedHandler);
            RequestHeader preprocessedRequest2 = (RequestHeader)tuple22._1();
            Handler preprocessedHandler2 = (Handler)tuple22._2();
            Handler filteredHandler = this.filterHandler(preprocessedRequest2, preprocessedHandler2);
            Tuple2<RequestHeader, Handler> tuple23 = Handler$.MODULE$.applyStages(preprocessedRequest2, filteredHandler);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            RequestHeader preprocessedPreprocessedRequest = (RequestHeader)tuple23._1();
            Handler preprocessedFilteredHandler = (Handler)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)preprocessedPreprocessedRequest, (Object)preprocessedFilteredHandler);
            RequestHeader preprocessedPreprocessedRequest2 = (RequestHeader)tuple24._1();
            Handler preprocessedFilteredHandler2 = (Handler)tuple24._2();
            return Tuple2$.MODULE$.apply((Object)preprocessedPreprocessedRequest2, (Object)preprocessedFilteredHandler2);
        }
        throw new MatchError((Object)option);
    }

    public Handler filterHandler(RequestHeader request, Handler handler) {
        Handler handler2 = handler;
        if (handler2 instanceof EssentialAction) {
            EssentialAction action = (EssentialAction)handler2;
            if (this.inContext(request.path())) {
                return this.filterAction(action);
            }
        }
        Handler handler3 = handler2;
        return handler3;
    }

    public EssentialAction filterAction(EssentialAction next) {
        return (EssentialAction)this.filters.foldRight((Object)next, (Function2 & Serializable)(_$2, _$3) -> _$2.apply((EssentialAction)_$3));
    }

    public Option<Handler> routeRequest(RequestHeader request) {
        return ((Router)this.router.get()).handlerFor(request);
    }

    private static Provider<Router> DefaultHttpRequestHandler$superArg$1(WebCommands webCommands, Option<ApplicationLoader.DevContext> optDevContext, Router router, HttpErrorHandler errorHandler, HttpConfiguration configuration, Seq<EssentialFilter> filters) {
        return () -> router;
    }

    private static Provider<Router> DefaultHttpRequestHandler$superArg$2(WebCommands webCommands, OptionalDevContext optDevContext, Router router, HttpErrorHandler errorHandler, HttpConfiguration configuration, HttpFilters filters) {
        return () -> router;
    }

    private final Action handleWithStatus$1(int status) {
        return ActionBuilder$.MODULE$.ignoringBody().async(BodyParsers$utils$.MODULE$.empty(), (Function1<Request, Future<Result>>)(Function1 & Serializable)req -> this.errorHandler.onClientError((RequestHeader)req, status, this.errorHandler.onClientError$default$3()));
    }

    private final Handler routeWithFallback$1$$anonfun$1(RequestHeader request$1) {
        String string = request$1.method();
        String string2 = HttpVerbs$.MODULE$.HEAD();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Handler handler;
            Option<Handler> option = this.routeRequest(request$1.withMethod(HttpVerbs$.MODULE$.GET()));
            if (option instanceof Some && (handler = (Handler)((Some)option).value()) != null) {
                Handler handler2 = handler;
                Handler handler3 = handler2;
                if (handler3 instanceof WebSocket) {
                    WebSocket ws = (WebSocket)handler3;
                    return this.handleWithStatus$1(Status$.MODULE$.BAD_REQUEST());
                }
                return handler2;
            }
            if (None$.MODULE$.equals(option)) {
                return this.handleWithStatus$1(Status$.MODULE$.NOT_FOUND());
            }
            throw new MatchError(option);
        }
        return this.handleWithStatus$1(Status$.MODULE$.NOT_FOUND());
    }

    private final Handler routeWithFallback$1(RequestHeader request) {
        return (Handler)this.routeRequest(request).getOrElse(() -> this.routeWithFallback$1$$anonfun$1(request));
    }

    private static final Result handlerForRequest$$anonfun$2(Result r$1) {
        return r$1;
    }
}

