/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import play.api.libs.Files;
import play.api.libs.Files$SingletonTemporaryFileCreator$;
import scala.util.Try;

public final class Files {
    private static final TemporaryFileCreator instance = new SingletonTemporaryFileCreator();

    public static TemporaryFileCreator singletonTemporaryFileCreator() {
        return instance;
    }

    public static interface TemporaryFileCreator {
        public TemporaryFile create(String var1, String var2);

        public TemporaryFile create(Path var1);

        public boolean delete(TemporaryFile var1);

        public Files.TemporaryFileCreator asScala();
    }

    public static class SingletonTemporaryFileCreator
    implements TemporaryFileCreator {
        private Files.TemporaryFileCreator instance = Files$SingletonTemporaryFileCreator$.MODULE$;

        @Override
        public TemporaryFile create(String string, String string2) {
            return new DelegateTemporaryFile(this.instance.create(string, string2));
        }

        @Override
        public TemporaryFile create(Path path) {
            return new DelegateTemporaryFile(this.instance.create(path));
        }

        @Override
        public boolean delete(TemporaryFile temporaryFile) {
            Files.TemporaryFile temporaryFile2 = this.asScala().create(temporaryFile.path());
            Try<Object> try_ = this.asScala().delete(temporaryFile2);
            return (Boolean)try_.get();
        }

        @Override
        public Files.TemporaryFileCreator asScala() {
            return this.instance;
        }
    }

    public static class DelegateTemporaryFile
    implements TemporaryFile {
        private final Files.TemporaryFile temporaryFile;
        private final TemporaryFileCreator temporaryFileCreator;

        public DelegateTemporaryFile(Files.TemporaryFile temporaryFile) {
            this.temporaryFile = temporaryFile;
            this.temporaryFileCreator = new DelegateTemporaryFileCreator(temporaryFile.temporaryFileCreator());
        }

        private DelegateTemporaryFile(Files.TemporaryFile temporaryFile, TemporaryFileCreator temporaryFileCreator) {
            this.temporaryFile = temporaryFile;
            this.temporaryFileCreator = temporaryFileCreator;
        }

        @Override
        public Path path() {
            return this.temporaryFile.path();
        }

        @Override
        public TemporaryFileCreator temporaryFileCreator() {
            return this.temporaryFileCreator;
        }

        @Override
        @Deprecated
        public Path moveFileTo(File file, boolean bl) {
            return this.moveTo(file, bl);
        }

        @Override
        public Path moveTo(File file, boolean bl) {
            return this.temporaryFile.moveTo(file, bl);
        }

        @Override
        public Path copyTo(Path path, boolean bl) {
            return this.temporaryFile.copyTo(path, bl);
        }

        @Override
        @Deprecated
        public Path atomicMoveFileWithFallback(File file) {
            return this.atomicMoveWithFallback(file);
        }

        @Override
        public Path atomicMoveWithFallback(File file) {
            return this.temporaryFile.atomicMoveWithFallback(file.toPath());
        }
    }

    public static class DelegateTemporaryFileCreator
    implements TemporaryFileCreator {
        private final Files.TemporaryFileCreator temporaryFileCreator;

        @Inject
        public DelegateTemporaryFileCreator(Files.TemporaryFileCreator temporaryFileCreator) {
            this.temporaryFileCreator = temporaryFileCreator;
        }

        @Override
        public TemporaryFile create(String string, String string2) {
            return new DelegateTemporaryFile(this.temporaryFileCreator.create(string, string2));
        }

        @Override
        public TemporaryFile create(Path path) {
            return new DelegateTemporaryFile(this.temporaryFileCreator.create(path));
        }

        @Override
        public boolean delete(TemporaryFile temporaryFile) {
            Files.TemporaryFile temporaryFile2 = this.asScala().create(temporaryFile.path());
            Try<Object> try_ = this.asScala().delete(temporaryFile2);
            return (Boolean)try_.get();
        }

        @Override
        public Files.TemporaryFileCreator asScala() {
            return this.temporaryFileCreator;
        }
    }

    public static interface TemporaryFile {
        public Path path();

        public TemporaryFileCreator temporaryFileCreator();

        default public Path copyTo(File file) {
            return this.copyTo(file, false);
        }

        default public Path copyTo(File file, boolean bl) {
            return this.copyTo(file.toPath(), bl);
        }

        default public Path copyTo(Path path) {
            return this.copyTo(path, false);
        }

        public Path copyTo(Path var1, boolean var2);

        @Deprecated
        default public Path moveFileTo(File file) {
            return this.moveFileTo(file, false);
        }

        @Deprecated
        public Path moveFileTo(File var1, boolean var2);

        @Deprecated
        default public Path moveFileTo(Path path) {
            return this.moveFileTo(path, false);
        }

        @Deprecated
        default public Path moveFileTo(Path path, boolean bl) {
            return this.moveFileTo(path.toFile(), bl);
        }

        default public Path moveTo(File file) {
            return this.moveTo(file, false);
        }

        public Path moveTo(File var1, boolean var2);

        default public Path moveTo(Path path) {
            return this.moveTo(path, false);
        }

        default public Path moveTo(Path path, boolean bl) {
            return this.moveTo(path.toFile(), bl);
        }

        @Deprecated
        public Path atomicMoveFileWithFallback(File var1);

        @Deprecated
        default public Path atomicMoveFileWithFallback(Path path) {
            return this.atomicMoveFileWithFallback(path.toFile());
        }

        public Path atomicMoveWithFallback(File var1);

        default public Path atomicMoveWithFallback(Path path) {
            return this.atomicMoveWithFallback(path.toFile());
        }
    }
}

