/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import com.typesafe.config.ConfigMemorySize;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.http.ActionCompositionConfiguration;
import play.api.http.ActionCompositionConfiguration$;
import play.api.http.CookiesConfiguration;
import play.api.http.CookiesConfiguration$;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.FileMimeTypesConfiguration$;
import play.api.http.FlashConfiguration;
import play.api.http.FlashConfiguration$;
import play.api.http.HttpConfiguration;
import play.api.http.JWTConfiguration;
import play.api.http.JWTConfigurationParser$;
import play.api.http.ParserConfiguration;
import play.api.http.ParserConfiguration$;
import play.api.http.SecretConfiguration;
import play.api.http.SecretConfiguration$;
import play.api.http.SessionConfiguration;
import play.api.http.SessionConfiguration$;
import play.api.libs.Codecs$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$SameSite$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class HttpConfiguration$
implements Mirror.Product,
Serializable {
    private static final Logger logger;
    public static final HttpConfiguration$ MODULE$;

    private HttpConfiguration$() {
    }

    static {
        MODULE$ = new HttpConfiguration$();
        logger = LoggerFactory.getLogger(HttpConfiguration.class);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpConfiguration$.class);
    }

    public HttpConfiguration apply(String context, ParserConfiguration parser, ActionCompositionConfiguration actionComposition, CookiesConfiguration cookies, SessionConfiguration session, FlashConfiguration flash, FileMimeTypesConfiguration fileMimeTypes, SecretConfiguration secret) {
        return new HttpConfiguration(context, parser, actionComposition, cookies, session, flash, fileMimeTypes, secret);
    }

    public HttpConfiguration unapply(HttpConfiguration x$1) {
        return x$1;
    }

    public String $lessinit$greater$default$1() {
        return "/";
    }

    public ParserConfiguration $lessinit$greater$default$2() {
        return ParserConfiguration$.MODULE$.apply(ParserConfiguration$.MODULE$.$lessinit$greater$default$1(), ParserConfiguration$.MODULE$.$lessinit$greater$default$2(), ParserConfiguration$.MODULE$.$lessinit$greater$default$3());
    }

    public ActionCompositionConfiguration $lessinit$greater$default$3() {
        return ActionCompositionConfiguration$.MODULE$.apply(ActionCompositionConfiguration$.MODULE$.$lessinit$greater$default$1(), ActionCompositionConfiguration$.MODULE$.$lessinit$greater$default$2(), ActionCompositionConfiguration$.MODULE$.$lessinit$greater$default$3());
    }

    public CookiesConfiguration $lessinit$greater$default$4() {
        return CookiesConfiguration$.MODULE$.apply(CookiesConfiguration$.MODULE$.$lessinit$greater$default$1());
    }

    public SessionConfiguration $lessinit$greater$default$5() {
        return SessionConfiguration$.MODULE$.apply(SessionConfiguration$.MODULE$.$lessinit$greater$default$1(), SessionConfiguration$.MODULE$.$lessinit$greater$default$2(), SessionConfiguration$.MODULE$.$lessinit$greater$default$3(), SessionConfiguration$.MODULE$.$lessinit$greater$default$4(), SessionConfiguration$.MODULE$.$lessinit$greater$default$5(), SessionConfiguration$.MODULE$.$lessinit$greater$default$6(), SessionConfiguration$.MODULE$.$lessinit$greater$default$7(), SessionConfiguration$.MODULE$.$lessinit$greater$default$8(), SessionConfiguration$.MODULE$.$lessinit$greater$default$9());
    }

    public FlashConfiguration $lessinit$greater$default$6() {
        return FlashConfiguration$.MODULE$.apply(FlashConfiguration$.MODULE$.$lessinit$greater$default$1(), FlashConfiguration$.MODULE$.$lessinit$greater$default$2(), FlashConfiguration$.MODULE$.$lessinit$greater$default$3(), FlashConfiguration$.MODULE$.$lessinit$greater$default$4(), FlashConfiguration$.MODULE$.$lessinit$greater$default$5(), FlashConfiguration$.MODULE$.$lessinit$greater$default$6(), FlashConfiguration$.MODULE$.$lessinit$greater$default$7(), FlashConfiguration$.MODULE$.$lessinit$greater$default$8());
    }

    public FileMimeTypesConfiguration $lessinit$greater$default$7() {
        return FileMimeTypesConfiguration$.MODULE$.apply(FileMimeTypesConfiguration$.MODULE$.$lessinit$greater$default$1());
    }

    public SecretConfiguration $lessinit$greater$default$8() {
        return SecretConfiguration$.MODULE$.apply(SecretConfiguration$.MODULE$.$lessinit$greater$default$1(), SecretConfiguration$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<Cookie.SameSite> parseSameSite(Configuration config, String key) {
        return ((Option)config.get(key, ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).flatMap((Function1 & Serializable)value -> {
            Option<Cookie.SameSite> result = Cookie$SameSite$.MODULE$.parse((String)value);
            if (result.isEmpty()) {
                String values = Cookie$SameSite$.MODULE$.values().mkString(", ");
                logger.warn("Assuming " + key + " = null, since \"" + value + "\" is not a valid SameSite value (" + values + ")");
            }
            return result;
        });
    }

    public Map<String, String> parseFileMimeTypes(Configuration config) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString((String)config.get("play.http.fileMimeTypes", ConfigLoader$.MODULE$.stringLoader())), '\n'));
        return ArrayOps$.MODULE$.iterator$extension(object).flatMap((Function1 & Serializable)l -> {
            Tuple2 tuple2;
            String line = l.trim();
            Tuple2 tuple22 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line), 1);
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                if ("".equals(string) && "".equals(tuple22._2())) {
                    return Option$.MODULE$.empty();
                }
                if ("#".equals(string)) {
                    return Option$.MODULE$.empty();
                }
            }
            if ((tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)_$1 -> HttpConfiguration$.parseFileMimeTypes$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)))) != null) {
                String key = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(v), 1)));
            }
            return Option$.MODULE$.empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public HttpConfiguration fromConfiguration(Configuration config, Environment environment) {
        String context = this.getPath$1(config, "play.http.context", (Option)Some$.MODULE$.apply((Object)"application.context"));
        String sessionPath = this.getPath$1(config, "play.http.session.path", this.getPath$default$2$1());
        String flashPath = this.getPath$1(config, "play.http.flash.path", this.getPath$default$2$1());
        if (config.has("mimetype")) {
            throw config.globalError("mimetype replaced by play.http.fileMimeTypes map", config.globalError$default$2());
        }
        SecretConfiguration secretConfiguration = this.getSecretConfiguration(config, environment);
        String string = (String)config.getDeprecated("play.http.session.cookieName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean bl = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.secure", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.secure"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option option = (Option)config.getDeprecated("play.http.session.maxAge", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.maxAge"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()));
        boolean bl2 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.httpOnly", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.httpOnly"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option option2 = (Option)config.getDeprecated("play.http.session.domain", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.domain"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> option3 = this.parseSameSite(config, "play.http.session.sameSite");
        boolean bl3 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.partitioned", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.partitioned"}), ConfigLoader$.MODULE$.booleanLoader()));
        JWTConfiguration jWTConfiguration = JWTConfigurationParser$.MODULE$.apply(config, secretConfiguration, "play.http.session.jwt");
        String string2 = (String)config.getDeprecated("play.http.flash.cookieName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"flash.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean bl4 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.secure", ConfigLoader$.MODULE$.booleanLoader()));
        boolean bl5 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.httpOnly", ConfigLoader$.MODULE$.booleanLoader()));
        Option option4 = (Option)config.get("play.http.flash.domain", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> option5 = this.parseSameSite(config, "play.http.flash.sameSite");
        boolean bl6 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.partitioned", ConfigLoader$.MODULE$.booleanLoader()));
        JWTConfiguration jWTConfiguration2 = JWTConfigurationParser$.MODULE$.apply(config, secretConfiguration, "play.http.flash.jwt");
        return this.apply(context, ParserConfiguration$.MODULE$.apply(((ConfigMemorySize)config.getDeprecated("play.http.parser.maxMemoryBuffer", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parsers.text.maxLength"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes(), ((ConfigMemorySize)config.get("play.http.parser.maxDiskBuffer", ConfigLoader$.MODULE$.bytesLoader())).toBytes(), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.parser.allowEmptyFiles", ConfigLoader$.MODULE$.booleanLoader()))), ActionCompositionConfiguration$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.controllerAnnotationsFirst", ConfigLoader$.MODULE$.booleanLoader())), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.executeActionCreatorActionFirst", ConfigLoader$.MODULE$.booleanLoader())), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.includeWebSocketActions", ConfigLoader$.MODULE$.booleanLoader()))), CookiesConfiguration$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.cookies.strict", ConfigLoader$.MODULE$.booleanLoader()))), SessionConfiguration$.MODULE$.apply(string, bl, (Option<FiniteDuration>)option, bl2, (Option<String>)option2, sessionPath, option3, bl3, jWTConfiguration), FlashConfiguration$.MODULE$.apply(string2, bl4, bl5, (Option<String>)option4, flashPath, option5, bl6, jWTConfiguration2), FileMimeTypesConfiguration$.MODULE$.apply(this.parseFileMimeTypes(config)), secretConfiguration);
    }

    private SecretConfiguration getSecretConfiguration(Configuration config, Environment environment) {
        Object object;
        List list;
        Option option;
        String string;
        List list2;
        Option option2;
        String string2;
        Regex Blank = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s*"));
        Option option3 = (Option)config.get("play.http.secret.key", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        if (option3 instanceof Some && ("changeme".equals(string2 = (String)((Some)option3).value()) || string2 != null && !(option2 = Blank.unapplySeq((CharSequence)string2)).isEmpty() && (list2 = (List)option2.get()).lengthCompare(0) == 0) || None$.MODULE$.equals(option3)) {
            Mode mode = environment.mode();
            Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
            if (!(mode != null ? !mode.equals(prod$) : prod$ != null)) {
                String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |The application secret has not been set, and we are in prod mode. Your application is not secure.\n              |To set the application secret, please read https://playframework.com/documentation/latest/ApplicationSecret\n              |"));
                throw config.reportError("play.http.secret", message, config.reportError$default$3());
            }
        }
        if (option3 instanceof Some && ("changeme".equals(string = (String)((Some)option3).value()) || string != null && !(option = Blank.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) || None$.MODULE$.equals(option3)) {
            Option appConfLocation = environment.resource("application.conf");
            String secret = (String)appConfLocation.fold(HttpConfiguration$::$anonfun$1, (Function1 & Serializable)_$2 -> _$2.toString());
            String md5Secret = Codecs$.MODULE$.md5(secret) + Codecs$.MODULE$.md5("the shells she sells are sea-shells");
            logger.debug("Generated dev mode secret " + md5Secret + " for app at " + appConfLocation.getOrElse(HttpConfiguration$::$anonfun$3));
            object = md5Secret;
        } else if (option3 instanceof Some) {
            String s = (String)((Some)option3).value();
            object = s;
        } else {
            throw new MatchError((Object)option3);
        }
        String secret = object;
        Option provider = (Option)config.getDeprecated("play.http.secret.provider", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"play.crypto.provider"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        return SecretConfiguration$.MODULE$.apply(String.valueOf(secret), (Option<String>)provider);
    }

    public HttpConfiguration createWithDefaults() {
        return this.apply(this.$lessinit$greater$default$1(), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
    }

    public HttpConfiguration fromProduct(Product x$0) {
        return new HttpConfiguration((String)x$0.productElement(0), (ParserConfiguration)x$0.productElement(1), (ActionCompositionConfiguration)x$0.productElement(2), (CookiesConfiguration)x$0.productElement(3), (SessionConfiguration)x$0.productElement(4), (FlashConfiguration)x$0.productElement(5), (FileMimeTypesConfiguration)x$0.productElement(6), (SecretConfiguration)x$0.productElement(7));
    }

    private static final /* synthetic */ boolean parseFileMimeTypes$$anonfun$1$$anonfun$1(char _$1) {
        return _$1 != '=';
    }

    private final String getPath$1(Configuration config$1, String key, Option deprecatedKey) {
        String string;
        Option option = deprecatedKey;
        if (option instanceof Some) {
            String depKey = (String)((Some)option).value();
            string = (String)config$1.getDeprecated(key, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{depKey}), ConfigLoader$.MODULE$.stringLoader());
        } else if (None$.MODULE$.equals(option)) {
            string = (String)config$1.get(key, ConfigLoader$.MODULE$.stringLoader());
        } else {
            throw new MatchError((Object)option);
        }
        String path = string;
        if (!path.startsWith("/")) {
            throw config$1.globalError(key + " must start with a /", config$1.globalError$default$2());
        }
        return path;
    }

    private final Option getPath$default$2$1() {
        return None$.MODULE$;
    }

    private static final String $anonfun$1() {
        return "she sells sea shells on the sea shore";
    }

    private static final Serializable $anonfun$3() {
        return "unknown location";
    }
}

