/*
 * Decompiled with CFR 0.152.
 */
package play.core.j;

import java.util.concurrent.Executor;
import play.core.j.ClassLoaderExecutionContext$;
import play.utils.ExecCtxUtils$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;

public class ClassLoaderExecutionContext
implements ExecutionContext,
ExecutionContextExecutor {
    private final ClassLoader contextClassLoader;
    private final ExecutionContext delegate;

    public static ExecutionContextExecutor fromThread(ExecutionContext executionContext) {
        return ClassLoaderExecutionContext$.MODULE$.fromThread(executionContext);
    }

    public static ExecutionContextExecutor fromThread(ExecutionContextExecutor executionContextExecutor) {
        return ClassLoaderExecutionContext$.MODULE$.fromThread(executionContextExecutor);
    }

    public static ExecutionContextExecutor fromThread(Executor executor) {
        return ClassLoaderExecutionContext$.MODULE$.fromThread(executor);
    }

    public static ExecutionContext unprepared(ExecutionContext executionContext) {
        return ClassLoaderExecutionContext$.MODULE$.unprepared(executionContext);
    }

    public ClassLoaderExecutionContext(ClassLoader contextClassLoader, ExecutionContext delegate) {
        this.contextClassLoader = contextClassLoader;
        this.delegate = delegate;
        ExecutionContext.$init$((ExecutionContext)this);
    }

    public void execute(Runnable runnable) {
        this.delegate.execute(() -> {
            Thread thread = Thread.currentThread();
            ClassLoader oldContextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextClassLoader);
            try {
                runnable.run();
            }
            finally {
                thread.setContextClassLoader(oldContextClassLoader);
            }
        });
    }

    public void reportFailure(Throwable t) {
        this.delegate.reportFailure(t);
    }

    public ExecutionContext prepare() {
        ExecutionContext delegatePrepared = ExecCtxUtils$.MODULE$.prepare(this.delegate);
        if (delegatePrepared == this.delegate) {
            return this;
        }
        return new ClassLoaderExecutionContext(this.contextClassLoader, delegatePrepared);
    }
}

