/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.ref.Reference;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.dispatch.MessageDispatcher;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.inject.ApplicationLifecycle;
import play.api.libs.Files$;
import play.api.libs.Files$TemporaryFile$;
import play.api.libs.Files$TemporaryFileReaperConfiguration$;
import play.libs.Files;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.convert.StreamExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.StreamConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Try$;

public final class Files {
    public static org.slf4j.Logger logger() {
        return Files$.MODULE$.logger();
    }

    @Singleton
    public static class DefaultTemporaryFileCreator
    implements TemporaryFileCreator {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultTemporaryFileCreator.class.getDeclaredField("playTempFolder$lzy1"));
        private TemporaryFileReaper temporaryFileReaper;
        private final Configuration conf;
        public final Logger play$api$libs$Files$DefaultTemporaryFileCreator$$logger;
        public final FinalizableReferenceQueue play$api$libs$Files$DefaultTemporaryFileCreator$$frq;
        public final Set<Reference<TemporaryFile>> play$api$libs$Files$DefaultTemporaryFileCreator$$references;
        private final String TempDirectoryPrefix;
        private volatile Object playTempFolder$lzy1;

        @Inject
        public DefaultTemporaryFileCreator(ApplicationLifecycle applicationLifecycle, TemporaryFileReaper temporaryFileReaper, Configuration conf) {
            this.temporaryFileReaper = temporaryFileReaper;
            this.conf = conf;
            this.play$api$libs$Files$DefaultTemporaryFileCreator$$logger = Logger$.MODULE$.apply(this.getClass());
            this.play$api$libs$Files$DefaultTemporaryFileCreator$$frq = new FinalizableReferenceQueue();
            this.play$api$libs$Files$DefaultTemporaryFileCreator$$references = Sets.newConcurrentHashSet();
            this.TempDirectoryPrefix = "playtemp";
            applicationLifecycle.addStopHook((Function0 & Serializable)() -> {
                if (java.nio.file.Files.isDirectory(this.play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder(), new LinkOption[0])) {
                    java.nio.file.Files.walkFileTree(this.play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                        private final /* synthetic */ DefaultTemporaryFileCreator $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$logger.debug(() -> this.visitFile$$anonfun$1(path), MarkerContext$.MODULE$.NoMarker());
                            this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$deletePath(path);
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult postVisitDirectory(Path path, IOException exc) {
                            this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$deletePath(path);
                            return FileVisitResult.CONTINUE;
                        }

                        private final String visitFile$$anonfun$1(Path path$1) {
                            return "stopHook: Removing leftover temporary file " + path$1 + " from " + this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder();
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{visitFile$$anonfun$1(java.nio.file.Path )}, serializedLambda);
                        }
                    });
                }
                this.play$api$libs$Files$DefaultTemporaryFileCreator$$frq.close();
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            });
        }

        public Path play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder() {
            Object object = this.playTempFolder$lzy1;
            if (object instanceof Path) {
                return (Path)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Path)this.playTempFolder$lzyINIT1();
        }

        private Object playTempFolder$lzyINIT1() {
            Object object;
            block7: {
                while (true) {
                    if ((object = this.playTempFolder$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Path path = null;
                        try {
                            Path dir = Paths.get((String)this.conf.get("play.temporaryFile.dir", ConfigLoader$.MODULE$.stringLoader()), new String[0]);
                            java.nio.file.Files.createDirectories(dir, new FileAttribute[0]);
                            Path tmpFolder = java.nio.file.Files.createTempDirectory(dir, this.TempDirectoryPrefix, new FileAttribute[0]);
                            this.temporaryFileReaper.updateTempFolder(tmpFolder);
                            path = tmpFolder;
                            object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                            this.temporaryFileReaper = null;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.playTempFolder$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.playTempFolder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        return path;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public TemporaryFile create(String prefix, String suffix) {
            java.nio.file.Files.createDirectories(this.play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder(), new FileAttribute[0]);
            Path tempFile = java.nio.file.Files.createTempFile(this.play$api$libs$Files$DefaultTemporaryFileCreator$$playTempFolder(), prefix, suffix, new FileAttribute[0]);
            return this.createReference(new DefaultTemporaryFile(this, tempFile, this));
        }

        @Override
        public TemporaryFile create(Path path) {
            return this.createReference(new DefaultTemporaryFile(this, path, this));
        }

        private TemporaryFile createReference(TemporaryFile tempFile) {
            Path path = tempFile.path();
            FinalizablePhantomReference<TemporaryFile> reference = new FinalizablePhantomReference<TemporaryFile>(tempFile, path, this){
                private final Path path$3;
                private final /* synthetic */ DefaultTemporaryFileCreator $outer;
                {
                    this.path$3 = path$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super((Object)tempFile$1, $outer.play$api$libs$Files$DefaultTemporaryFileCreator$$frq);
                }

                public void finalizeReferent() {
                    this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$references.remove((Object)((Object)this));
                    this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$deletePath(this.path$3);
                }
            };
            this.play$api$libs$Files$DefaultTemporaryFileCreator$$references.add((Reference<TemporaryFile>)reference);
            return tempFile;
        }

        @Override
        public Try<Object> delete(TemporaryFile tempFile) {
            return this.play$api$libs$Files$DefaultTemporaryFileCreator$$deletePath(tempFile.path());
        }

        public Try<Object> play$api$libs$Files$DefaultTemporaryFileCreator$$deletePath(Path path) {
            this.play$api$libs$Files$DefaultTemporaryFileCreator$$logger.debug(() -> Files$.play$api$libs$Files$DefaultTemporaryFileCreator$$_$deletePath$$anonfun$1(path), MarkerContext$.MODULE$.NoMarker());
            return Try$.MODULE$.apply(() -> Files$.play$api$libs$Files$DefaultTemporaryFileCreator$$_$deletePath$$anonfun$2(path)).recoverWith((PartialFunction)new Serializable(path, this){
                private final Path path$6;
                private final /* synthetic */ DefaultTemporaryFileCreator $outer;
                {
                    this.path$6 = path$9;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception e = (Exception)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception e = (Exception)throwable;
                        this.$outer.play$api$libs$Files$DefaultTemporaryFileCreator$$logger.error(this::applyOrElse$$anonfun$1, () -> Files$.play$api$libs$Files$DefaultTemporaryFileCreator$$anon$3$$_$applyOrElse$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                        return Failure$.MODULE$.apply((Throwable)e);
                    }
                    return function1.apply((Object)x);
                }

                private final String applyOrElse$$anonfun$1() {
                    return "Cannot delete " + this.path$6;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(), play$api$libs$Files$DefaultTemporaryFileCreator$$anon$3$$_$applyOrElse$$anonfun$2(java.lang.Exception )}, serializedLambda);
                }
            });
        }

        public class DefaultTemporaryFile
        implements TemporaryFile {
            private final Path path;
            private final TemporaryFileCreator temporaryFileCreator;
            private final /* synthetic */ DefaultTemporaryFileCreator $outer;

            public DefaultTemporaryFile(DefaultTemporaryFileCreator $outer, Path path, TemporaryFileCreator temporaryFileCreator) {
                this.path = path;
                this.temporaryFileCreator = temporaryFileCreator;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            @Override
            public Path path() {
                return this.path;
            }

            @Override
            public TemporaryFileCreator temporaryFileCreator() {
                return this.temporaryFileCreator;
            }

            @Override
            public File file() {
                return this.path().toFile();
            }

            public final /* synthetic */ DefaultTemporaryFileCreator play$api$libs$Files$DefaultTemporaryFileCreator$DefaultTemporaryFile$$$outer() {
                return this.$outer;
            }
        }
    }

    @Singleton
    public static class DefaultTemporaryFileReaper
    implements TemporaryFileReaper {
        private final TemporaryFileReaperConfiguration config;
        private final Logger logger;
        private final MessageDispatcher blockingExecutionContext;
        private Option<Path> playTempFolder;
        private Option<Cancellable> cancellable;
        private final Clock clock;

        @Inject
        public DefaultTemporaryFileReaper(ActorSystem actorSystem, TemporaryFileReaperConfiguration config) {
            this.config = config;
            this.logger = Logger$.MODULE$.apply(this.getClass());
            String blockingDispatcherName = "play.pekko.blockingIoDispatcher";
            this.blockingExecutionContext = actorSystem.dispatchers().lookup(blockingDispatcherName);
            this.playTempFolder = None$.MODULE$;
            this.cancellable = None$.MODULE$;
            this.clock = Clock.systemUTC();
            if (config.enabled()) {
                Option<Path> option = this.playTempFolder;
                if (option instanceof Some) {
                    Path folder = (Path)((Some)option).value();
                    this.logger.debug(() -> this.$init$$$anonfun$2(folder, config), MarkerContext$.MODULE$.NoMarker());
                } else if (None$.MODULE$.equals(option)) {
                    this.logger.debug(() -> this.$init$$$anonfun$3(config), MarkerContext$.MODULE$.NoMarker());
                } else {
                    throw new MatchError(option);
                }
                this.cancellable = Some$.MODULE$.apply((Object)actorSystem.scheduler().scheduleAtFixedRate(config.initialDelay(), config.interval(), () -> this.reap(), (ExecutionContext)actorSystem.dispatcher()));
            }
        }

        public Clock clock() {
            return this.clock;
        }

        public boolean enabled() {
            return this.cancellable.nonEmpty();
        }

        @Override
        public void updateTempFolder(Path folder) {
            this.playTempFolder = Option$.MODULE$.apply((Object)folder);
        }

        public Instant secondsAgo() {
            return this.clock().instant().minusSeconds(this.config.olderThan().toSeconds());
        }

        public Future<Seq<Path>> reap() {
            this.logger.debug(this::reap$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
            return Future$.MODULE$.apply(this::reap$$anonfun$2, (ExecutionContext)this.blockingExecutionContext);
        }

        public void delete(Path path) {
            this.logger.debug(() -> Files$.play$api$libs$Files$DefaultTemporaryFileReaper$$_$delete$$anonfun$1(path), MarkerContext$.MODULE$.NoMarker());
            try {
                java.nio.file.Files.deleteIfExists(path);
            }
            catch (Exception e) {
                this.logger.error(() -> Files$.play$api$libs$Files$DefaultTemporaryFileReaper$$_$delete$$anonfun$2(path), () -> Files$.play$api$libs$Files$DefaultTemporaryFileReaper$$_$delete$$anonfun$3(e), MarkerContext$.MODULE$.NoMarker());
            }
        }

        public void disable() {
            this.cancellable.foreach(Files$::play$api$libs$Files$DefaultTemporaryFileReaper$$_$disable$$anonfun$1);
        }

        private final String $init$$$anonfun$2(Path folder$1, TemporaryFileReaperConfiguration config$1) {
            return "Reaper enabled on " + folder$1 + ", starting in " + config$1.initialDelay() + " with " + config$1.interval() + " intervals";
        }

        private final String $init$$$anonfun$3(TemporaryFileReaperConfiguration config$2) {
            return "Reaper enabled but no temp folder has been created yet, starting in " + config$2.initialDelay() + " with " + config$2.interval() + " intervals";
        }

        private final String reap$$anonfun$1() {
            return "reap: reaping old files from " + this.playTempFolder;
        }

        private final Seq reap$$anonfun$2() {
            return (Seq)this.playTempFolder.map((Function1 & Serializable)f -> {
                void v0;
                try (Stream<Path> directoryStream = java.nio.file.Files.list(f);){
                    void var3_3;
                    List reaped = (List)StreamConverters$.MODULE$.StreamHasToScala(directoryStream.filter(p -> {
                        Instant lastModifiedTime = java.nio.file.Files.getLastModifiedTime(p, new LinkOption[0]).toInstant();
                        return lastModifiedTime.isBefore(this.secondsAgo());
                    })).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo());
                    reaped.foreach((Function1)(JProcedure1 & Serializable)path -> this.delete((Path)path));
                    v0 = var3_3;
                }
                return v0;
            }).getOrElse(Files$::play$api$libs$Files$DefaultTemporaryFileReaper$$_$reap$$anonfun$2$$anonfun$2);
        }
    }

    public static interface TemporaryFile {
        public static TemporaryFile apply(TemporaryFileCreator temporaryFileCreator, String string, String string2) {
            return Files$TemporaryFile$.MODULE$.apply(temporaryFileCreator, string, string2);
        }

        public static File temporaryFileToFile(TemporaryFile temporaryFile) {
            return Files$TemporaryFile$.MODULE$.temporaryFileToFile(temporaryFile);
        }

        public static Path temporaryFileToPath(TemporaryFile temporaryFile) {
            return Files$TemporaryFile$.MODULE$.temporaryFileToPath(temporaryFile);
        }

        public static String apply$default$2() {
            return Files$TemporaryFile$.MODULE$.apply$default$2();
        }

        public static String apply$default$3() {
            return Files$TemporaryFile$.MODULE$.apply$default$3();
        }

        public Path path();

        public File file();

        public TemporaryFileCreator temporaryFileCreator();

        public static Path copyTo$(TemporaryFile $this, File to, boolean replace) {
            return $this.copyTo(to, replace);
        }

        default public Path copyTo(File to, boolean replace) {
            return this.copyTo(to.toPath(), replace);
        }

        public static boolean copyTo$default$2$(TemporaryFile $this) {
            return $this.copyTo$default$2();
        }

        default public boolean copyTo$default$2() {
            return false;
        }

        public static Path copyTo$(TemporaryFile $this, Path to, boolean replace) {
            return $this.copyTo(to, replace);
        }

        default public Path copyTo(Path to, boolean replace) {
            Path path;
            try {
                path = replace ? java.nio.file.Files.copy(this.path(), to, StandardCopyOption.REPLACE_EXISTING) : (!to.toFile().exists() ? java.nio.file.Files.copy(this.path(), to, new CopyOption[0]) : to);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                path = to;
            }
            Path destination = path;
            return destination;
        }

        public static Path moveFileTo$(TemporaryFile $this, File to, boolean replace) {
            return $this.moveFileTo(to, replace);
        }

        default public Path moveFileTo(File to, boolean replace) {
            return this.moveFileTo(to.toPath(), replace);
        }

        public static boolean moveFileTo$default$2$(TemporaryFile $this) {
            return $this.moveFileTo$default$2();
        }

        default public boolean moveFileTo$default$2() {
            return false;
        }

        public static Path moveFileTo$(TemporaryFile $this, Path to, boolean replace) {
            return $this.moveFileTo(to, replace);
        }

        default public Path moveFileTo(Path to, boolean replace) {
            return this.moveTo(to, replace);
        }

        public static Path moveTo$(TemporaryFile $this, File to, boolean replace) {
            return $this.moveTo(to, replace);
        }

        default public Path moveTo(File to, boolean replace) {
            return this.moveTo(to.toPath(), replace);
        }

        public static boolean moveTo$default$2$(TemporaryFile $this) {
            return $this.moveTo$default$2();
        }

        default public boolean moveTo$default$2() {
            return false;
        }

        public static Path moveTo$(TemporaryFile $this, Path to, boolean replace) {
            return $this.moveTo(to, replace);
        }

        default public Path moveTo(Path to, boolean replace) {
            Path path;
            try {
                path = replace ? java.nio.file.Files.move(this.path(), to, StandardCopyOption.REPLACE_EXISTING) : (!to.toFile().exists() ? java.nio.file.Files.move(this.path(), to, new CopyOption[0]) : to);
            }
            catch (FileAlreadyExistsException ex) {
                path = to;
            }
            Path destination = path;
            return destination;
        }

        public static Path atomicMoveFileWithFallback$(TemporaryFile $this, File to) {
            return $this.atomicMoveFileWithFallback(to);
        }

        default public Path atomicMoveFileWithFallback(File to) {
            return this.atomicMoveFileWithFallback(to.toPath());
        }

        public static Path atomicMoveFileWithFallback$(TemporaryFile $this, Path to) {
            return $this.atomicMoveFileWithFallback(to);
        }

        default public Path atomicMoveFileWithFallback(Path to) {
            return this.atomicMoveWithFallback(to);
        }

        public static Path atomicMoveWithFallback$(TemporaryFile $this, File to) {
            return $this.atomicMoveWithFallback(to);
        }

        default public Path atomicMoveWithFallback(File to) {
            return this.atomicMoveWithFallback(to.toPath());
        }

        public static Path atomicMoveWithFallback$(TemporaryFile $this, Path to) {
            return $this.atomicMoveWithFallback(to);
        }

        default public Path atomicMoveWithFallback(Path to) {
            Path path;
            try {
                path = java.nio.file.Files.move(this.path(), to, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException outer) {
                try {
                    Path p = java.nio.file.Files.move(this.path(), to, StandardCopyOption.REPLACE_EXISTING);
                    Files$.MODULE$.logger().debug("Non-atomic move of " + this.path() + " to " + to + " succeeded after atomic move failed due to " + outer.getMessage());
                    path = p;
                }
                catch (IOException inner) {
                    inner.addSuppressed(outer);
                    throw inner;
                }
            }
            Path destination = path;
            return destination;
        }
    }

    public static interface TemporaryFileCreator {
        public TemporaryFile create(String var1, String var2);

        public static String create$default$1$(TemporaryFileCreator $this) {
            return $this.create$default$1();
        }

        default public String create$default$1() {
            return "";
        }

        public static String create$default$2$(TemporaryFileCreator $this) {
            return $this.create$default$2();
        }

        default public String create$default$2() {
            return "";
        }

        public TemporaryFile create(Path var1);

        public Try<Object> delete(TemporaryFile var1);

        public static Files.TemporaryFileCreator asJava$(TemporaryFileCreator $this) {
            return $this.asJava();
        }

        default public Files.TemporaryFileCreator asJava() {
            return new Files.DelegateTemporaryFileCreator(this);
        }
    }

    public static interface TemporaryFileReaper {
        public void updateTempFolder(Path var1);
    }

    public static class TemporaryFileReaperConfiguration
    implements Product,
    Serializable {
        private final boolean enabled;
        private final FiniteDuration olderThan;
        private final FiniteDuration initialDelay;
        private final FiniteDuration interval;

        public static TemporaryFileReaperConfiguration apply(boolean bl, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, FiniteDuration finiteDuration3) {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.apply(bl, finiteDuration, finiteDuration2, finiteDuration3);
        }

        public static TemporaryFileReaperConfiguration createWithDefaults() {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.createWithDefaults();
        }

        public static TemporaryFileReaperConfiguration fromConfiguration(Configuration configuration) {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.fromConfiguration(configuration);
        }

        public static TemporaryFileReaperConfiguration fromProduct(Product product) {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.fromProduct(product);
        }

        public static TemporaryFileReaperConfiguration unapply(TemporaryFileReaperConfiguration temporaryFileReaperConfiguration) {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.unapply(temporaryFileReaperConfiguration);
        }

        public static boolean $lessinit$greater$default$1() {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.$lessinit$greater$default$1();
        }

        public static FiniteDuration $lessinit$greater$default$2() {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.$lessinit$greater$default$2();
        }

        public static FiniteDuration $lessinit$greater$default$3() {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.$lessinit$greater$default$3();
        }

        public static FiniteDuration $lessinit$greater$default$4() {
            return Files$TemporaryFileReaperConfiguration$.MODULE$.$lessinit$greater$default$4();
        }

        public TemporaryFileReaperConfiguration(boolean enabled, FiniteDuration olderThan, FiniteDuration initialDelay, FiniteDuration interval) {
            this.enabled = enabled;
            this.olderThan = olderThan;
            this.initialDelay = initialDelay;
            this.interval = interval;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.olderThan()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.initialDelay()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interval()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TemporaryFileReaperConfiguration)) return false;
            TemporaryFileReaperConfiguration temporaryFileReaperConfiguration = (TemporaryFileReaperConfiguration)object;
            if (this.enabled() != temporaryFileReaperConfiguration.enabled()) return false;
            FiniteDuration finiteDuration = this.olderThan();
            FiniteDuration finiteDuration2 = temporaryFileReaperConfiguration.olderThan();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.initialDelay();
            FiniteDuration finiteDuration4 = temporaryFileReaperConfiguration.initialDelay();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!finiteDuration3.equals(finiteDuration4)) return false;
            FiniteDuration finiteDuration5 = this.interval();
            FiniteDuration finiteDuration6 = temporaryFileReaperConfiguration.interval();
            if (finiteDuration5 == null) {
                if (finiteDuration6 != null) {
                    return false;
                }
            } else if (!finiteDuration5.equals(finiteDuration6)) return false;
            if (!temporaryFileReaperConfiguration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TemporaryFileReaperConfiguration;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "TemporaryFileReaperConfiguration";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "olderThan";
                }
                case 2: {
                    return "initialDelay";
                }
                case 3: {
                    return "interval";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public FiniteDuration olderThan() {
            return this.olderThan;
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        public FiniteDuration interval() {
            return this.interval;
        }

        public TemporaryFileReaperConfiguration copy(boolean enabled, FiniteDuration olderThan, FiniteDuration initialDelay, FiniteDuration interval) {
            return new TemporaryFileReaperConfiguration(enabled, olderThan, initialDelay, interval);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public FiniteDuration copy$default$2() {
            return this.olderThan();
        }

        public FiniteDuration copy$default$3() {
            return this.initialDelay();
        }

        public FiniteDuration copy$default$4() {
            return this.interval();
        }

        public boolean _1() {
            return this.enabled();
        }

        public FiniteDuration _2() {
            return this.olderThan();
        }

        public FiniteDuration _3() {
            return this.initialDelay();
        }

        public FiniteDuration _4() {
            return this.interval();
        }
    }

    @Singleton
    public static class TemporaryFileReaperConfigurationProvider
    implements Provider<TemporaryFileReaperConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TemporaryFileReaperConfigurationProvider.class.getDeclaredField("get$lzy2"));
        private Configuration configuration;
        private volatile Object get$lzy2;

        @Inject
        public TemporaryFileReaperConfigurationProvider(Configuration configuration) {
            this.configuration = configuration;
        }

        public TemporaryFileReaperConfiguration get() {
            Object object = this.get$lzy2;
            if (object instanceof TemporaryFileReaperConfiguration) {
                return (TemporaryFileReaperConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (TemporaryFileReaperConfiguration)this.get$lzyINIT2();
        }

        private Object get$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        TemporaryFileReaperConfiguration temporaryFileReaperConfiguration = null;
                        try {
                            temporaryFileReaperConfiguration = Files$TemporaryFileReaperConfiguration$.MODULE$.fromConfiguration(this.configuration);
                            object2 = temporaryFileReaperConfiguration == null ? LazyVals.NullValue$.MODULE$ : temporaryFileReaperConfiguration;
                            this.configuration = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return temporaryFileReaperConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }
}

