/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.format;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.UUID;
import play.api.data.FormError;
import play.api.data.FormError$;
import play.api.data.format.Formatter;
import play.api.data.format.PlayDate$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.Exception$;

public final class Formats$
implements Serializable {
    private static final Formatter bigDecimalFormat;
    private static final Formatter dateFormat;
    private static final Formatter sqlDateFormat;
    private static final Formatter sqlTimestampFormat;
    private static final Formatter localDateFormat;
    private static final Formatter localDateTimeFormat;
    private static final Formatter localTimeFormat;
    public static final Formats$ MODULE$;

    private Formats$() {
    }

    static {
        MODULE$ = new Formats$();
        bigDecimalFormat = MODULE$.bigDecimalFormat((Option<Tuple2<Object, Object>>)None$.MODULE$);
        dateFormat = MODULE$.dateFormat("yyyy-MM-dd", MODULE$.dateFormat$default$2());
        sqlDateFormat = MODULE$.sqlDateFormat("yyyy-MM-dd");
        sqlTimestampFormat = MODULE$.sqlTimestampFormat("yyyy-MM-dd HH:mm:ss", MODULE$.sqlTimestampFormat$default$2());
        localDateFormat = MODULE$.localDateFormat("yyyy-MM-dd");
        localDateTimeFormat = MODULE$.localDateTimeFormat("yyyy-MM-dd HH:mm:ss", MODULE$.localDateTimeFormat$default$2());
        localTimeFormat = MODULE$.localTimeFormat("HH:mm:ss");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Formats$.class);
    }

    public <A> Formatter<A> ignoredFormat(A value) {
        return new Formatter<A>(value){
            private final Object value$1;
            private Option format;
            {
                this.value$1 = value$4;
                Formatter.$init$(this);
                Statics.releaseFence();
            }

            public Option format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Either bind(String key, Map data) {
                return package$.MODULE$.Right().apply(this.value$1);
            }

            public Map unbind(String key, Object value) {
                return Predef$.MODULE$.Map().empty();
            }
        };
    }

    public Formatter<String> stringFormat() {
        return new Formatter<String>(){
            private Option format;
            {
                Formatter.$init$(this);
                Statics.releaseFence();
            }

            public Option format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Either bind(String key, Map data) {
                return data.get((Object)key).toRight(() -> Formats$.play$api$data$format$Formats$$anon$2$$_$bind$$anonfun$1(key));
            }

            public Map unbind(String key, String value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$data$format$Formats$$anon$2$$_$bind$$anonfun$1(java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<Object> charFormat() {
        return new Formatter<Object>(){
            private Option format;
            {
                Formatter.$init$(this);
                Statics.releaseFence();
            }

            public Option format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Either bind(String key, Map data) {
                return (Either)data.get((Object)key).filter(Formats$::play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$2).map(Formats$::play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$3).getOrElse(() -> Formats$.play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$4(key));
            }

            public Map unbind(String key, char value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToCharacter((char)value).toString());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$2(java.lang.String ), play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$3(java.lang.String ), play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$4(java.lang.String )}, serializedLambda);
            }
        };
    }

    public <T> Either<Seq<FormError>, T> parsing(Function1<String, T> parse, String errMsg, Seq<Object> errArgs, String key, Map<String, String> data) {
        return this.stringFormat().bind(key, data).flatMap((Function1 & Serializable)s -> Exception$.MODULE$.allCatch().either(() -> Formats$.parsing$$anonfun$1$$anonfun$1(parse, s)).left().map((Function1 & Serializable)e -> (Seq)((SeqOps)new .colon.colon((Object)FormError$.MODULE$.apply(key, errMsg, errArgs), (List)Nil$.MODULE$))));
    }

    private <T> Formatter<T> numberFormatter(Function1<String, T> convert, boolean real) {
        Tuple2 tuple2 = real ? Tuple2$.MODULE$.apply((Object)"format.real", (Object)"error.real") : Tuple2$.MODULE$.apply((Object)"format.numeric", (Object)"error.number");
        String formatString = (String)tuple2._1();
        String errorString = (String)tuple2._2();
        return new Formatter<T>(formatString, convert, errorString){
            private final Function1 convert$2;
            private final String errorString$2;
            private Option format;
            {
                this.convert$2 = convert$1;
                this.errorString$2 = errorString$1;
                Formatter.$init$(this);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)formatString$1);
                this.format = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.Nil()));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data) {
                return Formats$.MODULE$.parsing(this.convert$2, this.errorString$2, (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data);
            }

            public Map unbind(String key, Object value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.toString());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
        };
    }

    private boolean numberFormatter$default$2() {
        return false;
    }

    public Formatter<Object> longFormat() {
        return this.numberFormatter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$1)), this.numberFormatter$default$2());
    }

    public Formatter<Object> intFormat() {
        return this.numberFormatter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$2)), this.numberFormatter$default$2());
    }

    public Formatter<Object> shortFormat() {
        return this.numberFormatter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(_$3)), this.numberFormatter$default$2());
    }

    public Formatter<Object> byteFormat() {
        return this.numberFormatter((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(_$4)), this.numberFormatter$default$2());
    }

    public Formatter<Object> floatFormat() {
        return this.numberFormatter((Function1 & Serializable)_$5 -> StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(_$5)), true);
    }

    public Formatter<Object> doubleFormat() {
        return this.numberFormatter((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$6)), true);
    }

    public Formatter<BigDecimal> bigDecimalFormat(Option<Tuple2<Object, Object>> precision) {
        return new Formatter<BigDecimal>(precision){
            private final Option precision$1;
            private Option format;
            {
                this.precision$1 = precision$2;
                Formatter.$init$(this);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.real", (Object)package$.MODULE$.Nil()));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data) {
                return Formats$.MODULE$.stringFormat().bind(key, (Map<String, String>)data).flatMap((Function1 & Serializable)s -> Exception$.MODULE$.allCatch().either(() -> this.bind$$anonfun$5$$anonfun$1(s)).left().map((Function1 & Serializable)e -> {
                    FormError formError;
                    Tuple2 tuple2;
                    Option option = this.precision$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        int p = tuple2._1$mcI$sp();
                        int s = tuple2._2$mcI$sp();
                        formError = FormError$.MODULE$.apply(key, "error.real.precision", (Seq<Object>)((Seq)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)p), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)s), (List)Nil$.MODULE$)))));
                    } else if (None$.MODULE$.equals(option)) {
                        formError = FormError$.MODULE$.apply(key, "error.real", (Seq<Object>)package$.MODULE$.Nil());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return (Seq)((SeqOps)new .colon.colon((Object)formError, (List)Nil$.MODULE$));
                }));
            }

            public Map unbind(String key, BigDecimal value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((BigDecimal)this.precision$1.map(arg_0 -> Formats$.play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$1(value, arg_0)).getOrElse(() -> Formats$.play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$2(value))).toString());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private final BigDecimal bind$$anonfun$5$$anonfun$1(String s$2) {
                BigDecimal bd = package$.MODULE$.BigDecimal().apply(s$2);
                return (BigDecimal)this.precision$1.map(arg_0 -> Formats$.play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$1(bd, arg_0)).getOrElse(() -> Formats$.play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$2(bd));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$5(java.lang.String java.lang.String ), play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$1(scala.math.BigDecimal scala.Tuple2 ), play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$2(scala.math.BigDecimal ), play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$1(scala.math.BigDecimal scala.Tuple2 ), play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$2(scala.math.BigDecimal ), bind$$anonfun$5$$anonfun$1(java.lang.String ), bind$$anonfun$5$$anonfun$2(java.lang.String java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public Formatter<BigDecimal> bigDecimalFormat() {
        return bigDecimalFormat;
    }

    public Formatter<Object> booleanFormat() {
        return new Formatter<Object>(){
            private Option format;
            {
                Formatter.$init$(this);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.boolean", (Object)package$.MODULE$.Nil()));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data) {
                return package$.MODULE$.Right().apply(data.getOrElse((Object)key, Formats$::play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$6)).flatMap(arg_0 -> Formats$.play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$7(key, arg_0));
            }

            public Map unbind(String key, boolean value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)value).toString());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$6(), play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$7(java.lang.String java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<java.util.Date> dateFormat(String pattern, TimeZone timeZone) {
        return new Formatter<java.util.Date>(timeZone, pattern){
            private final ZoneId javaTimeZone;
            private final DateTimeFormatter formatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.javaTimeZone = timeZone$1.toZoneId();
                this.formatter = DateTimeFormatter.ofPattern(pattern$1);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.date", (Object)((SeqOps)new .colon.colon((Object)pattern$1, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public ZoneId javaTimeZone() {
                return this.javaTimeZone;
            }

            public DateTimeFormatter formatter() {
                return this.formatter;
            }

            public java.util.Date dateParse(String data) {
                ZonedDateTime instant = PlayDate$.MODULE$.parse(data, this.formatter()).toZonedDateTime(ZoneOffset.UTC);
                return java.util.Date.from(instant.withZoneSameLocal(this.javaTimeZone()).toInstant());
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.dateParse((String)data), "error.date", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data2);
            }

            public Map unbind(String key, java.util.Date value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.formatter().format(value.toInstant().atZone(this.javaTimeZone())));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$8(java.lang.String )}, serializedLambda);
            }
        };
    }

    public TimeZone dateFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<java.util.Date> dateFormat() {
        return dateFormat;
    }

    public Formatter<Date> sqlDateFormat(String pattern) {
        return new Formatter<Date>(pattern){
            private final Formatter dateFormatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.dateFormatter = Formats$.MODULE$.localDateFormat(pattern$2);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.date", (Object)((SeqOps)new .colon.colon((Object)pattern$2, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data) {
                return this.dateFormatter.bind(key, (Map<String, String>)data).map(Formats$::play$api$data$format$Formats$$anon$8$$_$bind$$anonfun$9);
            }

            public Map unbind(String key, Date value) {
                return this.dateFormatter.unbind(key, value.toLocalDate());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$data$format$Formats$$anon$8$$_$bind$$anonfun$9(java.time.LocalDate )}, serializedLambda);
            }
        };
    }

    public Formatter<Date> sqlDateFormat() {
        return sqlDateFormat;
    }

    public Formatter<Timestamp> sqlTimestampFormat(String pattern, TimeZone timeZone) {
        return new Formatter<Timestamp>(pattern, timeZone){
            private final DateTimeFormatter formatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$3).withZone(timeZone$2.toZoneId());
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.timestamp", (Object)((SeqOps)new .colon.colon((Object)pattern$3, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            private Timestamp timestampParse(String data) {
                return Timestamp.valueOf(LocalDateTime.parse(data, this.formatter));
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.timestampParse((String)data), "error.timestamp", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data2);
            }

            public Map unbind(String key, Timestamp value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.toLocalDateTime().format(this.formatter));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$10(java.lang.String )}, serializedLambda);
            }
        };
    }

    public TimeZone sqlTimestampFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<Timestamp> sqlTimestampFormat() {
        return sqlTimestampFormat;
    }

    public Formatter<LocalDate> localDateFormat(String pattern) {
        return new Formatter<LocalDate>(pattern){
            private final DateTimeFormatter formatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$4);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.date", (Object)((SeqOps)new .colon.colon((Object)pattern$4, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public DateTimeFormatter formatter() {
                return this.formatter;
            }

            public LocalDate localDateParse(String data) {
                return LocalDate.parse(data, this.formatter());
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localDateParse((String)data), "error.date", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data2);
            }

            public Map unbind(String key, LocalDate value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.format(this.formatter()));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$11(java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<LocalDate> localDateFormat() {
        return localDateFormat;
    }

    public Formatter<LocalDateTime> localDateTimeFormat(String pattern, ZoneId zoneId) {
        return new Formatter<LocalDateTime>(pattern, zoneId){
            private final DateTimeFormatter formatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$5).withZone(zoneId$1);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.localDateTime", (Object)((SeqOps)new .colon.colon((Object)pattern$5, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public DateTimeFormatter formatter() {
                return this.formatter;
            }

            public LocalDateTime localDateTimeParse(String data) {
                return LocalDateTime.parse(data, this.formatter());
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localDateTimeParse((String)data), "error.localDateTime", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data2);
            }

            public Map unbind(String key, LocalDateTime value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.format(this.formatter()));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$12(java.lang.String )}, serializedLambda);
            }
        };
    }

    public ZoneId localDateTimeFormat$default$2() {
        return ZoneId.systemDefault();
    }

    public Formatter<LocalDateTime> localDateTimeFormat() {
        return localDateTimeFormat;
    }

    public Formatter<LocalTime> localTimeFormat(String pattern) {
        return new Formatter<LocalTime>(pattern){
            private final DateTimeFormatter formatter;
            private Option format;
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$6);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.localTime", (Object)((SeqOps)new .colon.colon((Object)pattern$6, (List)Nil$.MODULE$))));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public DateTimeFormatter formatter() {
                return this.formatter;
            }

            public LocalTime localTimeParse(String data) {
                return LocalTime.parse(data, this.formatter());
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localTimeParse((String)data), "error.localTime", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data2);
            }

            public Map unbind(String key, LocalTime value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.format(this.formatter()));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bind$$anonfun$13(java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<LocalTime> localTimeFormat() {
        return localTimeFormat;
    }

    public Formatter<UUID> uuidFormat() {
        return new Formatter<UUID>(){
            private Option format;
            {
                Formatter.$init$(this);
                this.format = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"format.uuid", (Object)package$.MODULE$.Nil()));
                Statics.releaseFence();
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option x$0) {
                this.format = x$0;
            }

            public Option format() {
                return this.format;
            }

            public Either bind(String key, Map data) {
                return Formats$.MODULE$.parsing(Formats$::play$api$data$format$Formats$$anon$13$$_$bind$$anonfun$14, "error.uuid", (Seq<Object>)package$.MODULE$.Nil(), key, (Map<String, String>)data);
            }

            public Map unbind(String key, UUID value) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value.toString());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$data$format$Formats$$anon$13$$_$bind$$anonfun$14(java.lang.String )}, serializedLambda);
            }
        };
    }

    public static final Seq play$api$data$format$Formats$$anon$2$$_$bind$$anonfun$1(String key$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)FormError$.MODULE$.apply(key$1, "error.required", (Seq<Object>)package$.MODULE$.Nil()), (List)Nil$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$2(String s) {
        if (s.length() != 1) return false;
        String string = s;
        String string2 = " ";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ Right play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$3(String s) {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
    }

    public static final Either play$api$data$format$Formats$$anon$3$$_$bind$$anonfun$4(String key$2) {
        return package$.MODULE$.Left().apply((Object)((SeqOps)new .colon.colon((Object)FormError$.MODULE$.apply(key$2, "error.required", (Seq<Object>)package$.MODULE$.Nil()), (List)Nil$.MODULE$)));
    }

    private static final Object parsing$$anonfun$1$$anonfun$1(Function1 parse$2, String s$1) {
        return parse$2.apply((Object)s$1);
    }

    public static final /* synthetic */ BigDecimal play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$1(BigDecimal bd$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int p = tuple2._1$mcI$sp();
            int s = tuple2._2$mcI$sp();
            if (bd$1.precision() - bd$1.scale() > p - s) {
                throw new ArithmeticException("Invalid precision");
            }
            return bd$1.setScale(s);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final BigDecimal play$api$data$format$Formats$$anon$5$$_$bind$$anonfun$5$$anonfun$1$$anonfun$2(BigDecimal bd$2) {
        return bd$2;
    }

    public static final /* synthetic */ BigDecimal play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$1(BigDecimal value$2, Tuple2 p) {
        return value$2.setScale(p._2$mcI$sp());
    }

    public static final BigDecimal play$api$data$format$Formats$$anon$5$$_$unbind$$anonfun$2(BigDecimal value$3) {
        return value$3;
    }

    public static final String play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$6() {
        return "false";
    }

    public static final /* synthetic */ Either play$api$data$format$Formats$$anon$6$$_$bind$$anonfun$7(String key$7, String x$1) {
        String string = x$1;
        if ("true".equals(string)) {
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if ("false".equals(string)) {
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return package$.MODULE$.Left().apply((Object)((SeqOps)new .colon.colon((Object)FormError$.MODULE$.apply(key$7, "error.boolean", (Seq<Object>)package$.MODULE$.Nil()), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ Date play$api$data$format$Formats$$anon$8$$_$bind$$anonfun$9(LocalDate d) {
        return Date.valueOf(d);
    }

    public static final /* synthetic */ UUID play$api$data$format$Formats$$anon$13$$_$bind$$anonfun$14(String x$0) {
        return UUID.fromString(x$0);
    }
}

