/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import jakarta.inject.Provider;
import java.io.Serializable;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.Configuration;
import play.api.DefaultApplication;
import play.api.Environment;
import play.api.http.DefaultFileMimeTypesProvider;
import play.api.http.DefaultHttpErrorHandler;
import play.api.http.DefaultHttpRequestHandler;
import play.api.http.FileMimeTypes;
import play.api.http.HttpConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpRequestHandler;
import play.api.i18n.I18nComponents;
import play.api.i18n.Langs;
import play.api.i18n.MessagesApi;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.ContextClassLoaderInjector;
import play.api.inject.Injector;
import play.api.inject.NewInstanceInjector$;
import play.api.inject.SimpleInjector;
import play.api.inject.SimpleInjector$;
import play.api.libs.Files;
import play.api.libs.Files$TemporaryFileReaperConfiguration$;
import play.api.libs.concurrent.PekkoComponents;
import play.api.libs.concurrent.PekkoTypedComponents;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CSRFTokenSignerProvider;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.mvc.AnyContent;
import play.api.mvc.BodyParser;
import play.api.mvc.DefaultActionBuilder;
import play.api.mvc.DefaultActionBuilder$;
import play.api.mvc.EssentialFilter;
import play.api.mvc.PlayBodyParsers;
import play.api.mvc.PlayBodyParsers$;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.mvc.request.RequestFactory;
import play.api.routing.Router;
import play.core.DefaultWebCommands;
import play.core.SourceMapper;
import play.core.WebCommands;
import play.core.j.JavaContextComponents;
import play.core.j.JavaHelpers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public interface BuiltInComponents
extends I18nComponents,
PekkoComponents,
PekkoTypedComponents {
    public static void $init$(BuiltInComponents $this) {
        $this.play$api$BuiltInComponents$_setter_$play$api$BuiltInComponents$$defaultWebCommands_$eq(new DefaultWebCommands());
    }

    @Override
    public Environment environment();

    public static Option sourceMapper$(BuiltInComponents $this) {
        return $this.sourceMapper();
    }

    default public Option<SourceMapper> sourceMapper() {
        return this.devContext().map((Function1 & Serializable)_$1 -> _$1.sourceMapper());
    }

    public static Option devContext$(BuiltInComponents $this) {
        return $this.devContext();
    }

    default public Option<ApplicationLoader.DevContext> devContext() {
        return None$.MODULE$;
    }

    public WebCommands play$api$BuiltInComponents$$defaultWebCommands();

    public void play$api$BuiltInComponents$_setter_$play$api$BuiltInComponents$$defaultWebCommands_$eq(WebCommands var1);

    public static WebCommands webCommands$(BuiltInComponents $this) {
        return $this.webCommands();
    }

    default public WebCommands webCommands() {
        return this.play$api$BuiltInComponents$$defaultWebCommands();
    }

    @Override
    public Configuration configuration();

    @Override
    public ApplicationLifecycle applicationLifecycle();

    public Router router();

    public static Injector injector$(BuiltInComponents $this) {
        return $this.injector();
    }

    default public Injector injector() {
        SimpleInjector simple = new SimpleInjector(NewInstanceInjector$.MODULE$, SimpleInjector$.MODULE$.$lessinit$greater$default$2()).$plus(this.cookieSigner(), ClassTag$.MODULE$.apply(CookieSigner.class)).$plus(this.httpConfiguration(), ClassTag$.MODULE$.apply(HttpConfiguration.class)).$plus(this.tempFileCreator(), ClassTag$.MODULE$.apply(Files.TemporaryFileCreator.class)).$plus(this.messagesApi(), ClassTag$.MODULE$.apply(MessagesApi.class)).$plus(this.langs(), ClassTag$.MODULE$.apply(Langs.class));
        return new ContextClassLoaderInjector(simple, this.environment().classLoader());
    }

    public static PlayBodyParsers playBodyParsers$(BuiltInComponents $this) {
        return $this.playBodyParsers();
    }

    default public PlayBodyParsers playBodyParsers() {
        return PlayBodyParsers$.MODULE$.apply(this.tempFileCreator(), this.httpErrorHandler(), this.httpConfiguration().parser(), this.materializer());
    }

    public static BodyParser defaultBodyParser$(BuiltInComponents $this) {
        return $this.defaultBodyParser();
    }

    default public BodyParser<AnyContent> defaultBodyParser() {
        return this.playBodyParsers().default();
    }

    public static DefaultActionBuilder defaultActionBuilder$(BuiltInComponents $this) {
        return $this.defaultActionBuilder();
    }

    default public DefaultActionBuilder defaultActionBuilder() {
        return DefaultActionBuilder$.MODULE$.apply(this.defaultBodyParser(), this.executionContext());
    }

    public static HttpConfiguration httpConfiguration$(BuiltInComponents $this) {
        return $this.httpConfiguration();
    }

    @Override
    default public HttpConfiguration httpConfiguration() {
        return HttpConfiguration$.MODULE$.fromConfiguration(this.configuration(), this.environment());
    }

    public static RequestFactory requestFactory$(BuiltInComponents $this) {
        return $this.requestFactory();
    }

    default public RequestFactory requestFactory() {
        return new DefaultRequestFactory(this.httpConfiguration());
    }

    public static HttpErrorHandler httpErrorHandler$(BuiltInComponents $this) {
        return $this.httpErrorHandler();
    }

    default public HttpErrorHandler httpErrorHandler() {
        return new DefaultHttpErrorHandler(this.environment(), this.configuration(), (Option<SourceMapper>)this.devContext().map((Function1 & Serializable)_$2 -> _$2.sourceMapper()), (Function0<Option<Router>>)((Function0 & Serializable)this::httpErrorHandler$$anonfun$2));
    }

    public Seq<EssentialFilter> httpFilters();

    public static HttpRequestHandler httpRequestHandler$(BuiltInComponents $this) {
        return $this.httpRequestHandler();
    }

    default public HttpRequestHandler httpRequestHandler() {
        return new DefaultHttpRequestHandler(this.webCommands(), this.devContext(), (Provider<Router>)((Provider)() -> this.router()), this.httpErrorHandler(), this.httpConfiguration(), this.httpFilters());
    }

    public static Application application$(BuiltInComponents $this) {
        return $this.application();
    }

    default public Application application() {
        return new DefaultApplication(this.environment(), this.applicationLifecycle(), this.injector(), this.configuration(), this.requestFactory(), this.httpRequestHandler(), this.httpErrorHandler(), this.actorSystem(), this.materializer(), this.coordinatedShutdown());
    }

    public static CookieSigner cookieSigner$(BuiltInComponents $this) {
        return $this.cookieSigner();
    }

    default public CookieSigner cookieSigner() {
        return new CookieSignerProvider(this.httpConfiguration().secret()).get();
    }

    public static CSRFTokenSigner csrfTokenSigner$(BuiltInComponents $this) {
        return $this.csrfTokenSigner();
    }

    default public CSRFTokenSigner csrfTokenSigner() {
        return new CSRFTokenSignerProvider(this.cookieSigner()).get();
    }

    public static Files.TemporaryFileReaper tempFileReaper$(BuiltInComponents $this) {
        return $this.tempFileReaper();
    }

    default public Files.TemporaryFileReaper tempFileReaper() {
        return new Files.DefaultTemporaryFileReaper(this.actorSystem(), Files$TemporaryFileReaperConfiguration$.MODULE$.fromConfiguration(this.configuration()));
    }

    public static Files.TemporaryFileCreator tempFileCreator$(BuiltInComponents $this) {
        return $this.tempFileCreator();
    }

    default public Files.TemporaryFileCreator tempFileCreator() {
        return new Files.DefaultTemporaryFileCreator(this.applicationLifecycle(), this.tempFileReaper(), this.configuration());
    }

    public static FileMimeTypes fileMimeTypes$(BuiltInComponents $this) {
        return $this.fileMimeTypes();
    }

    default public FileMimeTypes fileMimeTypes() {
        return new DefaultFileMimeTypesProvider(this.httpConfiguration().fileMimeTypes()).get();
    }

    public static JavaContextComponents javaContextComponents$(BuiltInComponents $this) {
        return $this.javaContextComponents();
    }

    default public JavaContextComponents javaContextComponents() {
        return JavaHelpers$.MODULE$.createContextComponents(this.messagesApi(), this.langs(), this.fileMimeTypes(), this.httpConfiguration());
    }

    public static DefaultActionBuilder Action$(BuiltInComponents $this) {
        return $this.Action();
    }

    default public DefaultActionBuilder Action() {
        return this.defaultActionBuilder();
    }

    public static PlayBodyParsers parse$(BuiltInComponents $this) {
        return $this.parse();
    }

    default public PlayBodyParsers parse() {
        return this.playBodyParsers();
    }

    private Option httpErrorHandler$$anonfun$2() {
        return Some$.MODULE$.apply((Object)this.router());
    }
}

