/*
 * Decompiled with CFR 0.152.
 */
package play.core.formatters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;
import play.api.mvc.MultipartFormData;
import play.core.formatters.Multipart$;
import scala.runtime.BoxesRunTime;

public final class Multipart {
    public static String escapeParamWithHTML5Strategy(String string) {
        return Multipart$.MODULE$.escapeParamWithHTML5Strategy(string);
    }

    public static Flow<MultipartFormData.Part<Source<ByteString, ?>>, ByteString, NotUsed> format(String string, Charset charset, int n) {
        return Multipart$.MODULE$.format(string, charset, n);
    }

    public static String randomBoundary(int n, Random random) {
        return Multipart$.MODULE$.randomBoundary(n, random);
    }

    public static Source<ByteString, ?> transform(Source<MultipartFormData.Part<Source<ByteString, ?>>, ?> source, String string) {
        return Multipart$.MODULE$.transform(source, string);
    }

    public static int randomBoundary$default$1() {
        return Multipart$.MODULE$.randomBoundary$default$1();
    }

    public static Random randomBoundary$default$2() {
        return Multipart$.MODULE$.randomBoundary$default$2();
    }

    public static class ByteStringFormatter
    implements Formatter {
        private final ByteStringBuilder builder = new ByteStringBuilder();

        public ByteStringFormatter(int sizeHint) {
            this.builder.sizeHint(sizeHint);
        }

        public ByteString get() {
            return this.builder.result();
        }

        @Override
        public ByteStringFormatter $tilde$tilde(char c) {
            this.builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)c)));
            return this;
        }
    }

    public static class CustomCharsetByteStringFormatter
    implements Formatter {
        private final Charset nioCharset;
        private final CharBuffer charBuffer;
        private final ByteStringBuilder builder;

        public CustomCharsetByteStringFormatter(Charset nioCharset, int sizeHint) {
            this.nioCharset = nioCharset;
            this.charBuffer = CharBuffer.allocate(64);
            this.builder = new ByteStringBuilder();
            this.builder.sizeHint(sizeHint);
        }

        public ByteString get() {
            this.flushCharBuffer();
            return this.builder.result();
        }

        @Override
        public CustomCharsetByteStringFormatter $tilde$tilde(char c) {
            if (!this.charBuffer.hasRemaining()) {
                this.flushCharBuffer();
            }
            this.charBuffer.put(c);
            return this;
        }

        public CustomCharsetByteStringFormatter $tilde$tilde(ByteString bytes) {
            if (bytes.nonEmpty()) {
                this.flushCharBuffer();
                this.builder.$plus$plus$eq(bytes);
            }
            return this;
        }

        private void flushCharBuffer() {
            this.charBuffer.flip();
            if (this.charBuffer.hasRemaining()) {
                ByteBuffer byteBuffer = this.nioCharset.encode(this.charBuffer);
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                this.builder.putBytes(bytes);
            }
            this.charBuffer.clear();
        }
    }

    public static interface Formatter {
        public Formatter $tilde$tilde(char var1);

        public static Formatter $tilde$tilde$(Formatter $this, String string) {
            return $this.$tilde$tilde(string);
        }

        default public Formatter $tilde$tilde(String string) {
            return this.rec$1(string, this.rec$default$1$1());
        }

        private Formatter rec$1(String string$1, int ix) {
            while (ix < string$1.length()) {
                this.$tilde$tilde(string$1.charAt(ix));
                ++ix;
            }
            return this;
        }

        private int rec$default$1$1() {
            return 0;
        }
    }
}

