/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.security.SignatureException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Clock;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext;
import play.api.MarkerContext$;
import play.api.MarkerContexts$SecurityMarkerContext$;
import play.api.Mode;
import play.api.http.JWTConfiguration;
import play.api.http.SecretConfiguration;
import play.api.mvc.CookieDataCodec;
import play.api.mvc.JWTCookieDataCodec$;
import play.api.mvc.JWTCookieDataCodec$JWTIDGenerator$;
import play.libs.Scala;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public interface JWTCookieDataCodec
extends CookieDataCodec {
    public static void $init$(JWTCookieDataCodec $this) {
        $this.play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger$.MODULE$.apply($this.getClass()));
    }

    public Logger play$api$mvc$JWTCookieDataCodec$$logger();

    public void play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger var1);

    public SecretConfiguration secretConfiguration();

    public JWTConfiguration jwtConfiguration();

    public static JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter$(JWTCookieDataCodec $this) {
        return $this.play$api$mvc$JWTCookieDataCodec$$formatter();
    }

    default public JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter() {
        return new JWTFormatter(this.secretConfiguration(), this.jwtConfiguration(), this.clock());
    }

    public static String encode$(JWTCookieDataCodec $this, scala.collection.immutable.Map data) {
        return $this.encode((scala.collection.immutable.Map<String, String>)data);
    }

    @Override
    default public String encode(scala.collection.immutable.Map<String, String> data) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.jwtConfiguration().dataClaim());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Jwts.claims(Scala.asJava(data)));
        scala.collection.immutable.Map dataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.play$api$mvc$JWTCookieDataCodec$$formatter().format((scala.collection.immutable.Map<String, Object>)dataMap);
    }

    public static scala.collection.immutable.Map decode$(JWTCookieDataCodec $this, String encodedString) {
        return $this.decode(encodedString);
    }

    @Override
    default public scala.collection.immutable.Map<String, String> decode(String encodedString) {
        scala.collection.immutable.Map map;
        try {
            scala.collection.immutable.Map<String, Object> claimMap = this.play$api$mvc$JWTCookieDataCodec$$formatter().parse(encodedString);
            Map data = (Map)claimMap.apply((Object)this.jwtConfiguration().dataClaim());
            map = CollectionConverters$.MODULE$.MapHasAsScala(data).asScala().view().mapValues((Function1 & Serializable)v -> v.toString()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (IllegalStateException e) {
            this.play$api$mvc$JWTCookieDataCodec$$logger().error(() -> JWTCookieDataCodec.decode$$anonfun$5(e), MarkerContext$.MODULE$.NoMarker());
            map = Predef$.MODULE$.Map().empty();
        }
        catch (PrematureJwtException e) {
            String id = e.getClaims().getId();
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn(() -> JWTCookieDataCodec.decode$$anonfun$6(id, e), (MarkerContext)MarkerContexts$SecurityMarkerContext$.MODULE$);
            map = Predef$.MODULE$.Map().empty();
        }
        catch (ExpiredJwtException e) {
            String id = e.getClaims().getId();
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn(() -> JWTCookieDataCodec.decode$$anonfun$7(id, e), (MarkerContext)MarkerContexts$SecurityMarkerContext$.MODULE$);
            map = Predef$.MODULE$.Map().empty();
        }
        catch (SignatureException e) {
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn(() -> JWTCookieDataCodec.decode$$anonfun$8(e), (MarkerContext)MarkerContexts$SecurityMarkerContext$.MODULE$);
            Logger devLogger = this.play$api$mvc$JWTCookieDataCodec$$logger().forMode((Seq<Mode>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Mode[]{Mode.Dev$.MODULE$}));
            devLogger.info(JWTCookieDataCodec::decode$$anonfun$9, MarkerContext$.MODULE$.NoMarker());
            map = Predef$.MODULE$.Map().empty();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn(() -> JWTCookieDataCodec.decode$$anonfun$10(e), () -> JWTCookieDataCodec.decode$$anonfun$11(e), (MarkerContext)MarkerContexts$SecurityMarkerContext$.MODULE$);
                map = Predef$.MODULE$.Map().empty();
            }
            throw throwable;
        }
        return map;
    }

    public static Option uniqueId$(JWTCookieDataCodec $this) {
        return $this.uniqueId();
    }

    default public Option<String> uniqueId() {
        return Some$.MODULE$.apply((Object)JWTCookieDataCodec$JWTIDGenerator$.MODULE$.generateId());
    }

    public static Clock clock$(JWTCookieDataCodec $this) {
        return $this.clock();
    }

    default public Clock clock() {
        return Clock.systemUTC();
    }

    private static String decode$$anonfun$5(IllegalStateException e$2) {
        return e$2.getMessage();
    }

    private static String decode$$anonfun$6(String id$1, PrematureJwtException e$3) {
        return "decode: premature JWT found! id = " + id$1 + ", message = " + e$3.getMessage();
    }

    private static String decode$$anonfun$7(String id$2, ExpiredJwtException e$4) {
        return "decode: expired JWT found! id = " + id$2 + ", message = " + e$4.getMessage();
    }

    private static String decode$$anonfun$8(SignatureException e$5) {
        return "decode: cookie has invalid signature! message = " + e$5.getMessage();
    }

    private static String decode$$anonfun$9() {
        return "The JWT signature in the cookie does not match the locally computed signature with the server. This usually indicates the browser has a leftover cookie from another Play application, so clearing cookies may resolve this error message.";
    }

    private static String decode$$anonfun$10(Throwable e$6) {
        return "decode: could not decode JWT: " + e$6.getMessage();
    }

    private static Throwable decode$$anonfun$11(Throwable e$7) {
        return e$7;
    }

    public static class JWTFormatter {
        private final JWTConfiguration jwtConfiguration;
        public final Clock play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock;
        private final io.jsonwebtoken.Clock jwtClock;
        private final SignatureAlgorithm signatureAlgorithm;
        private final SecretKey secretKey;
        private final JwtParser jwtParser;

        public JWTFormatter(SecretConfiguration secretConfiguration, JWTConfiguration jwtConfiguration, Clock clock) {
            this.jwtConfiguration = jwtConfiguration;
            this.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock = clock;
            this.jwtClock = new io.jsonwebtoken.Clock(this){
                private final /* synthetic */ JWTFormatter $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Date now() {
                    return Date.from(this.$outer.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock.instant());
                }
            };
            this.signatureAlgorithm = SignatureAlgorithm.forName((String)jwtConfiguration.signatureAlgorithm());
            this.secretKey = new SecretKeySpec(secretConfiguration.secret().getBytes(StandardCharsets.UTF_8), this.signatureAlgorithm.getJcaName());
            this.jwtParser = ((JwtParserBuilder)Classes.newInstance((String)"io.jsonwebtoken.impl.DefaultJwtParserBuilder")).setClock(this.jwtClock).setSigningKey((Key)this.secretKey).setAllowedClockSkewSeconds(jwtConfiguration.clockSkew().toSeconds()).deserializeJsonWith((Deserializer)new JacksonDeserializer(JWTCookieDataCodec$.play$api$mvc$JWTCookieDataCodec$$$objectMapper)).build();
        }

        public scala.collection.immutable.Map<String, Object> parse(String encodedString) {
            String headerAlgorithm;
            Jws jws;
            try {
                jws = this.jwtParser.parseClaimsJws(encodedString);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                jws = (Jws)JwtParser.class.getDeclaredMethod("parseClaimsJws", CharSequence.class).invoke((Object)this.jwtParser, encodedString);
            }
            Jws jws2 = jws;
            String string = headerAlgorithm = ((JwsHeader)jws2.getHeader()).getAlgorithm();
            String string2 = this.jwtConfiguration.signatureAlgorithm();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String id = ((Claims)jws2.getBody()).getId();
                String msg = "Invalid header algorithm " + headerAlgorithm + " in JWT " + id;
                throw new IllegalStateException(msg);
            }
            return CollectionConverters$.MODULE$.MapHasAsScala((Map)jws2.getBody()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public String format(scala.collection.immutable.Map<String, Object> claims) {
            Object object;
            Object object2;
            JwtBuilder builder = Jwts.builder().serializeToJsonWith((Serializer)new JacksonSerializer(JWTCookieDataCodec$.play$api$mvc$JWTCookieDataCodec$$$objectMapper));
            Date now = this.jwtClock.now();
            claims.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return builder.claim(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            this.jwtConfiguration.expiresAfter().map((Function1 & Serializable)duration -> {
                Date expirationDate = new Date(now.getTime() + duration.toMillis());
                return builder.setExpiration(expirationDate);
            });
            try {
                object2 = builder.setNotBefore(now);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object2 = JwtBuilder.class.getDeclaredMethod("notBefore", Date.class).invoke((Object)builder, now);
            }
            try {
                object = builder.setIssuedAt(now);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object = JwtBuilder.class.getDeclaredMethod("issuedAt", Date.class).invoke((Object)builder, now);
            }
            return builder.signWith((Key)this.secretKey, this.signatureAlgorithm).compact();
        }
    }
}

