/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import play.core.utils.AsciiBitSet;
import play.core.utils.AsciiSet;
import play.core.utils.AsciiSet$;
import play.core.utils.AsciiSet$Sets$;
import play.core.utils.AsciiUnion;
import play.utils.InvalidUriEncodingException;
import scala.Byte$;
import scala.Char$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class UriEncoding$
implements Serializable {
    private static final AsciiBitSet segmentChars;
    public static final UriEncoding$ MODULE$;

    private UriEncoding$() {
    }

    static {
        MODULE$ = new UriEncoding$();
        segmentChars = MODULE$.pchar().toBitSet();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UriEncoding$.class);
    }

    public String encodePathSegment(String s, String inputCharset) {
        byte[] in = s.getBytes(inputCharset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object object = Predef$.MODULE$.byteArrayOps(in);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)v1 -> {
            this.encodePathSegment$$anonfun$1(out, BoxesRunTime.unboxToByte((Object)v1));
            return BoxedUnit.UNIT;
        });
        return out.toString("US-ASCII");
    }

    public String encodePathSegment(String s, Charset inputCharset) {
        return this.encodePathSegment(s, inputCharset.name());
    }

    public String decodePathSegment(String s, String outputCharset) {
        byte[] in = s.getBytes("US-ASCII");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IntRef inPos = IntRef.create((int)0);
        while (inPos.elem < in.length) {
            int b = this.next$1(in, inPos);
            if (b == 37) {
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException("Cannot decode " + s + ": % at end of string");
                }
                int high = this.fromHex(this.next$1(in, inPos));
                if (high == -1) {
                    throw new InvalidUriEncodingException("Cannot decode " + s + ": expected hex digit at position " + inPos.elem + ".");
                }
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException("Cannot decode " + s + ": incomplete percent encoding at end of string");
                }
                int low = this.fromHex(this.next$1(in, inPos));
                if (low == -1) {
                    throw new InvalidUriEncodingException("Cannot decode " + s + ": expected hex digit at position " + inPos.elem + ".");
                }
                out.write((high << 4) + low);
                continue;
            }
            if (segmentChars.get(b)) {
                out.write(b);
                continue;
            }
            throw new InvalidUriEncodingException("Cannot decode " + s + ": illegal character at position " + inPos.elem + ".");
        }
        return out.toString(outputCharset);
    }

    public String decodePathSegment(String s, Charset outputCharset) {
        return this.decodePathSegment(s, outputCharset.name());
    }

    public String decodePath(String s, String outputCharset) {
        return ((IterableOnceOps)this.splitString(s, '/').map((Function1 & Serializable)_$1 -> this.decodePathSegment((String)_$1, outputCharset))).mkString("/");
    }

    public String decodePath(String s, Charset outputCharset) {
        return this.decodePath(s, outputCharset.name());
    }

    private AsciiSet pchar() {
        AsciiUnion unreserved = AsciiSet$Sets$.MODULE$.AlphaDigit().$bar$bar$bar(AsciiSet$.MODULE$.apply('-', (Seq<Object>)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'.', '_', '~'})));
        AsciiSet subDelims = AsciiSet$.MODULE$.apply('!', (Seq<Object>)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'$', '&', '\'', '(', ')', '*', '+', ',', ';', '='}));
        return unreserved.$bar$bar$bar(subDelims).$bar$bar$bar(AsciiSet$.MODULE$.apply(':', (Seq<Object>)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'@'})));
    }

    private int upperHex(int x) {
        if (x < 10) {
            return x + 48;
        }
        return x - 10 + 65;
    }

    private int fromHex(int b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 90) {
            return 10 + b - 65;
        }
        if (b >= 97 && b <= 122) {
            return 10 + b - 97;
        }
        return -1;
    }

    public Seq<String> splitString(String s, char c) {
        Builder result = List$.MODULE$.newBuilder();
        this.splitLoop$1(s, c, result, 0);
        return (Seq)result.result();
    }

    private final /* synthetic */ void encodePathSegment$$anonfun$1(ByteArrayOutputStream out$1, byte b) {
        boolean allowed = segmentChars.get(b & 0xFF);
        if (allowed) {
            out$1.write(Byte$.MODULE$.byte2int(b));
            return;
        }
        out$1.write(37);
        out$1.write(this.upperHex(b >> 4 & 0xF));
        out$1.write(this.upperHex(b & 0xF));
    }

    private final int next$1(byte[] in$1, IntRef inPos$1) {
        int n;
        int b = in$1[inPos$1.elem] & 0xFF;
        inPos$1.elem = n = inPos$1.elem + 1;
        return b;
    }

    private final void splitLoop$1(String s$1, char c$1, Builder result$1, int start) {
        while (start < s$1.length()) {
            int end = s$1.indexOf(Char$.MODULE$.char2int(c$1), start);
            if (end == -1) {
                result$1.$plus$eq((Object)s$1.substring(start));
                return;
            }
            result$1.$plus$eq((Object)s$1.substring(start, end));
            start = end + 1;
        }
        if (start == s$1.length()) {
            result$1.$plus$eq((Object)"");
            return;
        }
    }
}

