/*
 * Decompiled with CFR 0.152.
 */
package play.core.parsers;

import java.io.Serializable;
import java.nio.file.Files;
import java.util.Locale;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.SubFlow;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.HttpErrorHandler;
import play.api.http.Status$;
import play.api.libs.Files;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.BodyParser;
import play.api.mvc.BodyParser$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.MultipartFormData$;
import play.api.mvc.MultipartFormData$FilePart$;
import play.api.mvc.MultipartFormData$MaxMemoryBufferExceeded$;
import play.api.mvc.MultipartFormData$ParseError$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.core.Execution$Implicits$;
import play.core.parsers.Multipart;
import play.core.parsers.Multipart$FileInfo$;
import play.core.parsers.Multipart$FileInfoMatcher$;
import play.core.parsers.Multipart$NotEnoughDataException$;
import play.core.parsers.Multipart$PartInfoMatcher$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class Multipart$
implements Serializable {
    public static final Regex play$core$parsers$Multipart$$$KeyValue;
    public static final Regex play$core$parsers$Multipart$$$ExtendedKeyValue;
    public static final Multipart$FileInfo$ FileInfo;
    public static final Multipart$FileInfoMatcher$ FileInfoMatcher;
    public static final Multipart$PartInfoMatcher$ PartInfoMatcher;
    public static final Multipart$NotEnoughDataException$ play$core$parsers$Multipart$$$NotEnoughDataException;
    public static final ByteString play$core$parsers$Multipart$$$crlfcrlf;
    public static final Multipart$ MODULE$;

    private Multipart$() {
    }

    static {
        MODULE$ = new Multipart$();
        int maxHeaderBuffer = 4096;
        play$core$parsers$Multipart$$$KeyValue = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-zA-Z_0-9]+)=\"?(.*?)\"?$"));
        play$core$parsers$Multipart$$$ExtendedKeyValue = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-zA-Z_0-9]+)\\*=(.*?)'.*'(.*?)$"));
        play$core$parsers$Multipart$$$crlfcrlf = ByteString$.MODULE$.apply("\r\n\r\n");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Multipart$.class);
    }

    public <A> BodyParser<A> partParser(long maxMemoryBufferSize, HttpErrorHandler errorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> partHandler, Materializer mat) {
        return this.partParser(maxMemoryBufferSize, false, errorHandler, partHandler, mat);
    }

    public <A> BodyParser<A> partParser(long maxMemoryBufferSize, boolean allowEmptyFiles, HttpErrorHandler errorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> partHandler, Materializer mat) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> {
            Option maybeBoundary = request.mediaType().flatMap((Function1 & Serializable)mt -> mt.parameters().find((Function1 & Serializable)_$1 -> ((String)_$1._1()).equalsIgnoreCase("boundary")).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Option value = (Option)tuple2._2();
                    return true;
                }
                return false;
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Option value = (Option)tuple2._2();
                    return value.map((Function1 & Serializable)boundary -> boundary);
                }
                throw new MatchError((Object)tuple2);
            }));
            return (Accumulator)maybeBoundary.map((Function1 & Serializable)boundary -> {
                Flow multipartFlow = (Flow)((SubFlow)Flow$.MODULE$.apply().via((Graph)new Multipart.BodyPartParser((String)boundary, maxMemoryBufferSize, 4096, allowEmptyFiles)).splitWhen((Function1 & Serializable)_$2 -> _$2.isLeft()).prefixAndTail(1).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Either either;
                        SeqOps seqOps;
                        Seq seq = (Seq)tuple2._1();
                        Source source = (Source)tuple2._2();
                        if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 1) == 0 && (either = (Either)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof Left) {
                            MultipartFormData.Part part = (MultipartFormData.Part)((Left)either).value();
                            if (part instanceof MultipartFormData.FilePart) {
                                MultipartFormData.FilePart part2 = (MultipartFormData.FilePart)part;
                                Source body = source;
                                Source source2 = (Source)body.collect((PartialFunction)new Serializable(){

                                    public final boolean isDefinedAt(Either x) {
                                        Either either = x;
                                        if (either instanceof Right) {
                                            ByteString bytes = (ByteString)((Right)either).value();
                                            return true;
                                        }
                                        return false;
                                    }

                                    public final Object applyOrElse(Either x, Function1 function1) {
                                        Either either = x;
                                        if (either instanceof Right) {
                                            ByteString bytes = (ByteString)((Right)either).value();
                                            return bytes;
                                        }
                                        return function1.apply((Object)x);
                                    }
                                });
                                Function1 & Serializable intersect = (Function1 & Serializable)byteSource -> Some$.MODULE$.apply(Await$.MODULE$.result((Awaitable)byteSource.runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(_$3, _$4) -> _$3.$plus$plus(_$4), mat), (Duration)Duration$.MODULE$.Inf()));
                                String string = part2.copy$default$1();
                                String string2 = part2.copy$default$2();
                                Option<String> option = part2.copy$default$3();
                                long l = part2.copy$default$5();
                                String string3 = part2.copy$default$6();
                                return part2.copy(string, string2, option, source2, l, string3, intersect);
                            }
                            MultipartFormData.Part other = part;
                            Source ignored = source;
                            ignored.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
                            return other;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })).concatSubstreams();
                return partHandler.through(multipartFlow);
            }).getOrElse(() -> this.partParser$$anonfun$1$$anonfun$2(errorHandler, request));
        });
    }

    public <A> BodyParser<MultipartFormData<A>> multipartParser(long maxMemoryBufferSize, Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, HttpErrorHandler errorHandler, Materializer mat) {
        return this.multipartParser(maxMemoryBufferSize, false, filePartHandler, errorHandler, mat);
    }

    public <A> BodyParser<MultipartFormData<A>> multipartParser(long maxMemoryBufferSize, boolean allowEmptyFiles, Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, HttpErrorHandler errorHandler, Materializer mat) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> {
            Flow handleFileParts = (Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable)x$1 -> {
                MultipartFormData.Part part = x$1;
                if (part instanceof MultipartFormData.FilePart) {
                    MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                    return ((Accumulator)filePartHandler.apply((Object)Multipart$FileInfo$.MODULE$.apply(filePart.key(), filePart.filename(), filePart.contentType(), filePart.dispositionType()))).run((Source)filePart.ref(), mat);
                }
                if (part instanceof MultipartFormData.Part) {
                    MultipartFormData.Part other = part;
                    return Future$.MODULE$.successful((Object)other);
                }
                throw new MatchError((Object)part);
            });
            Accumulator multipartAccumulator = Accumulator$.MODULE$.apply(Sink$.MODULE$.fold((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable)(_$5, _$6) -> (Seq)_$5.$colon$plus(_$6))).mapFuture((Function1 & Serializable)parts -> (Future)this.parseError$1((Seq)parts, errorHandler, (RequestHeader)request).orElse(() -> this.$anonfun$7$$anonfun$1(parts, errorHandler, request)).getOrElse(() -> this.$anonfun$7$$anonfun$2(parts)), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            return (Accumulator)this.partParser(maxMemoryBufferSize, allowEmptyFiles, errorHandler, multipartAccumulator.through(handleFileParts), mat).apply(request);
        });
    }

    public Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<Files.TemporaryFile>>> handleFilePartAsTemporaryFile(Files.TemporaryFileCreator temporaryFileCreator) {
        return (Function1 & Serializable)x$12 -> {
            Multipart.FileInfo fileInfo = x$12;
            if (fileInfo != null) {
                Multipart.FileInfo fileInfo2 = Multipart$FileInfo$.MODULE$.unapply(fileInfo);
                String string = fileInfo2._1();
                String string2 = fileInfo2._2();
                Option<String> option = fileInfo2._3();
                String string3 = fileInfo2._4();
                String partName = string;
                String filename = string2;
                Option<String> contentType = option;
                String dispositionType = string3;
                Files.TemporaryFile tempFile = temporaryFileCreator.create("multipartBody", "asTemporaryFile");
                return Accumulator$.MODULE$.apply(FileIO$.MODULE$.toPath(tempFile.path(), FileIO$.MODULE$.toPath$default$2())).mapFuture((Function1 & Serializable)x$1 -> {
                    IOResult iOResult = x$1;
                    if (iOResult != null) {
                        IOResult iOResult2 = iOResult;
                        IOResult r = iOResult2;
                        if (r.status().isFailure()) {
                            return Future$.MODULE$.failed((Throwable)r.status().failed().get());
                        }
                        IOResult r2 = iOResult2;
                        if (r2.status().isSuccess()) {
                            return Future$.MODULE$.successful(MultipartFormData$FilePart$.MODULE$.apply(partName, filename, contentType, tempFile, r2.count(), dispositionType, (Function1 & Serializable)tf -> Some$.MODULE$.apply((Object)ByteString$.MODULE$.fromArray(Files.readAllBytes(tf.path())))));
                        }
                    }
                    throw new MatchError((Object)iOResult);
                }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            throw new MatchError((Object)fileInfo);
        };
    }

    public <A> Function1<RequestHeader, Future<Either<Result, A>>> play$core$parsers$Multipart$$$createBadResult(String msg, int status, HttpErrorHandler errorHandler) {
        return (Function1 & Serializable)request -> errorHandler.onClientError((RequestHeader)request, status, msg).map((Function1 & Serializable)_$14 -> package$.MODULE$.Left().apply(_$14), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
    }

    public int play$core$parsers$Multipart$$$createBadResult$default$2() {
        return Status$.MODULE$.BAD_REQUEST();
    }

    public char play$core$parsers$Multipart$$$byteChar(ByteString input2, int ix) {
        return (char)this.play$core$parsers$Multipart$$$byteAt(input2, ix);
    }

    public byte play$core$parsers$Multipart$$$byteAt(ByteString input2, int ix) {
        if (ix < input2.length()) {
            return input2.apply(ix);
        }
        throw Multipart$NotEnoughDataException$.MODULE$;
    }

    private final Accumulator partParser$$anonfun$1$$anonfun$2(HttpErrorHandler errorHandler$2, RequestHeader request$1) {
        return Accumulator$.MODULE$.done((Future)this.play$core$parsers$Multipart$$$createBadResult("Missing boundary header", this.play$core$parsers$Multipart$$$createBadResult$default$2(), errorHandler$2).apply((Object)request$1));
    }

    private final Option parseError$1(Seq parts$1, HttpErrorHandler errorHandler$4, RequestHeader request$2) {
        return parts$1.collectFirst((PartialFunction)new Serializable(errorHandler$4, request$2){
            private final HttpErrorHandler errorHandler$6;
            private final RequestHeader request$4;
            {
                this.errorHandler$6 = errorHandler$10;
                this.request$4 = request$7;
            }

            public final boolean isDefinedAt(MultipartFormData.Part x) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.ParseError) {
                    String string;
                    MultipartFormData.ParseError parseError = MultipartFormData$ParseError$.MODULE$.unapply((MultipartFormData.ParseError)part);
                    String msg = string = parseError._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MultipartFormData.Part x, Function1 function1) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.ParseError) {
                    String string;
                    MultipartFormData.ParseError parseError = MultipartFormData$ParseError$.MODULE$.unapply((MultipartFormData.ParseError)part);
                    String msg = string = parseError._1();
                    return Multipart$.MODULE$.play$core$parsers$Multipart$$$createBadResult(msg, Multipart$.MODULE$.play$core$parsers$Multipart$$$createBadResult$default$2(), this.errorHandler$6).apply((Object)this.request$4);
                }
                return function1.apply((Object)x);
            }
        });
    }

    private final Option bufferExceededError$1(Seq parts$2, HttpErrorHandler errorHandler$7, RequestHeader request$5) {
        return parts$2.collectFirst((PartialFunction)new Serializable(errorHandler$7, request$5){
            private final HttpErrorHandler errorHandler$8;
            private final RequestHeader request$6;
            {
                this.errorHandler$8 = errorHandler$11;
                this.request$6 = request$8;
            }

            public final boolean isDefinedAt(MultipartFormData.Part x) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.MaxMemoryBufferExceeded) {
                    String string;
                    MultipartFormData.MaxMemoryBufferExceeded maxMemoryBufferExceeded = MultipartFormData$MaxMemoryBufferExceeded$.MODULE$.unapply((MultipartFormData.MaxMemoryBufferExceeded)part);
                    String msg = string = maxMemoryBufferExceeded._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MultipartFormData.Part x, Function1 function1) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.MaxMemoryBufferExceeded) {
                    String string;
                    MultipartFormData.MaxMemoryBufferExceeded maxMemoryBufferExceeded = MultipartFormData$MaxMemoryBufferExceeded$.MODULE$.unapply((MultipartFormData.MaxMemoryBufferExceeded)part);
                    String msg = string = maxMemoryBufferExceeded._1();
                    return Multipart$.MODULE$.play$core$parsers$Multipart$$$createBadResult(msg, Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE(), this.errorHandler$8).apply((Object)this.request$6);
                }
                return function1.apply((Object)x);
            }
        });
    }

    private final Option $anonfun$7$$anonfun$1(Seq parts$4, HttpErrorHandler errorHandler$12, RequestHeader request$9) {
        return this.bufferExceededError$1(parts$4, errorHandler$12, request$9);
    }

    private final Future $anonfun$7$$anonfun$2(Seq parts$3) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply(MultipartFormData$.MODULE$.apply((Map<String, Seq<String>>)((Map)((IterableOps)parts$3.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(MultipartFormData.Part x) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.DataPart) {
                    MultipartFormData.DataPart dp = (MultipartFormData.DataPart)part;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MultipartFormData.Part x, Function1 function1) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.DataPart) {
                    MultipartFormData.DataPart dp = (MultipartFormData.DataPart)part;
                    return dp;
                }
                return function1.apply((Object)x);
            }
        })).groupBy((Function1 & Serializable)_$7 -> _$7.key()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Seq partValues = (Seq)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, partValues.map((Function1 & Serializable)_$8 -> _$8.value()));
            }
            throw new MatchError((Object)tuple2);
        })), (Seq)parts$3.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(MultipartFormData.Part x) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.FilePart) {
                    MultipartFormData.FilePart fp = (MultipartFormData.FilePart)part;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MultipartFormData.Part x, Function1 function1) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.FilePart) {
                    MultipartFormData.FilePart fp = (MultipartFormData.FilePart)part;
                    return fp;
                }
                return function1.apply((Object)x);
            }
        }), (Seq<MultipartFormData.BadPart>)((Seq)parts$3.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(MultipartFormData.Part x) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.BadPart) {
                    MultipartFormData.BadPart bad = (MultipartFormData.BadPart)part;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MultipartFormData.Part x, Function1 function1) {
                MultipartFormData.Part part = x;
                if (part instanceof MultipartFormData.BadPart) {
                    MultipartFormData.BadPart bad = (MultipartFormData.BadPart)part;
                    return bad;
                }
                return function1.apply((Object)x);
            }
        })))));
    }

    public static final /* synthetic */ Tuple2 play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$_$$anonfun$8(String header) {
        List list = Predef$.MODULE$.wrapRefArray((Object[])header.trim().split(":")).toList();
        if (!(list instanceof .colon.colon)) {
            throw new MatchError((Object)list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        List list2 = colon2.next$access$1();
        String key = (String)colon2.head();
        List value = list2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)key, (Object)value);
        String key2 = (String)tuple2._1();
        List value2 = (List)tuple2._2();
        return Tuple2$.MODULE$.apply((Object)key2.trim().toLowerCase(Locale.ENGLISH), (Object)value2.mkString(":").trim());
    }

    private static final /* synthetic */ int headersSize$1$$anonfun$1(int total, Tuple2 value) {
        return total + ((String)value._1()).length() + ((String)value._2()).length();
    }

    public static final int play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$headersSize$1(Map headers$5) {
        return BoxesRunTime.unboxToInt((Object)headers$5.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(total, value) -> Multipart$.headersSize$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)total), (Tuple2)value)));
    }

    public static final /* synthetic */ Option play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$handleFilePart$$anonfun$1(Object _$18) {
        return None$.MODULE$;
    }

    public static final Multipart.BodyPartParser.StateResult play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$1$$anonfun$1(Function2 next$2, ByteString input$10, ByteString more$2, int offset$2) {
        return (Multipart.BodyPartParser.StateResult)next$2.apply((Object)input$10.$plus$plus(more$2), (Object)BoxesRunTime.boxToInteger((int)offset$2));
    }

    public static final Multipart.BodyPartParser.StateResult play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$2$$anonfun$1(Function2 next$4, ByteString more$3) {
        return (Multipart.BodyPartParser.StateResult)next$4.apply((Object)more$3, (Object)BoxesRunTime.boxToInteger((int)0));
    }
}

