/*
 * Decompiled with CFR 0.152.
 */
package play.core;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import play.core.NamedThreadFactory$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class NamedThreadFactory
implements ThreadFactory,
Product,
Serializable {
    private final String name;
    private final AtomicInteger threadNo;
    private final ThreadFactory backingThreadFactory;

    public static NamedThreadFactory apply(String string) {
        return NamedThreadFactory$.MODULE$.apply(string);
    }

    public static NamedThreadFactory fromProduct(Product product) {
        return NamedThreadFactory$.MODULE$.fromProduct(product);
    }

    public static NamedThreadFactory unapply(NamedThreadFactory namedThreadFactory) {
        return NamedThreadFactory$.MODULE$.unapply(namedThreadFactory);
    }

    public NamedThreadFactory(String name) {
        this.name = name;
        this.threadNo = new AtomicInteger();
        this.backingThreadFactory = Executors.defaultThreadFactory();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NamedThreadFactory)) return false;
        NamedThreadFactory namedThreadFactory = (NamedThreadFactory)object;
        String string = this.name();
        String string2 = namedThreadFactory.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!namedThreadFactory.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NamedThreadFactory;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "NamedThreadFactory";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "name";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String name() {
        return this.name;
    }

    public AtomicInteger threadNo() {
        return this.threadNo;
    }

    public ThreadFactory backingThreadFactory() {
        return this.backingThreadFactory;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.backingThreadFactory().newThread(r);
        thread.setName(this.name() + "-" + this.threadNo().incrementAndGet());
        return thread;
    }

    public NamedThreadFactory copy(String name) {
        return new NamedThreadFactory(name);
    }

    public String copy$default$1() {
        return this.name();
    }

    public String _1() {
        return this.name();
    }
}

