/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.concurrent;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.BootstrapSetup;
import org.apache.pekko.actor.BootstrapSetup$;
import org.apache.pekko.actor.setup.ActorSystemSetup;
import org.apache.pekko.actor.setup.ActorSystemSetup$;
import org.apache.pekko.actor.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.libs.concurrent.ActorSystemProvider;
import play.api.libs.concurrent.ActorSystemProvider$ApplicationShutdownReason$;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class ActorSystemProvider$
implements Serializable {
    private static final Logger logger;
    public static final ActorSystemProvider$ApplicationShutdownReason$ ApplicationShutdownReason;
    public static final ActorSystemProvider$ MODULE$;

    private ActorSystemProvider$() {
    }

    static {
        MODULE$ = new ActorSystemProvider$();
        logger = LoggerFactory.getLogger(ActorSystemProvider.class);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ActorSystemProvider$.class);
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config) {
        return this.start(classLoader, config, (Seq<Setup>)package$.MODULE$.Nil());
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Setup additionalSetup) {
        return this.start(classLoader, config, (Seq<Setup>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Setup[]{additionalSetup}))));
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Seq<Setup> additionalSetups) {
        String exitJvmPath = "pekko.coordinated-shutdown.exit-jvm";
        if (BoxesRunTime.unboxToBoolean((Object)config.get(exitJvmPath, ConfigLoader$.MODULE$.booleanLoader()))) {
            String errorMessage = "Can't start Play: detected \"" + exitJvmPath + " = on\". " + ("Using \"" + exitJvmPath + " = on\" in Play may cause a deadlock when shutting down. ") + ("Please set \"" + exitJvmPath + " = off\"");
            logger.error(errorMessage);
            throw config.reportError(exitJvmPath, errorMessage, config.reportError$default$3());
        }
        String playTimeoutKey = "play.pekko.shutdown-timeout";
        Duration playTimeoutDuration = (Duration)Try$.MODULE$.apply(() -> this.$anonfun$1(config, playTimeoutKey)).getOrElse(this::$anonfun$2);
        int pekkoMaxDelay = 2147483;
        FiniteDuration pekkoMaxDuration = Duration$.MODULE$.apply(Int$.MODULE$.int2long(pekkoMaxDelay), "seconds");
        Duration normalisedDuration = playTimeoutDuration.min((Duration)pekkoMaxDuration);
        java.time.Duration pekkoTimeoutDuration = java.time.Duration.ofMillis(normalisedDuration.toMillis());
        String pekkoTimeoutKey = "pekko.coordinated-shutdown.phases.actor-system-terminate.timeout";
        Config pekkoConfig = config.underlying().withValue(pekkoTimeoutKey, ConfigValueFactory.fromAnyRef((Object)pekkoTimeoutDuration));
        String name = (String)config.get("play.pekko.actor-system", ConfigLoader$.MODULE$.stringLoader());
        BootstrapSetup bootstrapSetup = BootstrapSetup$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)classLoader), (Option)Some$.MODULE$.apply((Object)pekkoConfig), (Option)None$.MODULE$);
        ActorSystemSetup actorSystemSetup = ActorSystemSetup$.MODULE$.apply((Seq)additionalSetups.$plus$colon((Object)bootstrapSetup));
        logger.debug("Starting application default Pekko system: " + name);
        return ActorSystem$.MODULE$.apply(name, actorSystemSetup);
    }

    private final Duration $anonfun$1(Configuration config$1, String playTimeoutKey$1) {
        return (Duration)config$1.get(playTimeoutKey$1, ConfigLoader$.MODULE$.durationLoader());
    }

    private final Duration $anonfun$2() {
        return Duration$.MODULE$.Inf();
    }
}

