/*
 * Decompiled with CFR 0.152.
 */
package play.api.data;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.data.Field;
import play.api.data.Field$;
import play.api.data.Form$;
import play.api.data.FormBinding;
import play.api.data.FormError;
import play.api.data.FormError$;
import play.api.data.FormUtils$;
import play.api.data.Mapping;
import play.api.data.validation.Constraint;
import play.api.data.validation.Constraint$;
import play.api.i18n.Messages;
import play.api.i18n.MessagesProvider;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.Request;
import play.api.templates.PlayMagic$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapView;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Form<T>
implements Product,
Serializable {
    private final Mapping mapping;
    private final Map data;
    private final Seq errors;
    private final Option value;
    private final Logger logger;
    private final Map constraints;
    private final Map formats;

    public static long FromJsonMaxChars() {
        return Form$.MODULE$.FromJsonMaxChars();
    }

    public static int FromJsonMaxDepth() {
        return Form$.MODULE$.FromJsonMaxDepth();
    }

    public static Form<?> fromProduct(Product product) {
        return Form$.MODULE$.fromProduct(product);
    }

    public static <T> Form<T> unapply(Form<T> form2) {
        return Form$.MODULE$.unapply(form2);
    }

    public Form(Mapping<T> mapping, Map<String, String> data, Seq<FormError> errors, Option<T> value) {
        this.mapping = mapping;
        this.data = data;
        this.errors = errors;
        this.value = value;
        this.logger = LoggerFactory.getLogger(Form.class);
        this.constraints = mapping.mappings().iterator().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Mapping x) {
                Mapping mapping = x;
                Mapping m = mapping;
                return m.constraints().nonEmpty();
            }

            public final Object applyOrElse(Mapping x, Function1 function1) {
                Mapping mapping = x;
                Mapping m = mapping;
                if (m.constraints().nonEmpty()) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)m.key());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, m.constraints().collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Constraint x) {
                            Constraint constraint = x;
                            if (constraint != null) {
                                Constraint<T> constraint2 = Constraint$.MODULE$.unapply(constraint);
                                Option<String> option = constraint2._1();
                                Seq<Object> seq = constraint2._2();
                                if (option instanceof Some) {
                                    String name = (String)((Some)option).value();
                                    Seq<Object> args = seq;
                                    return true;
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Constraint x, Function1 function1) {
                            Constraint constraint = x;
                            if (constraint != null) {
                                Constraint<T> constraint2 = Constraint$.MODULE$.unapply(constraint);
                                Option<String> option = constraint2._1();
                                Seq<Object> seq = constraint2._2();
                                if (option instanceof Some) {
                                    String name = (String)((Some)option).value();
                                    Seq<Object> args = seq;
                                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, args);
                                }
                            }
                            return function1.apply((Object)x);
                        }
                    }));
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.formats = mapping.mappings().iterator().flatMap((Function1 & Serializable)m -> m.format().map((Function1 & Serializable)fmt -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)m.key());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, fmt);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Form)) return false;
        Form form2 = (Form)object;
        Mapping<T> mapping = this.mapping();
        Mapping<T> mapping2 = form2.mapping();
        if (mapping == null) {
            if (mapping2 != null) {
                return false;
            }
        } else if (!mapping.equals(mapping2)) return false;
        Map<String, String> map = this.data();
        Map<String, String> map2 = form2.data();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Seq<FormError> seq = this.errors();
        Seq<FormError> seq2 = form2.errors();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<T> option = this.value();
        Option<T> option2 = form2.value();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!form2.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Form;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Form";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "mapping";
            }
            case 1: {
                return "data";
            }
            case 2: {
                return "errors";
            }
            case 3: {
                return "value";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Mapping<T> mapping() {
        return this.mapping;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public Seq<FormError> errors() {
        return this.errors;
    }

    public Option<T> value() {
        return this.value;
    }

    public Map<String, Seq<Tuple2<String, Seq<Object>>>> constraints() {
        return this.constraints;
    }

    public Map<String, Tuple2<String, Seq<Object>>> formats() {
        return this.formats;
    }

    public Form<T> bind(Map<String, String> data) {
        return (Form)this.mapping().bind(data).fold((Function1 & Serializable)newErrors -> {
            Seq seq = (Seq)this.errors().$plus$plus((IterableOnce)newErrors);
            None$ none$ = None$.MODULE$;
            Mapping<T> mapping = this.copy$default$1();
            return this.copy(mapping, data, (Seq<FormError>)seq, (Option<T>)none$);
        }, (Function1 & Serializable)value -> {
            Some some = Some$.MODULE$.apply(value);
            Mapping<T> mapping = this.copy$default$1();
            return this.copy(mapping, data, this.errors(), (Option<T>)some);
        });
    }

    public Form<T> bind(JsValue data) {
        this.logger.warn("Binding json field from form with a hardcoded max size of " + Form$.MODULE$.FromJsonMaxChars() + " bytes. This is deprecated. Use bind(JsValue, Int) instead.");
        return this.bind(FormUtils$.MODULE$.fromJson(data, Form$.MODULE$.FromJsonMaxChars(), Form$.MODULE$.FromJsonMaxDepth()));
    }

    public Form<T> bind(JsValue data, long maxChars) {
        return this.bind(FormUtils$.MODULE$.fromJson(data, maxChars, Form$.MODULE$.FromJsonMaxDepth()));
    }

    public Form<T> bind(JsValue data, long maxChars, int maxDepth) {
        return this.bind(FormUtils$.MODULE$.fromJson(data, maxChars, maxDepth));
    }

    public Form<T> bindFromRequest(Request<?> request, FormBinding formBinding) {
        return this.bindFromRequest(formBinding.apply(request));
    }

    public Form<T> bindFromRequest(Map<String, Seq<String>> data) {
        Map map = (Map)data.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Map s = (Map)tuple2._1();
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    Seq values = (Seq)tuple22._2();
                    if (key.endsWith("[]")) {
                        String k = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(key), 2);
                        return (Map)s.$plus$plus((IterableOnce)((IterableOps)values.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String v = (String)tuple2._1();
                                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)(k + "[" + i + "]"));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
                            }
                            throw new MatchError((Object)tuple2);
                        }));
                    }
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                    return (Map)s.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, values.headOption().getOrElse(Form::$anonfun$1$$anonfun$2)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return this.bind((Map<String, String>)map);
    }

    public Form<T> fill(T value) {
        Map<String, String> map = this.mapping().unbind(value);
        Some some = Some$.MODULE$.apply(value);
        Mapping<T> mapping = this.copy$default$1();
        Seq<FormError> seq = this.copy$default$3();
        return this.copy(mapping, map, seq, (Option<T>)some);
    }

    public Form<T> fillAndValidate(T value) {
        Tuple2<Map<String, String>, Seq<FormError>> tuple2 = this.mapping().unbindAndValidate(value);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map data = (Map)tuple2._1();
        Seq errors = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)data, (Object)errors);
        Map data2 = (Map)tuple22._1();
        Seq errors2 = (Seq)tuple22._2();
        Some some = Some$.MODULE$.apply(value);
        Mapping<T> mapping = this.copy$default$1();
        return this.copy(mapping, (Map<String, String>)data2, (Seq<FormError>)errors2, (Option<T>)some);
    }

    public <R> R fold(Function1<Form<T>, R> hasErrors, Function1<T, R> success) {
        Option<T> option = this.value();
        if (option instanceof Some) {
            Object v = ((Some)option).value();
            if (this.errors().isEmpty()) {
                return (R)success.apply(v);
            }
        }
        return (R)hasErrors.apply((Object)this);
    }

    public Field apply(String key) {
        return Field$.MODULE$.apply(this, key, (Seq<Tuple2<String, Seq<Object>>>)((Seq)this.constraints().getOrElse((Object)key, Form::apply$$anonfun$1)), (Option<Tuple2<String, Seq<Object>>>)this.formats().get((Object)key), (Seq<FormError>)((Seq)this.errors().collect((PartialFunction)new Serializable(key){
            private final String key$3;
            {
                this.key$3 = key$7;
            }

            public final boolean isDefinedAt(FormError x) {
                FormError formError;
                FormError e = formError = x;
                String string = e.key();
                String string2 = this.key$3;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public final Object applyOrElse(FormError x, Function1 function1) {
                FormError formError;
                FormError e = formError = x;
                String string = e.key();
                String string2 = this.key$3;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return e;
                }
                return function1.apply((Object)x);
            }
        })), (Option<String>)this.data().get((Object)key));
    }

    public Option<FormError> globalError() {
        return this.globalErrors().headOption();
    }

    public Seq<FormError> globalErrors() {
        return (Seq)this.errors().filter((Function1 & Serializable)_$1 -> _$1.key().isEmpty());
    }

    public <R> R forField(String key, Function1<Field, R> handler) {
        return (R)handler.apply((Object)this.apply(key));
    }

    public boolean hasErrors() {
        return this.errors().nonEmpty();
    }

    public Option<FormError> error(String key) {
        return this.errors().find((Function1 & Serializable)_$2 -> {
            String string = _$2.key();
            String string2 = key;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Seq<FormError> errors(String key) {
        return (Seq)this.errors().filter((Function1 & Serializable)_$3 -> {
            String string = _$3.key();
            String string2 = key;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public boolean hasGlobalErrors() {
        return this.globalErrors().nonEmpty();
    }

    public T get() {
        return (T)this.value().get();
    }

    public JsValue errorsAsJson(MessagesProvider provider) {
        Messages messages = provider.messages();
        MapView map = this.errors().groupBy((Function1 & Serializable)_$4 -> _$4.key()).view().mapValues((Function1 & Serializable)_$5 -> (Seq)_$5.map((Function1 & Serializable)e -> messages.apply(e.message(), (Seq<Object>)((Seq)e.args().map((Function1 & Serializable)arg -> PlayMagic$.MODULE$.translate(arg, provider))))));
        return Json$.MODULE$.toJson((Object)map, (Writes)Writes$.MODULE$.genericMapWrites(Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())));
    }

    public Form<T> withError(FormError error2) {
        Seq seq = (Seq)this.errors().$colon$plus((Object)error2);
        None$ none$ = None$.MODULE$;
        Mapping<T> mapping = this.copy$default$1();
        Map<String, String> map = this.copy$default$2();
        return this.copy(mapping, map, (Seq<FormError>)seq, (Option<T>)none$);
    }

    public Form<T> withError(String key, String message, Seq<Object> args) {
        return this.withError(FormError$.MODULE$.apply(key, message, args));
    }

    public Form<T> withGlobalError(String message, Seq<Object> args) {
        return this.withError(FormError$.MODULE$.apply("", message, args));
    }

    public Form<T> discardingErrors() {
        Seq seq = (Seq)package$.MODULE$.Seq().empty();
        Mapping<T> mapping = this.copy$default$1();
        Map<String, String> map = this.copy$default$2();
        Option<T> option = this.copy$default$4();
        return this.copy(mapping, map, (Seq<FormError>)seq, option);
    }

    public <T> Form<T> copy(Mapping<T> mapping, Map<String, String> data, Seq<FormError> errors, Option<T> value) {
        return new Form<T>(mapping, data, errors, value);
    }

    public <T> Mapping<T> copy$default$1() {
        return this.mapping();
    }

    public <T> Map<String, String> copy$default$2() {
        return this.data();
    }

    public <T> Seq<FormError> copy$default$3() {
        return this.errors();
    }

    public <T> Option<T> copy$default$4() {
        return this.value();
    }

    public Mapping<T> _1() {
        return this.mapping();
    }

    public Map<String, String> _2() {
        return this.data();
    }

    public Seq<FormError> _3() {
        return this.errors();
    }

    public Option<T> _4() {
        return this.value();
    }

    private static final String $anonfun$1$$anonfun$2() {
        return "";
    }

    private static final Seq apply$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

