/*
 * Decompiled with CFR 0.152.
 */
package play.core.formatters;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.MultipartFormData$DataPart$;
import play.api.mvc.MultipartFormData$FilePart$;
import play.core.formatters.Multipart;
import play.core.formatters.Multipart$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public final class Multipart$
implements Serializable {
    private static final byte[] alphabet;
    public static final Multipart$ MODULE$;

    private Multipart$() {
    }

    static {
        MODULE$ = new Multipart$();
        alphabet = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Multipart$.class);
    }

    private String CrLf() {
        return "\r\n";
    }

    public Source<ByteString, ?> transform(Source<MultipartFormData.Part<Source<ByteString, ?>>, ?> body, String boundary) {
        return body.via(this.format(boundary, Charset.defaultCharset(), 4096));
    }

    public Flow<MultipartFormData.Part<Source<ByteString, ?>>, ByteString, NotUsed> format(String boundary, Charset nioCharset, int chunkSize) {
        return (Flow)Flow$.MODULE$.apply().via(this.streamed(boundary, nioCharset, chunkSize)).flatMapConcat((Function1 & Serializable)x -> (Graph)Predef$.MODULE$.identity(x));
    }

    public String randomBoundary(int length, Random random) {
        if (length < 1 || length > 70) {
            throw new IllegalArgumentException("length can't be greater than 70 or less than 1");
        }
        IndexedSeq bytes = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), length).map((Function1 & Serializable)object -> this.$anonfun$1(random, BoxesRunTime.unboxToInt((Object)object)));
        return new String((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), StandardCharsets.US_ASCII);
    }

    public int randomBoundary$default$1() {
        return 18;
    }

    public Random randomBoundary$default$2() {
        return ThreadLocalRandom.current();
    }

    public String escapeParamWithHTML5Strategy(String value) {
        return value.replace("\"", "%22").replace("\r", "%0D").replace("\n", "%0A");
    }

    private GraphStage<FlowShape<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>>> streamed(String boundary, Charset nioCharset, int chunkSize) {
        return new GraphStage<FlowShape<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>>>(boundary, nioCharset, chunkSize, this){
            public final String play$core$formatters$Multipart$$anon$1$$boundary$1;
            public final Charset play$core$formatters$Multipart$$anon$1$$nioCharset$1;
            public final int play$core$formatters$Multipart$$anon$1$$chunkSize$1;
            private final Inlet in;
            private final Outlet out;
            {
                this.play$core$formatters$Multipart$$anon$1$$boundary$1 = boundary$2;
                this.play$core$formatters$Multipart$$anon$1$$nioCharset$1 = nioCharset$2;
                this.play$core$formatters$Multipart$$anon$1$$chunkSize$1 = chunkSize$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.in = Inlet$.MODULE$.apply("CustomCharsetByteStringFormatter.in");
                this.out = Outlet$.MODULE$.apply("CustomCharsetByteStringFormatter.out");
            }

            public Inlet in() {
                return this.in;
            }

            public Outlet out() {
                return this.out;
            }

            public FlowShape shape() {
                return FlowShape$.MODULE$.of(this.in(), this.out());
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new OutHandler(this){
                    private boolean firstBoundaryRendered;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        this.firstBoundaryRendered = false;
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public boolean firstBoundaryRendered() {
                        return this.firstBoundaryRendered;
                    }

                    public void firstBoundaryRendered_$eq(boolean x$1) {
                        this.firstBoundaryRendered = x$1;
                    }

                    public void onPush() {
                        Tuple4 tuple4;
                        Multipart.CustomCharsetByteStringFormatter f = new Multipart.CustomCharsetByteStringFormatter(this.$outer.play$core$formatters$Multipart$$anon$1$$nioCharset$1, this.$outer.play$core$formatters$Multipart$$anon$1$$chunkSize$1);
                        MultipartFormData.Part bodyPart = (MultipartFormData.Part)this.grab(this.$outer.in());
                        Multipart$.MODULE$.play$core$formatters$Multipart$$$renderBoundary(f, this.$outer.play$core$formatters$Multipart$$anon$1$$boundary$1, !this.firstBoundaryRendered());
                        this.firstBoundaryRendered_$eq(true);
                        MultipartFormData.Part part = bodyPart;
                        if (part instanceof MultipartFormData.DataPart) {
                            MultipartFormData.DataPart dataPart = MultipartFormData$DataPart$.MODULE$.unapply((MultipartFormData.DataPart)part);
                            String string = dataPart._1();
                            String string2 = dataPart._2();
                            String innerKey = string;
                            tuple4 = Tuple4$.MODULE$.apply((Object)innerKey, (Object)None$.MODULE$, (Object)Option$.MODULE$.apply((Object)"text/plain"), (Object)"form-data");
                        } else if (part instanceof MultipartFormData.FilePart) {
                            MultipartFormData.FilePart<A> filePart = MultipartFormData$FilePart$.MODULE$.unapply((MultipartFormData.FilePart)part);
                            String string = filePart._1();
                            String string3 = filePart._2();
                            Option<String> option = filePart._3();
                            Source source = (Source)filePart._4();
                            long l = filePart._5();
                            String string4 = filePart._6();
                            Function1<A, Option<ByteString>> function1 = filePart._7();
                            String innerKey = string;
                            String innerFilename = string3;
                            Option<String> innerContentType = option;
                            String innerDispositionType = string4;
                            tuple4 = Tuple4$.MODULE$.apply((Object)innerKey, (Object)Option$.MODULE$.apply((Object)innerFilename), innerContentType, (Object)innerDispositionType);
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        Tuple4 tuple42 = tuple4;
                        if (tuple42 == null) {
                            throw new MatchError((Object)tuple42);
                        }
                        String key = (String)tuple42._1();
                        Option filename = (Option)tuple42._2();
                        Option contentType = (Option)tuple42._3();
                        String dispositionType = (String)tuple42._4();
                        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)key, (Object)filename, (Object)contentType, (Object)dispositionType);
                        String key2 = (String)tuple43._1();
                        Option filename2 = (Option)tuple43._2();
                        Option contentType2 = (Option)tuple43._3();
                        String dispositionType2 = (String)tuple43._4();
                        Multipart$.MODULE$.play$core$formatters$Multipart$$$renderDisposition(f, dispositionType2, key2, (Option<String>)filename2);
                        contentType2.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Multipart$.play$core$formatters$Multipart$$anon$1$$anon$2$$_$onPush$$anonfun$1(f, arg_0)));
                        Multipart$.MODULE$.play$core$formatters$Multipart$$$renderBuffer(f);
                        this.push(this.$outer.out(), Multipart$.play$core$formatters$Multipart$$anon$1$$anon$2$$_$completePartFormatting$1(f, bodyPart));
                    }

                    public void onPull() {
                        boolean finishing = this.isClosed(this.$outer.in());
                        if (finishing && this.firstBoundaryRendered()) {
                            Multipart.ByteStringFormatter f = new Multipart.ByteStringFormatter(this.$outer.play$core$formatters$Multipart$$anon$1$$boundary$1.length() + 4);
                            Multipart$.MODULE$.play$core$formatters$Multipart$$$renderFinalBoundary(f, this.$outer.play$core$formatters$Multipart$$anon$1$$boundary$1);
                            this.push(this.$outer.out(), Source$.MODULE$.single((Object)f.get()));
                            this.completeStage();
                            return;
                        }
                        if (finishing) {
                            this.completeStage();
                            return;
                        }
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFinish() {
                        if (this.isAvailable(this.$outer.out())) {
                            this.onPull();
                            return;
                        }
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$formatters$Multipart$$anon$1$$anon$2$$_$onPush$$anonfun$1(play.core.formatters.Multipart$CustomCharsetByteStringFormatter java.lang.String )}, serializedLambda);
                    }
                };
            }
        };
    }

    public void play$core$formatters$Multipart$$$renderBoundary(Multipart.Formatter f, String boundary, boolean suppressInitialCrLf) {
        if (!suppressInitialCrLf) {
            f.$tilde$tilde(this.CrLf());
        }
        f.$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde(this.CrLf());
    }

    private boolean renderBoundary$default$3() {
        return false;
    }

    public void play$core$formatters$Multipart$$$renderFinalBoundary(Multipart.Formatter f, String boundary) {
        f.$tilde$tilde(this.CrLf()).$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde('-').$tilde$tilde('-');
    }

    public void play$core$formatters$Multipart$$$renderDisposition(Multipart.Formatter f, String dispositionType, String contentDisposition, Option<String> filename) {
        f.$tilde$tilde("Content-Disposition: ").$tilde$tilde(dispositionType).$tilde$tilde("; name=").$tilde$tilde('\"').$tilde$tilde(this.escapeParamWithHTML5Strategy(contentDisposition)).$tilde$tilde('\"');
        filename.foreach((Function1 & Serializable)name -> f.$tilde$tilde("; filename=").$tilde$tilde('\"').$tilde$tilde(this.escapeParamWithHTML5Strategy((String)name)).$tilde$tilde('\"'));
        f.$tilde$tilde(this.CrLf());
    }

    private void renderContentType(Multipart.Formatter f, String contentType) {
        f.$tilde$tilde("Content-Type: ").$tilde$tilde(contentType).$tilde$tilde(this.CrLf());
    }

    public void play$core$formatters$Multipart$$$renderBuffer(Multipart.Formatter f) {
        f.$tilde$tilde(this.CrLf());
    }

    private final /* synthetic */ byte $anonfun$1(Random random$1, int n) {
        return alphabet[random$1.nextInt(alphabet.length)];
    }

    private static final Source bodyPartChunks$1(Multipart.CustomCharsetByteStringFormatter f$1, Source data) {
        return ((Source)Source$.MODULE$.single((Object)f$1.get()).$plus$plus((Graph)data)).mapMaterializedValue((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    public static final Source play$core$formatters$Multipart$$anon$1$$anon$2$$_$completePartFormatting$1(Multipart.CustomCharsetByteStringFormatter f$2, MultipartFormData.Part bodyPart$1) {
        MultipartFormData.Part part = bodyPart$1;
        if (part instanceof MultipartFormData.DataPart) {
            String string;
            MultipartFormData.DataPart dataPart = MultipartFormData$DataPart$.MODULE$.unapply((MultipartFormData.DataPart)part);
            String string2 = dataPart._1();
            String data = string = dataPart._2();
            return Source$.MODULE$.single((Object)f$2.$tilde$tilde(ByteString$.MODULE$.apply(data)).get());
        }
        if (part instanceof MultipartFormData.FilePart) {
            MultipartFormData.FilePart filePart = MultipartFormData$FilePart$.MODULE$.unapply((MultipartFormData.FilePart)part);
            String string = filePart._1();
            String string3 = filePart._2();
            Option<String> option = filePart._3();
            Source source = (Source)filePart._4();
            long l = filePart._5();
            String string4 = filePart._6();
            Function1 function1 = filePart._7();
            Source ref = source;
            return Multipart$.bodyPartChunks$1(f$2, ref);
        }
        throw new UnsupportedOperationException();
    }

    public static final /* synthetic */ void play$core$formatters$Multipart$$anon$1$$anon$2$$_$onPush$$anonfun$1(Multipart.CustomCharsetByteStringFormatter f$3, String ct) {
        MODULE$.renderContentType(f$3, ct);
    }
}

